/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.intv.service.questionnaire;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.intv.questionnaire.QuestionnaireDefaultConstants;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public final class QuestionnaireHelper
extends QuestionnaireDefaultConstants {
    private static final Log logger = LogFactory.getLog(QuestionnaireHelper.class);
    private static HRBaseServiceHelper helper_intvevlqunrdef = new HRBaseServiceHelper("tsrbd_intvevlqunrdef");
    private static HRBaseServiceHelper helper_inspectdim = new HRBaseServiceHelper("tsrbd_inspectdim");
    private static HRBaseServiceHelper helper_inspectdimop = new HRBaseServiceHelper("tsrbd_inspectdimop");
    private static HRBaseServiceHelper helper_intvEvlQunr = new HRBaseServiceHelper("tsrbd_intvevlqunr");
    private static HRBaseServiceHelper helper_intvEvlQunrOp = new HRBaseServiceHelper("tsrbd_intvevlqunrop");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDefaultQuestionnaire(long recruitmentId, Set<Long> orgIds, long questionnaireId, String evltype) {
        try (TXHandle tx = TX.required();){
            QFilter qFilter = new QFilter("reccategory", "=", (Object)recruitmentId).and(new QFilter("useorg", "in", orgIds).and(new QFilter("intvevlqunr.evltype", "=", (Object)evltype))).or(new QFilter("intvevlqunr", "=", (Object)questionnaireId));
            helper_intvevlqunrdef.deleteByFilter(new QFilter[]{qFilter});
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(orgIds.size());
            for (Long orgId : orgIds) {
                DynamicObject dy = helper_intvevlqunrdef.generateEmptyDynamicObject();
                dy.set("useorg", (Object)orgId);
                dy.set("reccategory", (Object)recruitmentId);
                dy.set("intvevlqunr", (Object)questionnaireId);
                dy.set("creator", (Object)TSCRequestContext.getUserId());
                dy.set("createtime", (Object)DateUtils.nowDateTime());
                list.add(dy);
            }
            helper_intvevlqunrdef.save(list.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject[] findDefaultQuestionnaireByQuestionnaire(Object pk) {
        QFilter qFilter = new QFilter("intvevlqunr", "=", pk);
        return helper_intvevlqunrdef.query(String.join((CharSequence)",", "id", "useorg"), new QFilter[]{qFilter});
    }

    public static boolean isExistsDefaultQuestionnaireByQuestionnaire(Object pk) {
        QFilter qFilter = new QFilter("intvevlqunr", "=", pk);
        return helper_intvevlqunrdef.isExists(new QFilter[]{qFilter});
    }

    public static DynamicObject[] findDefaultQuestionnaireByUseOrgAndReccategory(Object useOrg, Object reccategoryId) {
        QFilter qFilter = new QFilter("useorg", "=", (Object)Long.valueOf(useOrg + "")).and("reccategory", "=", (Object)Long.valueOf(reccategoryId + ""));
        return helper_intvevlqunrdef.query(String.join((CharSequence)",", "id", "useorg", "intvevlqunr"), new QFilter[]{qFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInspectDimOp(DynamicObject[] dynamicObjects, long questionnaireId) {
        try (TXHandle tx = TX.required();){
            QuestionnaireHelper.destroyInspectDimensionByQuestionnaireId(questionnaireId);
            helper_inspectdimop.save(dynamicObjects);
        }
    }

    public static void destroyInspectDimensionByQuestionnaireId(long questionnaireId) {
        QFilter qFilter = new QFilter("intvevlqunrid", "=", (Object)questionnaireId);
        helper_inspectdimop.deleteByFilter(new QFilter[]{qFilter});
    }

    public static DynamicObject[] findInspectDimOpAllFieldByIds(Object[] pkArray) {
        return helper_inspectdimop.loadDynamicObjectArray(pkArray);
    }

    public static DynamicObject findQuestionnaireById(Object pk) {
        return helper_intvEvlQunr.isExists(pk) ? helper_intvEvlQunr.loadSingle(pk) : null;
    }

    public static DynamicObject findQuestionnaireOpById(Object pk) {
        return helper_intvEvlQunrOp.isExists(pk) ? helper_intvEvlQunrOp.loadSingle(pk) : null;
    }

    public static DynamicObject[] findInspectDimOpByQuestionnaireId(String questionnaireId) {
        String fields = String.join((CharSequence)",", "id", "name", "index", "intvevlqunrid", "questiontype", "questiondesc", "required", "questioncontent", "description", "enablecomment", "requiredcomment", "fdetialid", "optionname", "questionentry.seq", "optionsubentry.seq");
        QFilter qFilter = new QFilter("intvevlqunrid", "=", (Object)Long.valueOf(questionnaireId));
        return helper_inspectdimop.query(fields, new QFilter[]{qFilter});
    }

    public static DynamicObject generateEmptyInspectDimOp() {
        return helper_inspectdimop.generateEmptyDynamicObject();
    }

    public static void showIntvEvlPage(String evlId, String evlFormId, String sourceType, String classFullName, IFormView view, Object previewData) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tspr_intvevl");
        showParameter.setPkId((Object)evlId);
        showParameter.setCustomParam("evlId", (Object)evlId);
        showParameter.setCustomParam("evlFormId", (Object)evlFormId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("previewData", previewData);
        if (HRStringUtils.isNotEmpty((String)classFullName)) {
            showParameter.setCloseCallBack(new CloseCallBack(classFullName, "evlFormSubmit"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showTsrbdIntvEvlPage(String evlId, String evlFormId, String sourceType, String classFullName, IFormView view, Object previewData) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsrbd_intvevl");
        showParameter.setPkId((Object)evlId);
        showParameter.setCustomParam("evlId", (Object)evlId);
        showParameter.setCustomParam("evlFormId", (Object)evlFormId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("previewData", previewData);
        if (HRStringUtils.isNotEmpty((String)classFullName)) {
            showParameter.setCloseCallBack(new CloseCallBack(classFullName, "evlFormSubmit"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showIntvEvlPage(String evlId, String evlFormId, String sourceType, IFormView view, Object previewData) {
        QuestionnaireHelper.showIntvEvlPage(evlId, evlFormId, sourceType, null, view, previewData);
    }

    public static Long getDefaultIntEvaTable(Long orgId, Long recruitTypId, Long posRecScene) {
        if (recruitTypId == null) {
            return null;
        }
        HRBaseServiceHelper presetIntEvaHelper = new HRBaseServiceHelper("tsrbd_intvevlqunr");
        QFilter orgCurFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_intvevlqunr", (Long)orgId);
        if (orgCurFilter == null) {
            return null;
        }
        QFilter defaultFilter = new QFilter("group", "=", (Object)recruitTypId);
        orgCurFilter.and(defaultFilter);
        if (posRecScene != null) {
            QFilter recSceneFilter = new QFilter("recruscene.fbasedataid_id", "=", (Object)posRecScene);
            recSceneFilter.or(new QFilter("recruscene.fbasedataid_id", "is null", null));
            orgCurFilter.and(recSceneFilter);
        }
        orgCurFilter.and(new QFilter("evltype", "=", (Object)"1"));
        orgCurFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] objectsDyn = presetIntEvaHelper.queryOriginalArray("id,recruscene.fbasedataid_id,modifytime", new QFilter[]{orgCurFilter}, "modifytime desc");
        if (objectsDyn == null || objectsDyn.length == 0) {
            return null;
        }
        for (DynamicObject dy : objectsDyn) {
            if (dy.get("recruscene.fbasedataid_id") == null || posRecScene == null || !posRecScene.equals(dy.getLong("recruscene.fbasedataid_id"))) continue;
            return dy.getLong("id");
        }
        return objectsDyn[0].getLong("id");
    }

    public static void showTsirmIntvEvlPage(String evlId, String evlFormId, String sourceType, String classFullName, IFormView view, Object previewData, String evlForm) {
        String pageId = (String)view.getFormShowParameter().getCustomParam("pageId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(evlForm);
        showParameter.setPkId((Object)evlId);
        showParameter.setCustomParam("evlId", (Object)evlId);
        showParameter.setCustomParam("evlFormId", (Object)evlFormId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("previewData", previewData);
        showParameter.setCustomParam("pageId", (Object)pageId);
        if (HRStringUtils.isNotEmpty((String)classFullName)) {
            showParameter.setCloseCallBack(new CloseCallBack(classFullName, "evlFormSubmit"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showTsirmIntvEvlPageInModel(String evlId, String evlFormId, String sourceType, String classFullName, IFormView view, Object previewData, String evlForm, String targetKey) {
        String pageId = (String)view.getFormShowParameter().getCustomParam("pageId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(evlForm);
        showParameter.setPkId((Object)evlId);
        showParameter.setCustomParam("evlId", (Object)evlId);
        showParameter.setCustomParam("evlFormId", (Object)evlFormId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("previewData", previewData);
        showParameter.setCustomParam("pageId", (Object)pageId);
        showParameter.setCustomParam("showTitle", (Object)false);
        showParameter.setCustomParam("showCloseAndCancel", (Object)false);
        if (HRStringUtils.isNotEmpty((String)classFullName)) {
            showParameter.setCloseCallBack(new CloseCallBack(classFullName, "evlFormSubmit"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        StyleCss css = new StyleCss();
        css.setWidth("20%");
        css.setHeight("100%");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        view.showForm((FormShowParameter)showParameter);
    }
}

