/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;

public class DimensionCache
extends QuestionCache {
    private static final String CACHE_KEY_INSPECT_DIMENSION = "evaluationDimension";
    private static final String CACHE_KEY_IS_CHANGE_INSPECT_DIMENSION = Boolean.FALSE.toString();

    public static List<DimensionCacheModel> getInspectDimension(IFormView view) {
        String inspectDimensionStr = view.getPageCache().get(CACHE_KEY_INSPECT_DIMENSION);
        if (HRStringUtils.isEmpty((String)inspectDimensionStr)) {
            return null;
        }
        return JSON.parseArray((String)inspectDimensionStr, DimensionCacheModel.class);
    }

    public static void putInspectDimension(Collection<DimensionCacheModel> col, IFormView view) {
        view.getPageCache().put(CACHE_KEY_INSPECT_DIMENSION, JSON.toJSONString(col));
    }

    public static void removeInspectDimension(String id, IFormView view) {
        List<DimensionCacheModel> models = DimensionCache.getInspectDimension(view);
        if (models == null || models.isEmpty()) {
            return;
        }
        for (DimensionCacheModel model : models) {
            if (!id.equals(String.valueOf(model.getId()))) continue;
            models.remove(model);
            break;
        }
        DimensionCache.putInspectDimension(models, view);
    }

    public static DimensionCacheModel processDyToInspectDimensionOpCacheModel(DynamicObject inspect) {
        DimensionCacheModel model = new DimensionCacheModel();
        model.setId(Long.valueOf(inspect.getLong("id")));
        model.setIndex(Integer.valueOf(inspect.getInt("seq")));
        model.setDescription(QuestionnaireCache.processLocaleStringToCacheModel(inspect.getLocaleString("inspectdimdesc"), "inspectdimdesc"));
        model.setName(QuestionnaireCache.processLocaleStringToCacheModel(inspect.getLocaleString("inspectdimname"), "inspectdimname"));
        model.setIntvevlqunrid(Long.valueOf(inspect.getLong("intvevlqunrid")));
        return model;
    }

    public static String getIsChangeInspectDimension(IFormView view) {
        return view.getPageCache().get(CACHE_KEY_IS_CHANGE_INSPECT_DIMENSION);
    }

    public static void putIsChangeInspectDimension(IFormView view, String ret) {
        view.getPageCache().put(CACHE_KEY_IS_CHANGE_INSPECT_DIMENSION, ret);
    }

    public static void removeIsChangeIsnspectDimension(IFormView view) {
        view.getPageCache().remove(CACHE_KEY_IS_CHANGE_INSPECT_DIMENSION);
    }
}

