/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.form.IFormView;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.constants.intv.model.DimensionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.OptionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionnaireCacheModel;
import kd.tsc.tsrbd.common.entity.evalform.InspectDimensGroup;
import kd.tsc.tsrbd.common.entity.evalform.OptionGroup;
import kd.tsc.tsrbd.common.entity.evalform.SubjectGroup;

public class ParseCache {
    public static Object processLocaleStringToCacheModel(Object object, String fieldKey) {
        LocaleString str;
        block3: {
            block2: {
                str = new LocaleString();
                if (!(object instanceof OrmLocaleValue)) break block2;
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)object;
                for (String key : ormLocaleValue.keySet()) {
                    str.put(key, (Object)ormLocaleValue.get((Object)key));
                }
                break block3;
            }
            if (!(object instanceof LocaleDynamicObjectCollection)) break block3;
            LocaleDynamicObjectCollection localeDynamicObjects = (LocaleDynamicObjectCollection)object;
            for (DynamicObject locale : localeDynamicObjects) {
                str.put(locale.getString("localeid"), (Object)locale.getString(fieldKey));
            }
        }
        return str;
    }

    public static LocaleString parseCacheFieldToLocaleString(Object text) {
        LocaleString localeString = new LocaleString();
        if (text instanceof LocaleString) {
            return (LocaleString)text;
        }
        if (text instanceof JSONArray) {
            JSONArray questionContents = (JSONArray)text;
            for (Object questionContent : questionContents) {
                JSONObject jsonObject = (JSONObject)questionContent;
                for (String key : jsonObject.keySet()) {
                    localeString.put(key, (Object)jsonObject.getString(key));
                }
            }
        }
        if (text instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)text;
            for (String key : jsonObject.keySet()) {
                localeString.put(key, (Object)jsonObject.getString(key));
            }
        }
        return localeString;
    }

    public static Map<String, String> transferCacheModeToViewModel(IFormView view) {
        List<DimensionCacheModel> inspects;
        HashMap<String, String> paramMap = new HashMap<String, String>(4, 1.0f);
        QuestionnaireCacheModel questionnaire = QuestionnaireCache.getCacheData(view);
        if (questionnaire != null) {
            paramMap.put("name", QuestionnaireCache.parseCacheFieldToLocaleString(questionnaire.getName()).getLocaleValue());
            paramMap.put("desc", QuestionnaireCache.parseCacheFieldToLocaleString(questionnaire.getDescription()).getLocaleValue());
        }
        if ((inspects = QuestionnaireCache.getInspectDimension(view)) == null || inspects.isEmpty()) {
            return paramMap;
        }
        ArrayList<InspectDimensGroup> evalForm = new ArrayList<InspectDimensGroup>(inspects.size());
        for (int i = 0; i < inspects.size(); ++i) {
            DimensionCacheModel inspect = inspects.get(i);
            InspectDimensGroup inspectDimensGroup = new InspectDimensGroup();
            inspectDimensGroup.setId(String.valueOf(i));
            inspectDimensGroup.setTitle(QuestionnaireCache.parseCacheFieldToLocaleString(inspect.getName()).getLocaleValue());
            inspectDimensGroup.setDescription(QuestionnaireCache.parseCacheFieldToLocaleString(inspect.getDescription()).getLocaleValue());
            inspectDimensGroup.setIndex(i);
            evalForm.add(inspectDimensGroup);
            List<QuestionCacheModel> questionCache = QuestionnaireCache.getQuestionCache(view, String.valueOf(inspect.getId()));
            if (questionCache == null || questionCache.isEmpty()) continue;
            ArrayList<SubjectGroup> subjectGroupList = new ArrayList<SubjectGroup>(questionCache.size());
            for (int j = 0; j < questionCache.size(); ++j) {
                QuestionCacheModel question = questionCache.get(j);
                SubjectGroup subjectGroup = new SubjectGroup();
                subjectGroup.setqId(String.valueOf(j));
                subjectGroup.setqTitle(QuestionnaireCache.parseCacheFieldToLocaleString(question.getQuestionContent()).getLocaleValue());
                subjectGroup.setqDesc(QuestionnaireCache.parseCacheFieldToLocaleString(question.getQuestionDesc()).getLocaleValue());
                subjectGroup.setIsReqComment(question.getRequiredComment());
                subjectGroup.setIsRequired(question.getRequired());
                subjectGroup.setType(QuestionContext.getStrategyMap().get(question.getQuestionType()).getQuestionTypeName());
                subjectGroup.setIsHaveComment(question.getEnableComment());
                subjectGroup.setIndex(j);
                subjectGroupList.add(subjectGroup);
                if (question.getOptions() == null || question.getOptions().isEmpty()) continue;
                List options = question.getOptions();
                ArrayList<OptionGroup> optionGroupList = new ArrayList<OptionGroup>(options.size());
                ParseCache.innerMethod(options, optionGroupList);
                subjectGroup.setItems(optionGroupList);
            }
            inspectDimensGroup.setContent(subjectGroupList);
        }
        paramMap.put("content", JSONObject.toJSONString(evalForm));
        return paramMap;
    }

    private static void innerMethod(List<OptionCacheModel> options, List<OptionGroup> optionGroupList) {
        for (int k = 0; k < options.size(); ++k) {
            OptionCacheModel option = options.get(k);
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setsId(String.valueOf(k));
            optionGroup.setName(QuestionnaireCache.parseCacheFieldToLocaleString(option.getName()).getLocaleValue());
            optionGroup.setIndex(k);
            optionGroupList.add(optionGroup);
        }
    }
}

