/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.ParseCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.cache.QuestionnaireCache;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.IQuestionHandlerStrategy;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.constants.intv.model.OptionCacheModel;
import kd.tsc.tsrbd.common.constants.intv.model.QuestionCacheModel;
import org.apache.commons.collections4.CollectionUtils;

public class QuestionCache
extends ParseCache {
    private static final Log LOGGER = LogFactory.getLog(QuestionCache.class);
    private static final String CACHE_KEY_ADDBUTTONKEY = "addButtonKey";
    private static final String CACHE_KEY_OPTIONBUTTONROWINDEX = "optionButtonRowIndex";
    private static final String CACHE_KEY_IS_CHANGE_QUESTION = Boolean.FALSE.toString();

    public static List<QuestionCacheModel> getQuestionCache(IFormView view) {
        IPageCache parentPageCache = view.getPageCache();
        String cacheData = parentPageCache.get(QuestionnaireCache.getActiveBoxIdFromCache(view));
        return HRStringUtils.isEmpty((String)cacheData) ? new ArrayList(20) : JSON.parseArray((String)cacheData, QuestionCacheModel.class);
    }

    public static void putQuestionCache(List<QuestionCacheModel> cacheData, IFormView view) {
        QuestionCache.putQuestionCache(cacheData, view, QuestionnaireCache.getActiveBoxIdFromCache(view));
    }

    public static void putQuestionCache(List<QuestionCacheModel> cacheData, IFormView view, String inspectId) {
        view.getPageCache().put(inspectId, JSON.toJSONString(cacheData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    public static void removeQuestionCache(IFormView view, String key) {
        view.getPageCache().remove(key);
    }

    public static QuestionCacheModel addQuestionCache(String questionType, IFormView view) {
        List<QuestionCacheModel> questions = QuestionCache.getQuestionCache(view);
        QuestionCacheModel model = new QuestionCacheModel();
        model.setQuestionType(questionType);
        IQuestionHandlerStrategy strategy = QuestionContext.getStrategyMap().get(questionType);
        strategy.addDefaultOption(model);
        questions.add(model);
        QuestionCache.putQuestionCache(questions, view);
        return model;
    }

    public static void deleteCache(int index, IFormView view) {
        List<QuestionCacheModel> cacheData = QuestionCache.getQuestionCache(view);
        if (!cacheData.isEmpty() && cacheData.size() > index) {
            cacheData.remove(index);
            QuestionCache.putQuestionCache(cacheData, view);
        }
    }

    public static void modifyCacheProperty(String propertyName, Object propertyValue, int rowIndex, IFormView view) {
        List<QuestionCacheModel> cacheData = QuestionCache.getQuestionCache(view);
        if (CollectionUtils.isEmpty(cacheData)) {
            return;
        }
        QuestionCacheModel cacheModel = cacheData.get(rowIndex);
        Method[] methods = QuestionCacheModel.class.getDeclaredMethods();
        try {
            for (Method method : methods) {
                if ("modifyOptionName".equals(method.getName()) && propertyName.startsWith("content")) {
                    String index = propertyName.replace("content", "");
                    method.invoke((Object)cacheModel, Integer.valueOf(index), propertyValue);
                    continue;
                }
                if (!method.getName().startsWith("set") || !method.getName().toLowerCase().contains(propertyName)) continue;
                method.invoke((Object)cacheModel, propertyValue);
            }
        }
        catch (IllegalAccessException e1) {
            LOGGER.error("modify cache property failed :{}", (Object)e1.getMessage());
        }
        catch (InvocationTargetException e1) {
            LOGGER.error("modify cache property failed :{}", (Object)e1.getMessage());
        }
        QuestionCache.putQuestionCache(cacheData, view);
    }

    public static List<QuestionCacheModel> getQuestionCache(IFormView view, String inspectId) {
        String jsonStr = view.getPageCache().get(inspectId);
        if (HRStringUtils.isEmpty((String)jsonStr)) {
            return null;
        }
        return JSON.parseArray((String)jsonStr, QuestionCacheModel.class);
    }

    public static String getCurrentOperationRowIndex(IFormView view) {
        return view.getPageCache().get(CACHE_KEY_OPTIONBUTTONROWINDEX);
    }

    public static void removeCurrentOperationRowIndex(IFormView view) {
        view.getPageCache().remove(CACHE_KEY_OPTIONBUTTONROWINDEX);
    }

    public static void putCurrentOperationRowIndex(IFormView view, String indexRow) {
        view.getPageCache().put(CACHE_KEY_OPTIONBUTTONROWINDEX, indexRow);
    }

    public static void putAddQuestionButtonType(IFormView view, String key) {
        view.getPageCache().put(CACHE_KEY_ADDBUTTONKEY, key);
    }

    public static String getAddQuestionButtonType(IFormView view) {
        return view.getPageCache().get(CACHE_KEY_ADDBUTTONKEY);
    }

    public static void removeAddQuestionButtonType(IFormView view) {
        view.getPageCache().remove(CACHE_KEY_ADDBUTTONKEY);
    }

    public static String getIsChangeQuestion(IFormView view) {
        return view.getPageCache().get(CACHE_KEY_IS_CHANGE_QUESTION);
    }

    public static void putIsChangeQuestion(IFormView view, String ret) {
        view.getPageCache().put(CACHE_KEY_IS_CHANGE_QUESTION, ret);
    }

    public static void removeIsChangeQuestion(IFormView view) {
        view.getPageCache().remove(CACHE_KEY_IS_CHANGE_QUESTION);
    }

    public static List<QuestionCacheModel> processDyToCacheModel(DynamicObjectCollection questions) {
        TreeSet<QuestionCacheModel> questionSet = new TreeSet<QuestionCacheModel>();
        for (DynamicObject question : questions) {
            QuestionCacheModel model = new QuestionCacheModel();
            questionSet.add(model);
            model.setQuestionType(question.getString("questiontype"));
            model.setEnableComment(Boolean.valueOf(question.getBoolean("enablecomment")));
            model.setId(Long.valueOf(question.getLong("id")));
            model.setRequired(Boolean.valueOf(question.getBoolean("required")));
            model.setRequiredComment(Boolean.valueOf(question.getBoolean("requiredcomment")));
            model.setIndex(Integer.valueOf(question.getInt("seq")));
            model.setQuestionContent(QuestionCache.processLocaleStringToCacheModel(question.get("questioncontent"), null));
            model.setQuestionDesc(QuestionCache.processLocaleStringToCacheModel(question.get("questiondesc"), null));
            if ("C".equals(model.getQuestionType())) continue;
            DynamicObjectCollection options = question.getDynamicObjectCollection("optionsubentry");
            TreeSet<OptionCacheModel> optionSet = new TreeSet<OptionCacheModel>();
            for (DynamicObject option : options) {
                OptionCacheModel optionModel = new OptionCacheModel();
                optionModel.setId(Long.valueOf(option.getLong("id")));
                optionModel.setName(QuestionCache.processLocaleStringToCacheModel(option.get("optionname"), null));
                optionModel.setIndex(Integer.valueOf(option.getInt("seq")));
                optionSet.add(optionModel);
            }
            model.setOptions(new ArrayList(optionSet));
        }
        return new ArrayList<QuestionCacheModel>(questionSet);
    }

    public static DynamicObjectCollection parseQuestionCache(DynamicObjectCollection questionEntry, List<QuestionCacheModel> questionsCache) {
        for (int i = 0; i < questionsCache.size(); ++i) {
            QuestionCacheModel questionCache = questionsCache.get(i);
            DynamicObject question = questionEntry.addNew();
            question.set("questiontype", (Object)questionCache.getQuestionType());
            question.set("questioncontent", (Object)QuestionCache.parseCacheFieldToLocaleString(questionCache.getQuestionContent()));
            question.set("questiondesc", (Object)QuestionCache.parseCacheFieldToLocaleString(questionCache.getQuestionDesc()));
            question.set("required", (Object)questionCache.getRequired());
            question.set("enablecomment", (Object)questionCache.getEnableComment());
            question.set("requiredcomment", (Object)questionCache.getRequiredComment());
            if (questionCache.getId() == null) {
                questionCache.setId(Long.valueOf(ID.genLongId()));
            }
            question.set("id", (Object)questionCache.getId());
            question.set("seq", (Object)(i + 1));
            QuestionCache.parseOptionCache(question, questionCache);
        }
        return questionEntry;
    }

    private static void parseOptionCache(DynamicObject question, QuestionCacheModel questionCache) {
        if ("C".equals(questionCache.getQuestionType()) || CollectionUtils.isEmpty((Collection)questionCache.getOptions())) {
            return;
        }
        DynamicObjectCollection options = question.getDynamicObjectCollection("optionsubentry");
        options.clear();
        List optionsCache = questionCache.getOptions();
        for (int r = 0; r < optionsCache.size(); ++r) {
            OptionCacheModel optionModel = (OptionCacheModel)optionsCache.get(r);
            DynamicObject option = options.addNew();
            option.set("optionname", (Object)QuestionCache.parseCacheFieldToLocaleString(optionModel.getName()));
            if (optionModel.getId() == null) {
                optionModel.setId(Long.valueOf(ID.genLongId()));
            }
            option.set("id", (Object)optionModel.getId());
            option.set("seq", (Object)(r + 1));
        }
    }
}

