/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.intvfile;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class IntvFileHelper {
    public static final Log log = LogFactory.getLog(IntvFileHelper.class);
    private static final HRBaseServiceHelper INTV_FILE = new HRBaseServiceHelper("tsrbd_intverfile");
    private static final HRBaseServiceHelper INTV_FILE_ENTRY = new HRBaseServiceHelper("tsrbd_intverfileentry");

    private IntvFileHelper() {
    }

    public static IntvFileHelper getInstance() {
        return IntvFileHelperHolder.INSTANCE;
    }

    public DynamicObject[] getUserByFileId(Object[] intvFileIds) {
        return INTV_FILE.loadDynamicObjectArray(intvFileIds);
    }

    public DynamicObject[] getUserByFileNumber(Object[] intvFileIds) {
        QFilter[] qFilters = new QFilter("number", "in", (Object)intvFileIds).toArray();
        return INTV_FILE.loadDynamicObjectArray(qFilters);
    }

    public DynamicObject getIntverFileByUserId(Long userId) {
        return INTV_FILE.queryOne(new QFilter[]{new QFilter("user.id", "=", (Object)userId)});
    }

    public DynamicObject[] getIntverFileByUserId(List<Long> userIds) {
        return INTV_FILE.queryOriginalArray("id,user.id userid", new QFilter[]{new QFilter("user.id", "in", userIds), this.getIntverTimeFilter()});
    }

    public DynamicObject[] getIntverFileById(List<Long> ids) {
        return INTV_FILE.queryOriginalArray("id,user.id userid", new QFilter[]{new QFilter("id", "in", ids), this.getIntverTimeFilter()});
    }

    public QFilter getIntverTimeFilter() {
        return new QFilter("tsrbd_intverfileentry.expiretime", ">=", (Object)LocalDateTime.now()).and(new QFilter("tsrbd_intverfileentry.entryenable", "=", (Object)"1"));
    }

    public QFilter getIntverEntryTimeFilter() {
        return new QFilter("tsrbd_intverfileentry.expiretime", ">=", (Object)LocalDateTime.now()).and(new QFilter("tsrbd_intverfileentry.enable", "=", (Object)"1"));
    }

    public QFilter getIntverF7TimeFilter() {
        return new QFilter("tssrm_intverfilef7entry.expiretime", ">=", (Object)LocalDateTime.now()).and(new QFilter("tssrm_intverfilef7entry.entryenable", "=", (Object)"1"));
    }

    public QFilter getIntverF7TimeFilterTSRF() {
        return new QFilter("tsrf_intverfilef7entry.expiretime", ">=", (Object)LocalDateTime.now()).and(new QFilter("tsrf_intverfilef7entry.entryenable", "=", (Object)"1"));
    }

    public DynamicObject getFistEnableFile(long Id) {
        QFilter intverFileFilter = new QFilter("intverfile.id", "=", (Object)Id);
        Object[] lastExpireData = INTV_FILE_ENTRY.query("id", new QFilter[]{this.getIntverEntryTimeFilter(), intverFileFilter}, "efftime asc", 1);
        if (!HRArrayUtils.isEmpty((Object[])lastExpireData)) {
            return lastExpireData[0];
        }
        return null;
    }

    public boolean isInterviewer(Long userId) {
        return INTV_FILE.isExists(this.getIntverTimeFilter().and(new QFilter("user.id", "=", (Object)userId)));
    }

    private static class IntvFileHelperHolder {
        private static final IntvFileHelper INSTANCE = new IntvFileHelper();

        private IntvFileHelperHolder() {
        }
    }
}

