/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.label.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.business.domain.common.service.TscDispatchServiceHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.business.domain.label.service.PortraitServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.common.entity.label.SimplifiedTag;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang.StringUtils;

public class AILabelApiServiceHelper {
    private static HRBaseServiceHelper labelTypeServiceHelper = new HRBaseServiceHelper("tsrbd_ailabel");
    private static HRBaseServiceHelper labelServiceHelper = new HRBaseServiceHelper("tsrbd_label");
    private static LabelTagObjServiceHelper labelTagObjService;
    private static AILabelApiServiceHelper aILabelApiServiceHelper;
    private static final Log logger;

    private AILabelApiServiceHelper() {
    }

    public static AILabelApiServiceHelper getInstance() {
        return aILabelApiServiceHelper;
    }

    public void addAILabel(Map<String, Object> body) {
        Long tagObjId = Long.valueOf(body.get("tagobjid").toString());
        Long tagObjTypeId = Long.valueOf(body.get("tagobjtypeid").toString());
        String inputParam = body.get("data").toString();
        logger.info("AILabelAPI getCVTag request param : {}", (Object)inputParam);
        JSONObject resultJson = TscDispatchServiceHelper.invokeBizServiceByMap("getCVTag", body);
        logger.info("AILabelAPI getCVTag result param : {}", (Object)resultJson);
        if (null != resultJson && null != resultJson.getJSONObject("result")) {
            this.savePortrait(resultJson, tagObjId, tagObjTypeId);
            this.saveLabel(resultJson, tagObjId, tagObjTypeId);
        }
    }

    private void saveLabel(JSONObject resultJson, Long tagObjId, Long tagObjTypeId) {
        JSONArray simplified_tag = resultJson.getJSONObject("result").getJSONArray("simplified_tag");
        if (null == simplified_tag) {
            logger.error("AILabelAPI getCVTag result simplified_tag is empty");
            return;
        }
        labelTagObjService = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId));
        labelTagObjService.deleteOld(tagObjTypeId, tagObjId, "C", null);
        List simplified_tags = simplified_tag.toJavaList(SimplifiedTag.class);
        Map<String, DynamicObject> labelTypeMap = this.getLabelTypeToMap();
        Map<String, Long> labelMap = this.getLabelToMap();
        ArrayList<DynamicObject> labelTagObjList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> labelList = new ArrayList<DynamicObject>(16);
        for (SimplifiedTag obj : simplified_tags) {
            String name = obj.getName();
            DynamicObject labelType = labelTypeMap.get(name);
            if (labelType == null) continue;
            Long labelTypeId = labelType.getLong("id");
            String display = labelType.getString("display");
            List labelNames = obj.getValue();
            if (labelNames == null) continue;
            labelNames = labelNames.stream().filter(Objects::nonNull).collect(Collectors.toList());
            for (Object labelName : labelNames) {
                if ("age_tag".equals(name) && !"\u5e74\u9f84\u504f\u5927".equals(labelName)) continue;
                if ("is_double_degree".equals(name)) {
                    if (!"Y".equals(labelName)) continue;
                    labelName = "\u53cc\u5b66\u4f4d";
                } else if ("school_position_list".equals(name)) {
                    if (labelName == null) continue;
                    labelName = "\u6821\u5185\u62c5\u4efb" + labelName;
                } else if ("is_oversea_education".equals(name)) {
                    if (!"Y".equals(labelName)) continue;
                    labelName = "\u7559\u5b66\u7ecf\u5386";
                } else if ("is_founder".equals(name)) {
                    if (!"Y".equals(labelName)) continue;
                    labelName = "\u521b\u4e1a\u7ecf\u5386";
                } else if ("is_oversea_employment".equals(name)) {
                    if (!"Y".equals(labelName)) continue;
                    labelName = "\u6d77\u5916\u5de5\u4f5c\u7ecf\u5386";
                } else if ("total_work_duration".equals(name)) {
                    if (labelName == null || !(Double.parseDouble(labelName.toString()) > 0.0)) continue;
                    labelName = labelName + "\u5e74\u5de5\u4f5c\u7ecf\u9a8c";
                } else if ("total_management_duration".equals(name)) {
                    if (labelName == null || !(Double.parseDouble(labelName.toString()) > 0.0)) continue;
                    labelName = labelName + "\u5e74\u7ba1\u7406";
                } else if ("patents_count".equals(name)) {
                    if (labelName == null || !(Double.parseDouble(labelName.toString()) > 0.0)) continue;
                    labelName = labelName + "\u9879\u4e13\u5229";
                } else if ("work_hopping_label".equals(name)) {
                    if (labelName == null) continue;
                    labelName = "\u8df3\u69fd\u9891\u5ea6" + labelName;
                } else if ("job_skill_list".equals(name)) {
                    if (labelName == null) continue;
                    String strName = labelName.toString();
                    if (strName.contains("|")) {
                        labelName = strName.substring(0, strName.lastIndexOf(124));
                    }
                }
                Long labelId = labelMap.get(labelName);
                if (null == labelId) {
                    DynamicObject labelObj = this.getInitLabel(labelTypeId, display, labelName.toString());
                    labelId = labelObj.getLong("id");
                    labelList.add(labelObj);
                }
                DynamicObject labelTagObj = labelTagObjService.getInitLabelTagObj(tagObjTypeId, tagObjId, "C", labelId);
                labelTagObjList.add(labelTagObj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])labelList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])labelTagObjList.toArray(new DynamicObject[0]));
    }

    private Map<String, Long> getLabelToMap() {
        HashMap<String, Long> map = new HashMap<String, Long>(25);
        QFilter labelCategory = new QFilter("labelcategory", "=", (Object)"C");
        QFilter[] aiFilters = new QFilter[]{labelCategory};
        DynamicObject[] aiLabelObjs = labelServiceHelper.loadDynamicObjectArray(aiFilters);
        if (null != aiLabelObjs && aiLabelObjs.length > 0) {
            for (DynamicObject obj : aiLabelObjs) {
                map.put(obj.getString("name"), obj.getLong("id"));
            }
        }
        return map;
    }

    private Map<String, DynamicObject> getLabelTypeToMap() {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(25);
        DynamicObject[] labelObjs = labelTypeServiceHelper.loadDynamicObjectArray(null);
        if (null != labelObjs && labelObjs.length > 0) {
            for (DynamicObject obj : labelObjs) {
                map.put(obj.getString("code"), obj);
            }
        }
        return map;
    }

    public Long createAILabel(Long labelTypeId, String display, String labelName) {
        DynamicObject labelObj = this.getInitLabel(labelTypeId, display, labelName);
        labelServiceHelper.saveOne(labelObj);
        return labelObj.getLong("id");
    }

    public DynamicObject getInitLabel(Long labelTypeId, String display, String labelName) {
        DynamicObject labelObj = labelServiceHelper.generateEmptyDynamicObject("tsrbd_label");
        long labelId = ORM.create().genLongId("tsrbd_individuallabel");
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        labelObj.set("id", (Object)labelId);
        labelObj.set("name", (Object)labelName);
        labelObj.set("status", (Object)"C");
        labelObj.set("creator", (Object)TSCRequestContext.getUserId());
        labelObj.set("createtime", (Object)now);
        labelObj.set("modifier", (Object)TSCRequestContext.getUserId());
        labelObj.set("modifytime", (Object)now);
        labelObj.set("enable", (Object)"1");
        labelObj.set("masterid", (Object)labelId);
        labelObj.set("createorg", (Object)RequestContext.get().getOrgId());
        labelObj.set("org", (Object)RequestContext.get().getOrgId());
        labelObj.set("useorg", (Object)RequestContext.get().getOrgId());
        labelObj.set("ctrlstrategy", (Object)5);
        labelObj.set("issyspreset", (Object)Character.valueOf('0'));
        labelObj.set("labelcategory", (Object)"C");
        labelObj.set("display", (Object)display);
        labelObj.set("labeltype", (Object)labelTypeId);
        DynamicObjectCollection objTypeCollection = labelObj.getDynamicObjectCollection("tagobjtype");
        DynamicObjectType dynamicObjectType = objTypeCollection.getDynamicObjectType();
        DynamicObject stdrsm = new DynamicObject(dynamicObjectType);
        stdrsm.set("fbasedataid", (Object)LabelTagObjTypeEnum.OUT_STDRSM.getId());
        objTypeCollection.add((Object)stdrsm);
        DynamicObject resume = new DynamicObject(dynamicObjectType);
        resume.set("fbasedataid", (Object)LabelTagObjTypeEnum.OUT_RESUME.getId());
        objTypeCollection.add((Object)resume);
        labelObj.set("tagobjtype", (Object)objTypeCollection);
        return labelObj;
    }

    public void savePortrait(JSONObject resultJson, Long tagObjId, Long tagObjTypeId) {
        String portraitJson = this.formatPortraitJson(resultJson);
        PortraitServiceHelper.createPortrait(tagObjId, tagObjTypeId, portraitJson);
    }

    private String formatPortraitJson(JSONObject resultJson) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(10);
        JSONArray all_tag_report = resultJson.getJSONObject("result").getJSONArray("all_tag_report");
        if (null == all_tag_report) {
            logger.error("AILabelAPI getCVTag result all_tag_report is empty");
        } else {
            ArrayList prominentList = new ArrayList(16);
            ArrayList focusList = new ArrayList(16);
            all_tag_report.stream().forEach(reportObj -> this.setReport(prominentList, focusList, (JSONObject)reportObj));
            dataMap.put("prominent", prominentList);
            dataMap.put("focus", focusList);
        }
        JSONObject complete_tag = resultJson.getJSONObject("result").getJSONObject("complete_tag");
        if (null == complete_tag) {
            logger.error("AILabelAPI getCVTag result complete_tag is empty");
        } else {
            this.buildInfoData(dataMap, complete_tag);
            this.buildEduData(dataMap, complete_tag);
            this.buildWorkData(dataMap, complete_tag);
            this.buildPrjData(dataMap, complete_tag);
            this.buildSkillData(dataMap, complete_tag);
        }
        return JSONObject.toJSONString(dataMap);
    }

    private void setReport(List<Map<String, String>> prominentList, List<Map<String, String>> focusList, JSONObject reportObj) {
        try {
            HashMap<String, String> prominentMap = new HashMap<String, String>(4);
            prominentMap.put("prominentName", reportObj.getString("tag_description"));
            prominentMap.put("prominentDesc", reportObj.getString("tag_report"));
            if ("highlight".equals(reportObj.get((Object)"tag_type"))) {
                prominentList.add(prominentMap);
            }
            if ("abnormal".equals(reportObj.get((Object)"tag_type"))) {
                focusList.add(prominentMap);
            }
        }
        catch (Exception e) {
            logger.info("AILabelAPI setReport is fail :", (Object)e);
        }
    }

    private void buildInfoData(Map<String, Object> dataMap, JSONObject complete_tag) {
        try {
            HashMap informationMap = new HashMap(4);
            JSONObject basics = complete_tag.getJSONObject("basics");
            ArrayList<String> personInfoList = new ArrayList<String>(10);
            for (Map.Entry entry : basics.entrySet()) {
                if (null == entry.getValue() || ((String)entry.getKey()).equals("specialty") || ((String)entry.getKey()).equals("hobby")) continue;
                personInfoList.add(entry.getValue().toString());
            }
            informationMap.put("personinfo", personInfoList);
            informationMap.put("marital", null);
            dataMap.put("information", informationMap);
        }
        catch (Exception e) {
            logger.info("AILabelAPI buildInfoData is fail :", (Object)e);
        }
    }

    private void buildEduData(Map<String, Object> dataMap, JSONObject complete_tag) {
        try {
            HashMap eduInfoMap = new HashMap(4);
            ArrayList<String> eduOverviewList = new ArrayList<String>(16);
            JSONObject educations = complete_tag.getJSONObject("educations");
            JSONObject overall = educations.getJSONObject("overall");
            JSONObject school_tag = overall.getJSONObject("school_tag");
            JSONObject other_tag = overall.getJSONObject("other_tag");
            String top_education = other_tag.getString("top_education");
            if (StringUtils.isNotEmpty((String)top_education)) {
                eduOverviewList.add("\u6700\u9ad8\u5b66\u5386:" + top_education);
            }
            List<String> school_title = this.toListString(school_tag.getJSONArray("school_title"));
            eduOverviewList.addAll(school_title);
            String is_oversea_education = school_tag.getString("is_oversea_education");
            if ("Y".equals(is_oversea_education)) {
                eduOverviewList.add("\u6d77\u5916\u7559\u5b66\u7ecf\u5386");
            }
            List<String> education_form_list = this.toListString(other_tag.getJSONArray("education_form_list"));
            eduOverviewList.addAll(education_form_list);
            String top_degree = other_tag.getString("top_degree");
            if (StringUtils.isNotEmpty((String)top_degree)) {
                eduOverviewList.add("\u6700\u9ad8\u5b66\u4f4d:" + top_degree);
            }
            List<String> school_position_list = this.toListString(other_tag.getJSONArray("school_position_list"));
            eduOverviewList.addAll(school_position_list);
            Integer competition_count = other_tag.getInteger("competition_count");
            if (null != competition_count && competition_count > 0) {
                eduOverviewList.add("\u53c2\u52a0\u7ade\u8d5b\u6b21\u6570:" + competition_count);
            }
            List<String> competition_list = this.toListString(other_tag.getJSONArray("competition_list"));
            eduOverviewList.addAll(competition_list);
            eduInfoMap.put("eduOverview", eduOverviewList);
            ArrayList eduExperienceList = new ArrayList(16);
            List partition = educations.getJSONArray("partition").toJavaList(JSONObject.class);
            for (JSONObject obj : partition) {
                ArrayList<String> slotInfoList = new ArrayList<String>(16);
                ArrayList<String> slotLabelList = new ArrayList<String>(16);
                HashMap<String, Object> slotExperienceMap = new HashMap<String, Object>(4);
                if (StringUtils.isEmpty((String)obj.getString("start_date")) || StringUtils.isEmpty((String)obj.getString("end_date"))) continue;
                slotExperienceMap.put("timeAxis", obj.getString("start_date") + "\uff5e" + obj.getString("end_date"));
                slotLabelList.add(obj.getString("std_education"));
                slotInfoList.add(obj.getString("std_school_name"));
                slotInfoList.add(String.join((CharSequence)",", obj.getJSONArray("major_name").toJavaList(String.class)));
                JSONObject part_school_tag = obj.getJSONObject("school_tag");
                if (null != part_school_tag && !part_school_tag.isEmpty()) {
                    List<String> part_school_title = this.toListString(part_school_tag.getJSONArray("school_title"));
                    slotLabelList.addAll(part_school_title);
                    List<String> part_school_type = this.toListString(part_school_tag.getJSONArray("school_type"));
                    slotLabelList.addAll(part_school_type);
                    String part_is_oversea_education = part_school_tag.getString("is_oversea_education");
                    if ("Y".equals(part_is_oversea_education)) {
                        slotLabelList.add("\u6d77\u5916\u7559\u5b66\u7ecf\u5386");
                    }
                }
                String education_form = obj.getString("education_form");
                slotLabelList.add(education_form);
                JSONArray major_name = obj.getJSONArray("major_name");
                List<String> major_name_list = this.toListString(major_name);
                slotLabelList.addAll(major_name_list);
                slotExperienceMap.put("slotInfo", slotInfoList);
                slotExperienceMap.put("slotLabel", slotLabelList);
                eduExperienceList.add(slotExperienceMap);
            }
            eduInfoMap.put("eduExperience", eduExperienceList);
            dataMap.put("eduInfo", eduInfoMap);
        }
        catch (Exception e) {
            logger.info("AILabelAPI buildEduData is fail :", (Object)e);
        }
    }

    private void buildWorkData(Map<String, Object> dataMap, JSONObject complete_tag) {
        try {
            String is_founder;
            String work_hopping_label;
            Integer duration_for_longest_gap_period;
            List<String> gap_period_list;
            String start_work_date;
            JSONObject employments = complete_tag.getJSONObject("employments");
            JSONObject work_overall = employments.getJSONObject("overall");
            JSONObject work_other_tag = work_overall.getJSONObject("other_tag");
            ArrayList<String> workOverviewList = new ArrayList<String>(16);
            String total_work_duration = work_other_tag.getString("total_work_duration");
            if (StringUtils.isNotEmpty((String)total_work_duration)) {
                workOverviewList.add("\u5de5\u4f5c" + total_work_duration + "\u5e74");
            }
            if (StringUtils.isNotEmpty((String)(start_work_date = work_other_tag.getString("start_work_date")))) {
                workOverviewList.add(start_work_date + "\u53c2\u52a0\u5de5\u4f5c");
            }
            if (null != (gap_period_list = this.toListString(work_other_tag.getJSONArray("gap_period_list"))) && !gap_period_list.isEmpty()) {
                workOverviewList.add(gap_period_list.size() + "\u6bb5\u7a7a\u6863\u671f");
            }
            if (null != (duration_for_longest_gap_period = work_other_tag.getInteger("duration_for_longest_gap_period"))) {
                workOverviewList.add("\u6700\u957f\u7a7a\u6863\u671f" + duration_for_longest_gap_period + "\u5e74");
            }
            if (StringUtils.isNotEmpty((String)(work_hopping_label = work_other_tag.getString("work_hopping_label")))) {
                workOverviewList.add("\u8df3\u69fd\u9891\u5ea6" + work_hopping_label);
            }
            if ("Y".equals(is_founder = work_other_tag.getString("is_founder"))) {
                workOverviewList.add("\u521b\u4e1a\u7ecf\u5386");
            }
            HashMap workInfoMap = new HashMap(5);
            workInfoMap.put("workOverview", workOverviewList);
            workInfoMap.put("workStatistics", null);
            ArrayList workExperienceList = new ArrayList(16);
            List work_partition = employments.getJSONArray("partition").toJavaList(JSONObject.class);
            for (JSONObject obj : work_partition) {
                ArrayList<String> slotInfoList = new ArrayList<String>(16);
                HashMap<String, Object> slotExperienceMap = new HashMap<String, Object>(5);
                if (StringUtils.isEmpty((String)obj.getString("start_date")) || StringUtils.isEmpty((String)obj.getString("end_date"))) continue;
                slotExperienceMap.put("timeAxis", obj.getString("start_date") + "\uff5e" + obj.getString("end_date"));
                slotInfoList.add(obj.getString("std_company_name"));
                slotInfoList.add(obj.getString("std_job_category"));
                String duration = obj.getString("duration");
                if (StringUtils.isNotEmpty((String)duration)) {
                    slotInfoList.add(duration + "\u5e74");
                }
                ArrayList<String> slotLabelList = new ArrayList<String>(16);
                JSONArray company_title = obj.getJSONObject("company_tag").getJSONArray("company_title");
                slotLabelList.addAll(this.toListString(company_title));
                JSONArray company_type = obj.getJSONObject("company_tag").getJSONArray("company_type");
                slotLabelList.addAll(this.toListString(company_type));
                slotExperienceMap.put("slotInfo", slotInfoList);
                slotExperienceMap.put("slotLabel", slotLabelList);
                workExperienceList.add(slotExperienceMap);
            }
            workInfoMap.put("workExperience", workExperienceList);
            dataMap.put("workInfo", workInfoMap);
        }
        catch (Exception e) {
            logger.info("AILabelAPI buildWorkData is fail :", (Object)e);
        }
    }

    private void buildPrjData(Map<String, Object> dataMap, JSONObject complete_tag) {
        try {
            HashMap prjInfoMap = new HashMap(4);
            ArrayList<String> prjOverviewList = new ArrayList<String>(16);
            JSONObject projects = complete_tag.getJSONObject("projects");
            JSONObject prj_overall = projects.getJSONObject("overall");
            Integer project_count = prj_overall.getInteger("project_count");
            if (null != project_count && project_count > 0) {
                prjOverviewList.add("\u9879\u76ee*" + project_count);
            }
            prjInfoMap.put("prjOverview", prjOverviewList);
            prjInfoMap.put("prjStatistics", null);
            List prj_partition = projects.getJSONArray("partition").toJavaList(JSONObject.class);
            ArrayList prjExperienceList = new ArrayList(16);
            for (JSONObject obj : prj_partition) {
                HashMap<String, Object> slotExperienceMap = new HashMap<String, Object>(4);
                slotExperienceMap.put("timeAxis", obj.getString("start_date") + "\uff5e" + obj.getString("end_date"));
                ArrayList<String> slotInfoList = new ArrayList<String>(16);
                String project_name = obj.getString("project_name");
                slotInfoList.add(project_name);
                String std_project_company_name = obj.getString("std_project_company_name");
                slotInfoList.add(std_project_company_name);
                String project_role = obj.getString("project_role");
                slotInfoList.add(project_role);
                Integer project_duration_months = obj.getInteger("project_duration_months");
                if (null != project_duration_months) {
                    slotInfoList.add(project_duration_months + "\u4e2a\u6708");
                }
                ArrayList slotLabelList = new ArrayList(10);
                slotExperienceMap.put("slotInfo", slotInfoList);
                slotExperienceMap.put("slotLabel", slotLabelList);
                ArrayList slotDetailList = new ArrayList(10);
                HashMap<String, String> slotDetailMap = new HashMap<String, String>(4);
                slotDetailMap.put("slotDetailName", "\u9879\u76ee\u63cf\u8ff0");
                slotDetailMap.put("slotDetailDesc", obj.getString("project_description"));
                slotDetailList.add(slotDetailMap);
                HashMap<String, String> slotDetailMap1 = new HashMap<String, String>(4);
                slotDetailMap1.put("slotDetailName", "\u9879\u76ee\u804c\u8d23");
                slotDetailMap1.put("slotDetailDesc", obj.getString("project_work"));
                slotDetailList.add(slotDetailMap1);
                slotExperienceMap.put("slotDetail", slotDetailList);
                prjExperienceList.add(slotExperienceMap);
            }
            prjInfoMap.put("prjExperience", prjExperienceList);
            dataMap.put("prjInfo", prjInfoMap);
        }
        catch (Exception e) {
            logger.info("AILabelAPI buildPrjData is fail :", (Object)e);
        }
    }

    private void buildSkillData(Map<String, Object> dataMap, JSONObject complete_tag) {
        try {
            JSONObject skills = complete_tag.getJSONObject("skills");
            List language_list = skills.getJSONArray("language_list").toJavaList(JSONObject.class);
            List<String> certificate_list = this.toListString(skills.getJSONArray("certificate_list"));
            List job_skill_list = skills.getJSONArray("job_skill_list").toJavaList(JSONObject.class);
            HashMap skillInfoMap = new HashMap(4);
            ArrayList<String> skillOverviewList = new ArrayList<String>(10);
            if (job_skill_list.size() > 0) {
                skillOverviewList.add("\u5c97\u4f4d\u6280\u80fd*" + job_skill_list.size());
            }
            if (language_list.size() > 0) {
                skillOverviewList.add("\u8bed\u8a00\u6280\u80fd*" + language_list.size());
            }
            if (certificate_list.size() > 0) {
                skillOverviewList.add("\u8bc1\u4e66*" + certificate_list.size());
            }
            skillInfoMap.put("skillOverview", skillOverviewList);
            ArrayList majorSkillList = new ArrayList(10);
            for (JSONObject obj : job_skill_list) {
                HashMap<String, String> majorSkillMap = new HashMap<String, String>(3);
                majorSkillMap.put("skillName", obj.getString("skill_name"));
                majorSkillMap.put("skillLevel", obj.getString("skill_level"));
                majorSkillMap.put("skillPrj", (String)obj.getJSONArray("project_name"));
                majorSkillList.add(majorSkillMap);
            }
            skillInfoMap.put("majorSkill", majorSkillList);
            ArrayList languageSkillList = new ArrayList(10);
            language_list.stream().filter(this.filterCondition()).forEach(jsonObject -> this.splicingStr(languageSkillList, (JSONObject)jsonObject));
            skillInfoMap.put("languageSkill", languageSkillList);
            ArrayList<String> certificateList = new ArrayList<String>(10);
            certificateList.addAll(certificate_list);
            skillInfoMap.put("certificate", certificateList);
            dataMap.put("skillInfo", skillInfoMap);
        }
        catch (Exception e) {
            logger.info("AILabelAPI buildSkillData is fail :", (Object)e);
        }
    }

    private void splicingStr(List<String> languageSkillList, JSONObject jsonObject) {
        String languageStr = String.join((CharSequence)"|", jsonObject.getString("name"), jsonObject.getString("prop"), jsonObject.getString("level"));
        languageSkillList.add(languageStr);
    }

    private Predicate<JSONObject> filterCondition() {
        return jsonObject -> jsonObject.getString("name") != null && jsonObject.getString("prop") != null && jsonObject.getString("level") != null;
    }

    private List<String> toListString(JSONArray jsonArray) {
        if (null == jsonArray || jsonArray.isEmpty()) {
            return new ArrayList<String>(1);
        }
        return jsonArray.toJavaList(String.class);
    }

    static {
        aILabelApiServiceHelper = new AILabelApiServiceHelper();
        logger = LogFactory.getLog(AILabelApiServiceHelper.class);
    }
}

