/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.label.service;

import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;

public class DrawLabelUnits {
    public static FlexPanelAp createLabelShowPanel(List<LabelBO> labelBOList, String key, String prefixKeyPanel, String fontClass, String backColor, String prefixKeyVector, String prefixKeyLabel, String addKeyPrefix) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey(key);
        for (LabelBO labelBO : labelBOList) {
            FlexPanelAp completeLabelPanel = DrawLabelUnits.createCompleteLabelPanel(labelBO, prefixKeyPanel, fontClass, backColor, prefixKeyVector, prefixKeyLabel);
            labelShowPanelAp.getItems().add(completeLabelPanel);
        }
        LabelBO labelBO = new LabelBO();
        labelBO.setName("+");
        labelBO.setLabelCategory(addKeyPrefix + "-+");
        FlexPanelAp completeLabelPanel = DrawLabelUnits.createCompleteLabelPanel(labelBO, prefixKeyPanel, fontClass, backColor, prefixKeyVector, prefixKeyLabel);
        labelShowPanelAp.getItems().add(completeLabelPanel);
        return labelShowPanelAp;
    }

    private static FlexPanelAp createCompleteLabelPanel(LabelBO labelBO, String prefixKeyPanel, String fontClass, String backColor, String prefixKeyVector, String prefixKeyLabel) {
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setClickable(true);
        completeLabelPanelAp.setKey(labelBO.getLabelCategory());
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjRDlEOUQ5O1xuICAgIHBhZGRpbmc6IDAgOHB4O1xuICAgIG1hcmdpbjogMCA4cHggOHB4IDA7XG4gICAgYm9yZGVyLXJhZGl1czogMTBweDtcbiAgICBjb2xvcjogIzY2NjY2NjtcbiAgICBoZWlnaHQ6IDIwcHg7XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICBmbGV4LXdyYXA6IG5vd3JhcDtcbn0ifQ==");
        String labelCategory = labelBO.getLabelCategory();
        LabelAp label = DrawLabelUnits.createLabel(labelBO.getName(), labelCategory, prefixKeyLabel);
        label.setGrow(1);
        label.setShrink(1);
        completeLabelPanelAp.getItems().add(label);
        if (!labelBO.getLabelCategory().contains("+")) {
            VectorAp vector = DrawLabelUnits.createVectorByType(fontClass, labelCategory, prefixKeyVector);
            vector.setGrow(0);
            vector.setShrink(0);
            completeLabelPanelAp.getItems().add(vector);
        }
        return completeLabelPanelAp;
    }

    private static LabelAp createLabel(String labelName, String labelCategory, String prefixKeyLabel) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(prefixKeyLabel + labelCategory);
        labelAp.setId(labelCategory);
        labelAp.setOperationKey(labelCategory);
        labelAp.setName(new LocaleString(labelName));
        return labelAp;
    }

    public static VectorAp createVectorByType(String fontclass, String labelTagObjId, String prefixKey) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(prefixKey + labelTagObjId);
        vectorAp.setId(labelTagObjId);
        vectorAp.setfontClass(fontclass);
        vectorAp.setForeColor("#CCCCCC");
        vectorAp.setFontSize(8);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("6px");
        style.setMargin(margin);
        vectorAp.setStyle(style);
        if ("".equals(labelTagObjId)) {
            vectorAp.setClickable(false);
            vectorAp.setNeedHoverClass(false);
        }
        return vectorAp;
    }
}

