/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.label.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.common.entity.label.AiInsightParamEntity;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.utils.FormShowUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.StringUtils;

public class LabelDataHelper {
    private static final Log logger = LogFactory.getLog(LabelDataHelper.class);
    private static final String TSC_TSRBS_BUSSINESS = "tsc-tsrbs-business";
    private static HRBaseServiceHelper labelServiceHelper = new HRBaseServiceHelper("tsrbd_label");
    public static final String BOS_LIST = "bos_list";
    public static final String TALENTTEMTREELIST = "tstpm_talenttemtreelist";
    public static final String KEY_LABELSHOWFLEX = "labelshowflex";

    public static QFilter getAiLabelQfilter() {
        QFilter labelCategory = new QFilter("labelcategory", "=", (Object)"C");
        QFilter display = new QFilter("display", "=", (Object)"T");
        return labelCategory.and(display);
    }

    public static QFilter getPLLabelQfilter() {
        QFilter labelCategory = new QFilter("labelcategory", "=", (Object)"B");
        QFilter org = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_publiclabel", (Long)RequestContext.get().getOrgId());
        return labelCategory.and(org);
    }

    public static QFilter getILLabelQfilter() {
        QFilter labelCategory = new QFilter("labelcategory", "=", (Object)"A");
        QFilter user = new QFilter("creator", "=", (Object)TSCRequestContext.getUserId());
        return labelCategory.and(user);
    }

    public static QFilter getLabelQfilter() {
        QFilter aiQFilter = LabelDataHelper.getAiLabelQfilter();
        QFilter plQFilter = LabelDataHelper.getPLLabelQfilter();
        QFilter ilQFilter = LabelDataHelper.getILLabelQfilter();
        QFilter qFilter = aiQFilter.or(plQFilter).or(ilQFilter);
        return qFilter;
    }

    public static QFilter getLabelQfilter(List<Long> tagObjTypeIds) {
        QFilter qFilter = LabelDataHelper.getLabelQfilter();
        if (tagObjTypeIds != null && !tagObjTypeIds.isEmpty()) {
            qFilter.and(new QFilter("tagobjtype.fbasedataid", "in", tagObjTypeIds));
        }
        return qFilter;
    }

    public static Map<String, Object> createILLabel(String name, Long objTypeId) {
        DynamicObject iLLabel = LabelDataHelper.getILLabelByName(name);
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        if (iLLabel != null) {
            result.put("state", "F");
            return result;
        }
        DynamicObject labelObj = labelServiceHelper.generateEmptyDynamicObject("tsrbd_label");
        long labelId = ORM.create().genLongId("tsrbd_individuallabel");
        String number = CodeRuleServiceHelper.getNumber((String)"tsrbd_individuallabel", (DynamicObject)labelObj, null);
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        labelObj.set("id", (Object)labelId);
        labelObj.set("name", (Object)name);
        labelObj.set("number", (Object)number);
        labelObj.set("status", (Object)"C");
        labelObj.set("creator", (Object)TSCRequestContext.getUserId());
        labelObj.set("createtime", (Object)now);
        labelObj.set("modifier", (Object)TSCRequestContext.getUserId());
        labelObj.set("modifytime", (Object)now);
        labelObj.set("enable", (Object)"1");
        labelObj.set("masterid", (Object)labelId);
        labelObj.set("createorg", (Object)RequestContext.get().getOrgId());
        labelObj.set("org", (Object)RequestContext.get().getOrgId());
        labelObj.set("useorg", (Object)RequestContext.get().getOrgId());
        labelObj.set("ctrlstrategy", (Object)5);
        labelObj.set("issyspreset", (Object)Character.valueOf('0'));
        labelObj.set("labelcategory", (Object)"A");
        labelObj.set("display", (Object)"T");
        labelObj.set("labeltype", (Object)0L);
        DynamicObjectCollection objTypeCollection = labelObj.getDynamicObjectCollection("tagobjtype");
        DynamicObjectType dynamicObjectType = objTypeCollection.getDynamicObjectType();
        DynamicObject objType = new DynamicObject(dynamicObjectType);
        objType.set("fbasedataid", (Object)objTypeId);
        objTypeCollection.add((Object)objType);
        labelObj.set("tagobjtype", (Object)objTypeCollection);
        labelServiceHelper.saveOne(labelObj);
        result.put("state", "T");
        result.put("label", labelObj);
        return result;
    }

    public static Map<String, Object> updateILLabel(String name, String enable, Long objTypeId) {
        DynamicObject labelObj = LabelDataHelper.getILLabelByName(name);
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        if (StringUtils.isNotEmpty((CharSequence)enable)) {
            labelObj.set("enable", (Object)enable);
        }
        if (objTypeId != null) {
            DynamicObjectCollection objTypeCollection = labelObj.getDynamicObjectCollection("tagobjtype");
            DynamicObjectType dynamicObjectType = objTypeCollection.getDynamicObjectType();
            DynamicObject objType = new DynamicObject(dynamicObjectType);
            objType.set("fbasedataid", (Object)objTypeId);
            objTypeCollection.add((Object)objType);
            labelObj.set("tagobjtype", (Object)objTypeCollection);
        }
        labelServiceHelper.updateOne(labelObj);
        result.put("state", "T");
        result.put("label", labelObj);
        return result;
    }

    public static DynamicObject[] getILPLLabelByName(String labelName, Long objTypeId) {
        QFilter name = new QFilter("name", "like", (Object)labelName);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter objType = new QFilter("tagobjtype.fbasedataid", "=", (Object)objTypeId);
        QFilter pLLabelQFilter = LabelDataHelper.getPLLabelQfilter();
        QFilter iLLabelQFilter = LabelDataHelper.getILLabelQfilter();
        QFilter[] filters = new QFilter[]{name, enable, objType, pLLabelQFilter.or(iLLabelQFilter)};
        DynamicObject[] detailObjs = labelServiceHelper.loadDynamicObjectArray(filters);
        return detailObjs;
    }

    public static DynamicObject getILLabelByName(String labelName) {
        QFilter name = new QFilter("name", "=", (Object)labelName);
        QFilter iLLabelQFilter = LabelDataHelper.getILLabelQfilter();
        QFilter[] filters = new QFilter[]{name, iLLabelQFilter};
        DynamicObject detailObj = labelServiceHelper.loadDynamicObject(filters);
        return detailObj;
    }

    public static Map<String, Object> searchILPLLabelByName(String labelName, Long objTypeId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        Integer code = LabelDataHelper.createILLabelValidator(labelName, objTypeId);
        DynamicObject[] iLPLLabels = LabelDataHelper.getILPLLabelByName("%" + labelName + "%", objTypeId);
        result.put("code", code);
        result.put("data", iLPLLabels);
        return result;
    }

    public static Integer createILLabelValidator(String labelName, Long objTypeId) {
        Integer code;
        DynamicObject iLLabel = LabelDataHelper.getILLabelByName(labelName);
        if (iLLabel == null) {
            code = 200;
        } else {
            Boolean isObjType = Boolean.FALSE;
            DynamicObjectCollection objTypes = iLLabel.getDynamicObjectCollection("tagobjtype");
            for (DynamicObject obj : objTypes) {
                if (!objTypeId.equals(obj.getDynamicObject("fbasedataid").get("id"))) continue;
                isObjType = Boolean.TRUE;
                break;
            }
            String enable = iLLabel.get("enable").toString();
            code = isObjType.booleanValue() ? ("0".equals(enable) ? Integer.valueOf(201) : Integer.valueOf(199)) : ("1".equals(enable) ? Integer.valueOf(202) : Integer.valueOf(203));
        }
        return code;
    }

    public static void showAddLabelPage(IFormPlugin iFormPlugin, IFormView view, List<Long> tagObjList, Long tagObjTypeId, String pageType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_addtag");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("tagObjList", tagObjList);
        showParameter.setCustomParam("tagObjTypeId", (Object)String.valueOf(tagObjTypeId));
        showParameter.setCustomParam("pagetype", (Object)pageType);
        String formId = view.getFormShowParameter().getFormId();
        String actionId = "";
        actionId = BOS_LIST.equals(formId) || TALENTTEMTREELIST.equals(formId) || view instanceof ListView ? "tsrbd_addtag" : "tsrbd_edittag";
        showParameter.setCloseCallBack(new CloseCallBack(iFormPlugin, actionId));
        view.showForm(showParameter);
    }

    public static void showRemoveLabelPage(IFormPlugin iFormPlugin, IFormView view, List<Long> tagObjList, Long tagObjTypeId, String pageType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_removetag");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("tagObjList", tagObjList);
        showParameter.setCustomParam("tagObjTypeId", (Object)String.valueOf(tagObjTypeId));
        showParameter.setCustomParam("pagetype", (Object)pageType);
        showParameter.setCloseCallBack(new CloseCallBack(iFormPlugin, "tsrbd_removetag"));
        view.showForm(showParameter);
    }

    public static void showAppRsmListLabelPage(IFormView view, Long appRsmId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_LABELSHOWFLEX);
        showParameter.setCustomParam("id", (Object)appRsmId);
        showParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.OUT_RESUME.getId()));
        showParameter.setCustomParam("isshowbutton", (Object)Boolean.FALSE);
        showParameter.setCustomParam("ishidemorebtn", (Object)Boolean.FALSE);
        showParameter.setCustomParam("pagetype", (Object)"detail");
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("excludeCategorys", null);
        view.showForm(showParameter);
    }

    public static void showAppRsmDefaultLabelPage(IFormView view, AiInsightParamEntity aiInsightParamEntity) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show_default");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(aiInsightParamEntity.getTargetKey());
        showParameter.setCustomParam("id", (Object)aiInsightParamEntity.getAppRsmId());
        showParameter.setCustomParam("type", (Object)String.valueOf(aiInsightParamEntity.getTypeId()));
        showParameter.setCustomParam("aiId", (Object)aiInsightParamEntity.getAppRsmId());
        showParameter.setCustomParam("aiTypeId", (Object)String.valueOf(aiInsightParamEntity.getTypeId()));
        showParameter.setCustomParam("isCanEditLabel", (Object)aiInsightParamEntity.getCanEditLabel());
        showParameter.setCustomParam("isShowMyLabel", (Object)aiInsightParamEntity.getShowMyLabel());
        showParameter.setCustomParam("isFold", (Object)aiInsightParamEntity.getFold());
        showParameter.setSendToClient(true);
        List excludeCategorys = aiInsightParamEntity.getExcludeCategorys();
        if (excludeCategorys == null) {
            excludeCategorys = Lists.newArrayList((Object[])new String[]{"C"});
        } else {
            excludeCategorys.add("C");
        }
        showParameter.setCustomParam("excludeCategorys", (Object)excludeCategorys);
        view.getPageCache().put("tsrbd_label_show_defaultpageid", showParameter.getPageId());
        view.showForm(showParameter);
    }

    public static void showAppRsmPortraitPage(IFormView view, Long id, Long typeId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("id", id.toString());
        params.put("type", typeId.toString());
        FormShowUtils.showSlideBill((IFormView)view, (String)"tsrbd_portrait_main", params);
    }

    public static void handleCloseCallBack(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        switch (closedCallBackEvent.getActionId()) {
            case "tsrbd_addtag": {
                if (!"success".equals(closedCallBackEvent.getReturnData())) break;
                view.showSuccessNotification(ResManager.loadKDString((String)"\u6253\u6807\u7b7e\u6210\u529f", (String)"LabelDataHelper_0", (String)TSC_TSRBS_BUSSINESS, (Object[])new Object[0]));
                break;
            }
            case "tsrbd_removetag": {
                if (!"success".equals(closedCallBackEvent.getReturnData())) break;
                view.showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u6807\u7b7e\u6210\u529f\u3002", (String)"LabelDataHelper_1", (String)TSC_TSRBS_BUSSINESS, (Object[])new Object[0]));
                break;
            }
            case "tsrbd_edittag": {
                if (!"success".equals(closedCallBackEvent.getReturnData())) break;
                view.showSuccessNotification(ResManager.loadKDString((String)"\u7f16\u8f91\u6807\u7b7e\u6210\u529f", (String)"LabelDataHelper_2", (String)TSC_TSRBS_BUSSINESS, (Object[])new Object[0]));
                break;
            }
        }
    }

    public static DynamicObject[] getLabelsByObjType(List<Long> tagObjTypeIds) {
        QFilter labelFilter = LabelDataHelper.getLabelQfilter(tagObjTypeIds);
        DynamicObject[] labels = labelServiceHelper.query("id,labelcategory,name", labelFilter.toArray(), "labelcategory,createtime desc");
        return labels;
    }

    public static DynamicObject[] getLabelsByObjType(List<Long> tagObjTypeIds, QFilter qFilter) {
        QFilter labelFilter = LabelDataHelper.getLabelQfilter(tagObjTypeIds);
        DynamicObject[] labels = labelServiceHelper.query("id,labelcategory,name", new QFilter[]{labelFilter, qFilter}, "labelcategory,createtime desc");
        return labels;
    }

    public static String getTagObjName(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_tagobjtype");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject tagObj = serviceHelper.loadDynamicObject(qFilter);
        if (tagObj != null) {
            return tagObj.getString("name");
        }
        return "";
    }
}

