/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.label.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FieldTip;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class LabelServiceHelper {
    private static LabelServiceHelper labelServiceHelper = null;
    private HRBaseServiceHelper individualLabelService = new HRBaseServiceHelper("tsrbd_individuallabel");
    private HRBaseServiceHelper publicLabelService = new HRBaseServiceHelper("tsrbd_publiclabel");

    private LabelServiceHelper() {
    }

    public static LabelServiceHelper getInstance() {
        if (HRObjectUtils.isEmpty((Object)labelServiceHelper)) {
            return new LabelServiceHelper();
        }
        return labelServiceHelper;
    }

    public DynamicObject[] getIndividualLabels(String name) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("labelcategory", "=", (Object)"A"));
        qFilters.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
        qFilters.add(new QFilter("name", "=", (Object)name));
        String selectProperties = "id";
        return this.individualLabelService.query(selectProperties, qFilters.toArray(new QFilter[0]), "", 1);
    }

    public DynamicObject[] getIndividualLabels(List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", ids));
        String selectProperties = "id,number,enable,tagobjtype";
        return this.individualLabelService.query(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public void delete(String entityName, List<Long> ids) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("id", "in", ids));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    public void deleteTagByLabels(String entityName, List<Long> labels) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("labelid", "in", labels));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    public DynamicObject[] getPublicLabels(String name) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("labelcategory", "=", (Object)"B"));
        qFilters.add(new QFilter("name", "=", (Object)name));
        String selectProperties = "number,createorg";
        return this.publicLabelService.query(selectProperties, qFilters.toArray(new QFilter[0]), "", 1);
    }

    public DynamicObject queryOriginalOne(String selectProperties, Long id) {
        return this.publicLabelService.queryOriginalOne(selectProperties, (Object)id);
    }

    public DynamicObject[] getPublicLabels(List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", ids));
        String selectProperties = "id,number,enable,tagobjtype";
        return this.publicLabelService.query(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    public FieldTip getFieldTip() {
        String confirmTip = String.format(ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IndividualLabelEdit_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), new Object[0]);
        FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, "name", confirmTip);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList("name"));
        tip.setSuccess(false);
        tip.setDeleteRule(deleteRule);
        return tip;
    }
}

