/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.label.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsrbd.business.domain.common.entity.BizResults;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.constants.DateFormatConstants;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.enums.LabelCategoryEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LabelTagObjServiceHelper {
    private HRBaseServiceHelper tagHrBaseService;
    private HRBaseServiceHelper ilHrBaseService = new HRBaseServiceHelper("tsrbd_individuallabel");
    private HRBaseServiceHelper plHrBaseService = new HRBaseServiceHelper("tsrbd_publiclabel");
    private HRBaseServiceHelper labelHrBaseService = new HRBaseServiceHelper("tsrbd_label");
    private long currentUserId = TSCRequestContext.getUserId();
    private String selectLabelProperties = "id,name,createtime";
    private static final String ALGO_KEY_PREFIX = "LabelTagObjServiceHelper#";
    private static final Log logger = LogFactory.getLog(LabelTagObjServiceHelper.class);
    private String entityName;

    public LabelTagObjServiceHelper(String entityName) {
        this.entityName = StringUtils.isEmpty((CharSequence)entityName) ? "tspr_labeltagobj" : entityName;
        this.tagHrBaseService = new HRBaseServiceHelper(this.entityName);
    }

    public boolean add(Long tagObjTypeId, Long tagObjId, String labelCategory, Long labelId) {
        if (tagObjTypeId == null) {
            logger.error("tagObjTypeId is null");
            return false;
        }
        if (tagObjId == null) {
            logger.error("tagObjId is null");
            return false;
        }
        if (HRStringUtils.isEmpty((String)labelCategory)) {
            logger.error("labelCategory is empty");
            return false;
        }
        if (labelId == null) {
            logger.error("labelId is null");
            return false;
        }
        this.deleteOld(tagObjTypeId, tagObjId, labelCategory, labelId);
        DynamicObject labelTagObj = BusinessDataServiceHelper.newDynamicObject((String)((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId)));
        labelTagObj.set("tagobjtypeid", (Object)tagObjTypeId);
        labelTagObj.set("tagobjid", (Object)tagObjId);
        labelTagObj.set("labelcategory", (Object)labelCategory);
        labelTagObj.set("labelid", (Object)labelId);
        labelTagObj.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        labelTagObj.set("creator", (Object)this.currentUserId);
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{labelTagObj});
        return objects.length == 1;
    }

    public void deleteOld(Long tagObjTypeId, Long tagObjId, String labelCategory, Long labelId) {
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "=", (Object)tagObjId));
        tagQFilters.add(new QFilter("labelcategory", "=", (Object)labelCategory));
        if (null != labelId) {
            tagQFilters.add(new QFilter("labelid", "=", (Object)labelId));
        }
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query("id", tagQFilters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(tagDynamicObjects.length);
        for (DynamicObject tagDynamicObject : tagDynamicObjects) {
            ids.add(tagDynamicObject.getLong("id"));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            DeleteServiceHelper.delete((String)((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId)), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
    }

    public BizResult batchAdd(Long tagObjTypeId, List<Long> tagObjIds, List<LabelBO> labelBOs) {
        if (tagObjTypeId == null) {
            return BizResults.failed("tagObjTypeId is null");
        }
        if (CollectionUtils.isEmpty(tagObjIds)) {
            return BizResults.failed("tagObjIds is empty");
        }
        if (CollectionUtils.isEmpty(labelBOs)) {
            return BizResults.failed("labelBOs is empty");
        }
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "in", tagObjIds));
        List labelIds = labelBOs.stream().map(LabelBO::getId).collect(Collectors.toList());
        tagQFilters.add(new QFilter("labelid", "in", labelIds));
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query("id", tagQFilters.toArray(new QFilter[0]));
        ArrayList<Long> ids = new ArrayList<Long>(tagDynamicObjects.length);
        for (DynamicObject tagDynamicObject : tagDynamicObjects) {
            ids.add(tagDynamicObject.getLong("id"));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            DeleteServiceHelper.delete((String)((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId)), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
        ArrayList<DynamicObject> labelTagObjList = new ArrayList<DynamicObject>();
        for (LabelBO labelBO : labelBOs) {
            for (Long tagObjId : tagObjIds) {
                DynamicObject labelTagObj = this.getInitLabelTagObj(tagObjTypeId, tagObjId, labelBO.getLabelCategory(), labelBO.getId());
                labelTagObjList.add(labelTagObj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])labelTagObjList.toArray(new DynamicObject[0]));
        return BizResults.success();
    }

    public DynamicObject getInitLabelTagObj(Long tagObjTypeId, Long tagObjId, String labelCategory, Long labelId) {
        DynamicObject labelTagObj = BusinessDataServiceHelper.newDynamicObject((String)((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId)));
        labelTagObj.set("tagobjtypeid", (Object)tagObjTypeId);
        labelTagObj.set("tagobjid", (Object)tagObjId);
        labelTagObj.set("labelcategory", (Object)labelCategory);
        labelTagObj.set("labelid", (Object)labelId);
        labelTagObj.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        labelTagObj.set("creator", (Object)this.currentUserId);
        return labelTagObj;
    }

    public BizResult batchEdit(Long tagObjTypeId, Long tagObjId, List<LabelBO> newLabelBOs, Long currentOrgId) {
        List removeLabels;
        if (tagObjTypeId == null) {
            return BizResults.failed("tagObjTypeId is null");
        }
        if (tagObjId == null) {
            return BizResults.failed("tagObjId is null");
        }
        if (currentOrgId == null) {
            return BizResults.failed("currentOrgId is null");
        }
        if (null == newLabelBOs) {
            newLabelBOs = new ArrayList<LabelBO>();
        }
        ArrayList<Long> tagObjIds = new ArrayList<Long>();
        tagObjIds.add(tagObjId);
        List<LabelBO> oldLabelBOs = this.batchQueryIlPl(tagObjTypeId, tagObjIds, currentOrgId);
        List addLabels = (List)CollectionUtils.subtract(newLabelBOs, oldLabelBOs);
        if (CollectionUtils.isNotEmpty((Collection)addLabels)) {
            this.batchAdd(tagObjTypeId, tagObjIds, addLabels);
        }
        if (CollectionUtils.isNotEmpty((Collection)(removeLabels = (List)CollectionUtils.subtract(oldLabelBOs, newLabelBOs)))) {
            List<Long> labelIds = removeLabels.stream().map(LabelBO::getId).collect(Collectors.toList());
            this.batchRemove(tagObjTypeId, tagObjIds, labelIds);
        }
        return BizResults.success();
    }

    public List<LabelBO> query(Long tagObjTypeId, Long tagObjId, Long currentOrgId) {
        if (tagObjTypeId == null || tagObjId == null || currentOrgId == null) {
            return new ArrayList<LabelBO>();
        }
        ArrayList<LabelBO> labelBOs = new ArrayList<LabelBO>();
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "=", (Object)tagObjId));
        return this.getLabelBOs(currentOrgId, labelBOs, tagQFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LabelBO> batchQuery(List<Pair<Long, Long>> tagObjTypeTagObjList, Long currentOrgId, List<String> excludeCategorys) {
        logger.info("LabelTagObjServiceHelper.batchQuery.params{} {} {}", new Object[]{tagObjTypeTagObjList, currentOrgId, excludeCategorys});
        if (excludeCategorys == null) {
            excludeCategorys = Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(tagObjTypeTagObjList)) {
            logger.error("tagObjTypeTagObjList is empty");
            return new ArrayList<LabelBO>();
        }
        ArrayList<LabelBO> labelBOs = new ArrayList<LabelBO>();
        String selectFields = "id,labelid,labelcategory,createtime";
        HashMap<Long, Long> label2tagMap = new HashMap<Long, Long>(16);
        ArrayList<Long> ilLabelIds = new ArrayList<Long>();
        ArrayList<Long> plLabelIds = new ArrayList<Long>();
        ArrayList<Long> aiLabelIds = new ArrayList<Long>();
        HashMap labelCreateTimeMap = Maps.newHashMapWithExpectedSize((int)16);
        String tagOrderBy = "createtime DESC";
        for (int i = 0; i < tagObjTypeTagObjList.size(); ++i) {
            LabelCategoryEnum[] tagQFilters = new ArrayList(1);
            Pair<Long, Long> tag = tagObjTypeTagObjList.get(i);
            Long tagObjTypeId = (Long)tag.getLeft();
            Long tagObjId = (Long)tag.getRight();
            QFilter tagQFilter = new QFilter("tagobjid", "=", (Object)tagObjId);
            tagQFilters.add(tagQFilter);
            String entry = (String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId);
            HRBaseServiceHelper tagHrBaseService = new HRBaseServiceHelper(entry);
            try (DataSet tags = null;){
                logger.info("LabelTagObjServiceHelper.batchQuery.queryDataSet{} {} {}", new Object[]{entry, tagObjTypeId, tagObjId});
                tags = tagHrBaseService.queryDataSet(ALGO_KEY_PREFIX + entry, selectFields, tagQFilters.toArray(new QFilter[0]), tagOrderBy);
                logger.info("LabelTagObjServiceHelper.batchQuery.tags.{}", (Object)tags.isEmpty());
                for (Row row : tags) {
                    this.groupLabel(label2tagMap, ilLabelIds, plLabelIds, aiLabelIds, row, labelCreateTimeMap);
                }
                continue;
            }
        }
        ArrayList<String> categorys = new ArrayList<String>(10);
        for (LabelCategoryEnum categoryEnum : LabelCategoryEnum.values()) {
            categorys.add(categoryEnum.getCode());
        }
        List<String> categoryList = categorys;
        if (CollectionUtils.isNotEmpty((Collection)excludeCategorys)) {
            categoryList = (List)CollectionUtils.subtract(categorys, (Collection)excludeCategorys);
        }
        for (String category : categoryList) {
            if (HRStringUtils.equals((String)LabelCategoryEnum.IL.getCode(), (String)category)) {
                DynamicObject[] ilDynamicObjects = this.queryIlLabel(ilLabelIds);
                this.buildData2(labelBOs, ilLabelIds, ilDynamicObjects, "A", label2tagMap);
            }
            if (HRStringUtils.equals((String)LabelCategoryEnum.PL.getCode(), (String)category)) {
                DynamicObject[] plDynamicObjects = this.queryPlLabel(plLabelIds, currentOrgId);
                this.buildData2(labelBOs, plLabelIds, plDynamicObjects, "B", label2tagMap);
            }
            logger.info("LabelTagObjServiceHelper.getLabelBOs2.currentOrgId:{}", (Object)currentOrgId);
            if (!HRStringUtils.equals((String)LabelCategoryEnum.AI.getCode(), (String)category)) continue;
            DynamicObject[] aiDynamicObjects = this.queryAiLabel(aiLabelIds);
            this.buildData(labelBOs, aiDynamicObjects, "C", label2tagMap);
        }
        for (LabelBO labelBO : labelBOs) {
            if (!labelCreateTimeMap.containsKey(labelBO.getId())) continue;
            labelBO.setCreateTime((Date)labelCreateTimeMap.get(labelBO.getId()));
        }
        return labelBOs.stream().distinct().collect(Collectors.toList());
    }

    public List<LabelBO> batchQueryIlPl(Long tagObjTypeId, List<Long> tagObjIds, Long currentOrgId) {
        if (tagObjTypeId == null || CollectionUtils.isEmpty(tagObjIds) || currentOrgId == null) {
            return new ArrayList<LabelBO>();
        }
        ArrayList<LabelBO> labelBOs = new ArrayList<LabelBO>();
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "in", tagObjIds));
        String selectFields = "id,labelid,labelcategory";
        String tagOrderBy = "createtime DESC";
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query(selectFields, tagQFilters.toArray(new QFilter[0]), tagOrderBy);
        HashMap label2tagMap = Maps.newHashMapWithExpectedSize((int)tagDynamicObjects.length);
        ArrayList<Long> ilLabelIds = new ArrayList<Long>(10);
        ArrayList<Long> plLabelIds = new ArrayList<Long>(10);
        for (DynamicObject tagDynamicObj : tagDynamicObjects) {
            Long label = tagDynamicObj.getLong("labelid.id");
            Long tag = tagDynamicObj.getLong("id");
            String category = tagDynamicObj.getString("labelcategory");
            if (HRStringUtils.equals((String)category, (String)"A")) {
                ilLabelIds.add(label);
            }
            if (HRStringUtils.equals((String)category, (String)"B")) {
                plLabelIds.add(label);
            }
            label2tagMap.put(label, tag);
        }
        if (CollectionUtils.isNotEmpty(plLabelIds)) {
            DynamicObject[] plDynamicObjects = this.queryPlLabel(plLabelIds, currentOrgId);
            this.buildData2(labelBOs, plLabelIds, plDynamicObjects, "B", label2tagMap);
        }
        if (CollectionUtils.isNotEmpty(ilLabelIds)) {
            DynamicObject[] ilDynamicObjects = this.queryIlLabel(ilLabelIds);
            this.buildData2(labelBOs, ilLabelIds, ilDynamicObjects, "A", label2tagMap);
        }
        return labelBOs.stream().distinct().collect(Collectors.toList());
    }

    public List<LabelBO> queryRecentUse(Long tagObjTypeId) {
        ArrayList<LabelBO> labelBOs = new ArrayList<LabelBO>();
        if (tagObjTypeId == null) {
            return labelBOs;
        }
        String selectFields = "labelid";
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("creator", "=", (Object)this.currentUserId));
        LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.PAST_ONE_MONTH);
        tagQFilters.add(new QFilter("createtime", ">=", (Object)LocalDateTime.parse(DateUtils.getDayStartTime((LocalDate)startDate), DateFormatConstants.NORM_DATETIME_FORM)));
        tagQFilters.add(new QFilter("createtime", "<=", (Object)LocalDateTime.parse(DateUtils.getDayEndTime((LocalDate)LocalDate.now()), DateFormatConstants.NORM_DATETIME_FORM)));
        ArrayList<String> categoryList = new ArrayList<String>();
        categoryList.add("A");
        categoryList.add("B");
        tagQFilters.add(new QFilter("labelcategory", "in", categoryList));
        String tagOrderBy = "labelcategory DESC , createtime DESC";
        ArrayList<Long> labelIds = new ArrayList<Long>();
        String entry = (String)LabelObjTypeMapperConstants.tagObjTypeMap.get(tagObjTypeId);
        try (DataSet tags = this.tagHrBaseService.queryDataSet(ALGO_KEY_PREFIX + entry, selectFields, tagQFilters.toArray(new QFilter[0]), tagOrderBy);){
            for (Row row : tags) {
                labelIds.add(row.getLong("labelid"));
            }
        }
        if (CollectionUtils.isEmpty(labelIds)) {
            return labelBOs;
        }
        String selects = "id,name,labelcategory";
        ArrayList<QFilter> labelQFilters = new ArrayList<QFilter>(16);
        labelQFilters.add(new QFilter("tagobjtype.fbasedataid", "=", (Object)tagObjTypeId));
        labelQFilters.add(new QFilter("enable", "=", (Object)"1"));
        labelQFilters.add(new QFilter("id", "in", labelIds));
        QFilter plQFilter = LabelDataHelper.getPLLabelQfilter();
        QFilter ilQFilter = LabelDataHelper.getILLabelQfilter();
        labelQFilters.add(plQFilter.or(ilQFilter));
        DynamicObject[] labelDynamicObjects = this.labelHrBaseService.query(selects, labelQFilters.toArray(new QFilter[0]));
        HashMap labelBOMap = Maps.newHashMapWithExpectedSize((int)labelDynamicObjects.length);
        for (DynamicObject labelDynamicObj : labelDynamicObjects) {
            LabelBO labelBO = new LabelBO();
            Long id = labelDynamicObj.getLong("id");
            labelBO.setId(id);
            labelBO.setName(labelDynamicObj.getString("name"));
            labelBO.setLabelCategory(labelDynamicObj.getString("labelcategory"));
            labelBOMap.put(id, labelBO);
        }
        labelIds.stream().forEach(labelId -> {
            LabelBO labelBO = (LabelBO)labelBOMap.get(labelId);
            if (null != labelBO) {
                labelBOs.add(labelBO);
            }
        });
        return labelBOs.stream().distinct().collect(Collectors.toList());
    }

    public boolean removeById(Long labelTagObjId) {
        if (labelTagObjId == null) {
            return false;
        }
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("id", "=", (Object)labelTagObjId));
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query("id", tagQFilters.toArray(new QFilter[0]));
        if (tagDynamicObjects.length == 0) {
            return true;
        }
        int deleteNum = DeleteServiceHelper.delete((String)this.entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)labelTagObjId)});
        return deleteNum == 1;
    }

    public boolean remove(Long tagObjTypeId, Long tagObjId, Long labelId) {
        if (tagObjTypeId == null || tagObjId == null || labelId == null) {
            return false;
        }
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "=", (Object)tagObjId));
        tagQFilters.add(new QFilter("labelid", "=", (Object)labelId));
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query("id", tagQFilters.toArray(new QFilter[0]));
        if (tagDynamicObjects.length == 0) {
            return true;
        }
        Long id = tagDynamicObjects[0].getLong("id");
        int deleteNum = DeleteServiceHelper.delete((String)this.entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return deleteNum == 1;
    }

    public BizResult batchRemove(Long tagObjTypeId, List<Long> tagObjIds, List<Long> labelIds) {
        if (tagObjTypeId == null) {
            return BizResults.failed("tagObjTypeId is null");
        }
        if (CollectionUtils.isEmpty(tagObjIds)) {
            return BizResults.failed("tagObjIds is empty");
        }
        if (CollectionUtils.isEmpty(labelIds)) {
            return BizResults.failed("labelIds is empty");
        }
        ArrayList<QFilter> tagQFilters = new ArrayList<QFilter>(16);
        tagQFilters.add(new QFilter("tagobjtypeid", "=", (Object)tagObjTypeId));
        tagQFilters.add(new QFilter("tagobjid", "in", tagObjIds));
        tagQFilters.add(new QFilter("labelid", "in", labelIds));
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query("id", tagQFilters.toArray(new QFilter[0]));
        if (tagDynamicObjects.length == 0) {
            return BizResults.success();
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject tagDynamicObject : tagDynamicObjects) {
            ids.add(tagDynamicObject.getLong("id"));
        }
        DeleteServiceHelper.delete((String)this.entityName, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return BizResults.success();
    }

    private DynamicObject[] queryAiLabel(List<Long> aiLabelIds) {
        if (CollectionUtils.isEmpty(aiLabelIds)) {
            return new DynamicObject[0];
        }
        ArrayList<QFilter> aiQFilters = new ArrayList<QFilter>(16);
        aiQFilters.add(new QFilter("id", "in", aiLabelIds));
        aiQFilters.add(new QFilter("display", "=", (Object)"T"));
        return this.labelHrBaseService.query(this.selectLabelProperties, aiQFilters.toArray(new QFilter[0]));
    }

    private DynamicObject[] queryPlLabel(List<Long> plLabelIds, Long currentOrgId) {
        if (CollectionUtils.isEmpty(plLabelIds) || null == currentOrgId) {
            return new DynamicObject[0];
        }
        ArrayList<QFilter> plQFilters = new ArrayList<QFilter>(16);
        plQFilters.add(new QFilter("id", "in", plLabelIds));
        plQFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_publiclabel", (Long)currentOrgId));
        return this.plHrBaseService.query(this.selectLabelProperties, plQFilters.toArray(new QFilter[0]));
    }

    private DynamicObject[] queryIlLabel(List<Long> ilLabelIds) {
        if (CollectionUtils.isEmpty(ilLabelIds)) {
            return new DynamicObject[0];
        }
        ArrayList<QFilter> ilQFilters = new ArrayList<QFilter>(16);
        ilQFilters.add(new QFilter("id", "in", ilLabelIds));
        ilQFilters.add(new QFilter("creator", "=", (Object)this.currentUserId));
        return this.ilHrBaseService.query(this.selectLabelProperties, ilQFilters.toArray(new QFilter[0]));
    }

    private void buildData(List<LabelBO> labelBOs, DynamicObject[] labelDynamicObjects, String category, Map<Long, Long> label2tagMap) {
        for (DynamicObject labelDynamicObj : labelDynamicObjects) {
            LabelBO labelBO = new LabelBO();
            Long id = labelDynamicObj.getLong("id");
            labelBO.setId(id);
            labelBO.setName(labelDynamicObj.getString("name"));
            labelBO.setLabelCategory(category);
            labelBO.setLabelTagObjId(label2tagMap.get(id));
            labelBOs.add(labelBO);
        }
    }

    private void buildData2(List<LabelBO> labelBOs, List<Long> labelIds, DynamicObject[] labelDynamicObjects, String category, Map<Long, Long> label2tagMap) {
        HashMap labelBOMap = Maps.newHashMapWithExpectedSize((int)labelDynamicObjects.length);
        for (DynamicObject labelDynamicObj : labelDynamicObjects) {
            LabelBO labelBO = new LabelBO();
            Long id = labelDynamicObj.getLong("id");
            labelBO.setId(id);
            labelBO.setName(labelDynamicObj.getString("name"));
            labelBO.setLabelCategory(category);
            labelBO.setLabelTagObjId(label2tagMap.get(id));
            labelBOMap.put(id, labelBO);
        }
        labelIds.stream().forEach(labelId -> {
            LabelBO labelBO = (LabelBO)labelBOMap.get(labelId);
            if (null != labelBO) {
                labelBOs.add(labelBO);
            }
        });
    }

    private List<LabelBO> getLabelBOs(Long currentOrgId, List<LabelBO> labelBOs, List<QFilter> tagQFilters) {
        String selectFields = "id,labelid,labelcategory";
        String tagOrderBy = "createtime DESC";
        DynamicObject[] tagDynamicObjects = this.tagHrBaseService.query(selectFields, tagQFilters.toArray(new QFilter[0]), tagOrderBy);
        HashMap<Long, Long> label2tagMap = new HashMap<Long, Long>(tagDynamicObjects.length);
        ArrayList<Long> ilLabelIds = new ArrayList<Long>();
        ArrayList<Long> plLabelIds = new ArrayList<Long>();
        ArrayList<Long> aiLabelIds = new ArrayList<Long>();
        for (DynamicObject tagDynamicObj : tagDynamicObjects) {
            Long label = tagDynamicObj.getLong("labelid.id");
            Long tag = tagDynamicObj.getLong("id");
            String category = tagDynamicObj.getString("labelcategory");
            if (HRStringUtils.equals((String)category, (String)"A")) {
                ilLabelIds.add(label);
            }
            if (HRStringUtils.equals((String)category, (String)"B")) {
                plLabelIds.add(label);
            }
            if (HRStringUtils.equals((String)category, (String)"C")) {
                aiLabelIds.add(label);
            }
            label2tagMap.put(label, tag);
        }
        if (CollectionUtils.isNotEmpty(ilLabelIds)) {
            DynamicObject[] ilDynamicObjects = this.queryIlLabel(ilLabelIds);
            this.buildData2(labelBOs, ilLabelIds, ilDynamicObjects, "A", label2tagMap);
        }
        if (CollectionUtils.isNotEmpty(plLabelIds)) {
            DynamicObject[] plDynamicObjects = this.queryPlLabel(plLabelIds, currentOrgId);
            this.buildData2(labelBOs, plLabelIds, plDynamicObjects, "B", label2tagMap);
        }
        if (CollectionUtils.isNotEmpty(aiLabelIds)) {
            DynamicObject[] aiDynamicObjects = this.queryAiLabel(aiLabelIds);
            this.buildData(labelBOs, aiDynamicObjects, "C", label2tagMap);
        }
        return labelBOs.stream().distinct().collect(Collectors.toList());
    }

    private void groupLabel(Map<Long, Long> label2tagMap, List<Long> ilLabelIds, List<Long> plLabelIds, List<Long> aiLabelIds, Row row, Map<Long, Date> labelCreateTimeMap) {
        Long labelId = row.getLong("labelid");
        Long tagId = row.getLong("id");
        label2tagMap.put(labelId, tagId);
        String category = row.getString("labelcategory");
        logger.info("LabelTagObjServiceHelper.groupLabel {} {} {}", new Object[]{labelId, tagId, category});
        if (HRStringUtils.equals((String)category, (String)"A")) {
            ilLabelIds.add(labelId);
            labelCreateTimeMap.put(labelId, row.getDate("createtime"));
        }
        if (HRStringUtils.equals((String)category, (String)"B")) {
            plLabelIds.add(labelId);
            labelCreateTimeMap.put(labelId, row.getDate("createtime"));
        }
        if (HRStringUtils.equals((String)category, (String)"C")) {
            aiLabelIds.add(labelId);
        }
        logger.info("LabelTagObjServiceHelper.groupLabel.labelIds {} {} {}", new Object[]{JSONObject.toJSONString(ilLabelIds), JSONObject.toJSONString(plLabelIds), JSONObject.toJSONString(aiLabelIds)});
    }
}

