/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.mq.consumer.label;

import java.io.IOException;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tsc.tsrbd.business.domain.label.service.AILabelApiServiceHelper;

public class AILabelConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(AILabelConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        Map pushData = (Map)body;
        Object tagObjId = pushData.get("tagobjid");
        try {
            logger.info("AILabelAPI consumption start tagObjId : {}", tagObjId);
            AILabelApiServiceHelper.getInstance().addAILabel(pushData);
            logger.info("AILabelAPI consumption end tagObjId : {}", tagObjId);
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
                logger.error("AILabelAPI consumption discard tagObjId : {} msg : {}", tagObjId, (Object)e);
            }
            acker.deny(messageId);
            logger.error("AILabelAPI consumption again tagObjId : {} msg : {}", tagObjId, (Object)e);
        }
    }

    public String getRouteKey() {
        return "tsc";
    }
}

