/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.msgtrack.service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.MessageContentDO;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.entity.msgtrack.MsgTrackDTO;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class MsgTrackHelper {
    public static final Log logger = LogFactory.getLog(MsgTrackHelper.class);

    public static DynamicObject queryMsgTrack(Long msgTrackId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        return hrBaseServiceHelper.loadSingle((Object)msgTrackId);
    }

    public static DynamicObject[] queryMsgTrackObjList(Long bizobj) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrackobj");
        QFilter qFilter = new QFilter("bizobj", "=", (Object)bizobj);
        return hrServiceHelper.query("oprecordid,msgtrackid", new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryMsgTrackObjLists(List<Long> msgTrackId) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrackobj");
        QFilter qFilter = new QFilter("msgtrackid", "in", msgTrackId);
        return hrServiceHelper.query("msgtrackid,bizobj", new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryMsgTrackList(List<Long> list) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObject[] dyObjs = hrBaseServiceHelper.query("id,notmethod,pushscene,sender,createtime,sendstatus,faireason,emailtitle,sendtime,repeatcount", qFilter.toArray(), "sendtime desc");
        return dyObjs;
    }

    public static void updateMsgTrackByResend(List<Long> msgResendIds) {
        DynamicObject[] msgResendObjs;
        QFilter filter = new QFilter("id", "in", msgResendIds);
        QFilter[] filters = new QFilter[]{filter};
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_msgtrack");
        for (DynamicObject dynamicObject : msgResendObjs = helper.loadDynamicObjectArray(filters)) {
            int repeatCount = dynamicObject.getInt("repeatcount");
            dynamicObject.set("repeatcount", (Object)(repeatCount + 1));
            dynamicObject.set("sender", (Object)TSCRequestContext.getUserId());
            dynamicObject.set("sendtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            dynamicObject.set("sendstatus", (Object)"0");
            dynamicObject.set("faireason", (Object)" ");
        }
        SaveServiceHelper.update((DynamicObject[])msgResendObjs);
    }

    public static void updateMsgTrackByResult(Map<String, Object> data) {
        Long msgId = (Long)data.get("msgid");
        DynamicObject msgTrack = MsgTrackHelper.queryMsgTrackByMsg(msgId);
        Iterator<String> it = data.keySet().iterator();
        while (it.hasNext()) {
            String fieldName = it.next().toString();
            msgTrack.set(fieldName, data.get(fieldName));
        }
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        logger.info("MsgTrackHelper.updateMsgTrackByResult {}}", (Object)msgTrack);
        hrServiceHelper.updateOne(msgTrack);
    }

    public static List<Long> queryMsgLogIdById(List<Long> msgTrackIds) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        QFilter qFilter = new QFilter("id", "in", msgTrackIds);
        DynamicObject[] msgTracks = hrServiceHelper.query("msglogid", new QFilter[]{qFilter});
        ArrayList<Long> msgLogIds = new ArrayList<Long>(msgTracks.length);
        for (DynamicObject msgTrackId : msgTracks) {
            msgLogIds.add(msgTrackId.getLong("msglogid"));
        }
        return msgLogIds;
    }

    public static DynamicObject queryMsgTrackByMsg(Long msgId) {
        HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        QFilter qFilter = new QFilter("msgid", "=", (Object)msgId);
        return hrServiceHelper.queryOne("msgid,sendstatus,faireason,msglogid,repeatcount,pushscene", new QFilter[]{qFilter});
    }

    public static boolean judgeNotmethod(DynamicObject msgTrack) {
        ArrayList<Long> notmethodIds = new ArrayList<Long>(1);
        Long notmethod = msgTrack.getDynamicObject("notmethod").getLong("id");
        notmethodIds.add(notmethod);
        Map<Long, Boolean> booleanMap = CfgMsgTemplateHelper.batchQueryChannelEnable(notmethodIds);
        if (booleanMap.size() == 1) {
            Object[] objs = booleanMap.values().toArray();
            return (Boolean)objs[0];
        }
        return false;
    }

    public static void batchSaveMsgTrackAndObj(List<MessageContentDO> messageContentDOs) {
        ArrayList<DynamicObject> msgTracks = new ArrayList<DynamicObject>(messageContentDOs.size());
        ArrayList<DynamicObject> msgTrackObjs = new ArrayList<DynamicObject>(messageContentDOs.size());
        for (MessageContentDO messageContentDO : messageContentDOs) {
            MsgTrackDTO msgTrackDTO = messageContentDO.getMsgTrackDTO();
            if (null == msgTrackDTO || null == msgTrackDTO.getMsgID()) continue;
            DynamicObject msgTrack = BusinessDataServiceHelper.newDynamicObject((String)"tsrbd_msgtrack");
            String codeNumber = CodeRuleServiceHelper.getNumber((String)"tsrbd_msgtrack", (DynamicObject)msgTrack, null);
            Long msgTrackId = ID.genLongId();
            msgTrack.set("id", (Object)msgTrackId);
            msgTrack.set("name", (Object)msgTrackDTO.getName());
            msgTrack.set("number", (Object)codeNumber);
            msgTrack.set("pushscene", (Object)msgTrackDTO.getPushScene());
            msgTrack.set("rectype", (Object)msgTrackDTO.getRecType());
            msgTrack.set("recname", (Object)msgTrackDTO.getRecName());
            msgTrack.set("recemail", (Object)msgTrackDTO.getRecEmail());
            msgTrack.set("recphone", (Object)msgTrackDTO.getRecPhone());
            msgTrack.set("notmethod", (Object)msgTrackDTO.getNotMethod());
            msgTrack.set("emailtitle", (Object)msgTrackDTO.getEmailTitle());
            msgTrack.set("sendstatus", (Object)msgTrackDTO.getSendStatus());
            msgTrack.set("faireason", (Object)msgTrackDTO.getFailReason());
            msgTrack.set("sender", (Object)msgTrackDTO.getSender());
            msgTrack.set("sendtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            msgTrack.set("creator", (Object)msgTrackDTO.getSender());
            msgTrack.set("createtime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            msgTrack.set("msgcontent", (Object)msgTrackDTO.getMsgContent());
            msgTrack.set("msgid", (Object)msgTrackDTO.getMsgID());
            msgTrack.set("repeatcount", (Object)0);
            msgTracks.add(msgTrack);
            DynamicObject msgTrackObj = BusinessDataServiceHelper.newDynamicObject((String)"tsrbd_msgtrackobj");
            msgTrackObj.set("msgtrackid", (Object)msgTrackId);
            msgTrackObj.set("oprecordid", (Object)msgTrackDTO.getOpRecordID());
            msgTrackObj.set("bizentity", (Object)msgTrackDTO.getBizEntity());
            msgTrackObj.set("bizobj", (Object)msgTrackDTO.getBizObj());
            msgTrackObjs.add(msgTrackObj);
        }
        SaveServiceHelper.save((DynamicObject[])msgTracks.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])msgTrackObjs.toArray(new DynamicObject[0]));
    }
}

