/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class TscJobScmRepository {
    private static final Log logger = LogFactory.getLog(TscJobScmRepository.class);
    public static final String JOB_LEVEL_SEQ = "joblevelseq";
    public static final String JOB_GRADE_SEQ = "jobgradeseq";

    public static TscJobScmRepository getInstance() {
        return JobLevelScmInstance.INSTANCE;
    }

    public QFilter getJobLevelFilter(Long jobLevelScmId) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("hbjm_joblevelscmhr");
        DynamicObject dy = serviceHelper.loadSingle((Object)jobLevelScmId);
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("entryentity");
        List list = collection.stream().map(entry -> entry.getString("joblevel_number")).collect(Collectors.toList());
        return new QFilter("number", "in", list);
    }

    public QFilter getJobGradeFilter(Long jobGradeScmId) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("hbjm_jobgradescmhr");
        DynamicObject dy = serviceHelper.loadSingle((Object)jobGradeScmId);
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("entryentity");
        List list = collection.stream().map(entry -> entry.getString("jobgrade_number")).collect(Collectors.toList());
        return new QFilter("number", "in", list);
    }

    public DynamicObject[] queryJobClassScm(Long jobScmId, Long jobSeqId, Long jobFamilyId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobclass.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobclass.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter seqFilter = new QFilter("jobfamily.jobseq", "=", (Object)jobSeqId);
        QFilter familyFilter = new QFilter("jobfamily", "=", (Object)jobFamilyId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{scmFilter, enableFilter, seqFilter, familyFilter});
    }

    public DynamicObject[] queryJobClassScm(List<Long> jobScmId, List<Long> jobSeqId, List<Long> jobFamilyId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobclass.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobclass.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "in", jobScmId);
        QFilter seqFilter = new QFilter("jobfamily.jobseq", "in", jobSeqId);
        QFilter familyFilter = new QFilter("jobfamily", "in", jobFamilyId);
        QFilter initstatusFilter = new QFilter("jobclass.initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.queryOriginalArray("jobclass.name,jobscm,jobfamily.jobseq,jobfamily,jobclass,jobclass.enable,jobclass.parent", new QFilter[]{scmFilter, enableFilter, seqFilter, familyFilter, initstatusFilter});
    }

    public DynamicObject[] queryJobClassScm(Long jobScmId, List<Long> jobFamilyId, Boolean isShowDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = isShowDisable != false ? new QFilter("jobclass.enable", "in", Arrays.asList("1", "0")) : new QFilter("jobclass.enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter familyFilter = new QFilter("jobfamily", "in", jobFamilyId);
        QFilter initstatusFilter = new QFilter("jobclass.initstatus", "not in", (Object)new String[]{"0", "1"});
        return serviceHelper.queryOriginalArray("jobclass.name,jobscm,jobfamily.jobseq,jobfamily,jobclass,jobclass.enable,jobclass.parent", new QFilter[]{scmFilter, enableFilter, familyFilter, initstatusFilter});
    }

    public DynamicObject[] queryJobFamilyScmByScmId(Long jobScmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return serviceHelper.query("id,name,number,jobseq,jobfamily,createorg,jobgradescm,joblevelscm", new QFilter[]{scmFilter, enableFilter}, "index asc");
    }

    public DynamicObject[] queryJobSeqScmByScmId(Long jobScmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobseqscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        return serviceHelper.query("id,name,number,jobseq,createorg", new QFilter[]{scmFilter, enableFilter}, "index asc");
    }

    public DynamicObject queryBaseInfoById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        return serviceHelper.loadDynamicObject(filters);
    }

    public DynamicObject queryGradeBaseInfoById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobgradescmhr");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        return serviceHelper.loadDynamicObject(filters);
    }

    public DynamicObject[] queryJobClassScm(Long jobScmId, List<Long> classIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobclassscm");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter scmFilter = new QFilter("jobscm", "=", (Object)jobScmId);
        QFilter classFilter = new QFilter("jobclass", "in", classIds);
        return serviceHelper.query("id,name,number,jobfamily,jobclass,createorg,highjobgrade,lowjobgrade,highjoblevel,lowjoblevel", new QFilter[]{scmFilter, enableFilter, classFilter}, "index asc");
    }

    public List<Long> queryJobInfoByScmNumber(String scmNumber, String entityId) {
        logger.info("TscJobScmRepository.queryJobInfoByScmNumber scmNumber : {} entityId : {}", (Object)scmNumber, (Object)entityId);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMScmInfoService", (String)"getJobScmInfo", (Object[])new Object[]{scmNumber, RequestContext.get().getOrgId()});
        TreeNode dataTreeNode = (TreeNode)resultMap.get("data");
        logger.info("TscJobScmRepository.queryJobInfoByScmNumber resultMap : {} ", (Object)resultMap);
        int code = (Integer)resultMap.get("code");
        List<Long> resultList = new ArrayList<Long>(8);
        if (200 == code) {
            List jobSeqTreeNodeList = dataTreeNode.getChildren();
            logger.info("TscJobScmRepository.queryJobInfoByScmNumber jobSeqTreeNodeList : {} ", (Object)jobSeqTreeNodeList);
            if ("hbjm_jobseqscm".equals(entityId)) {
                resultList = jobSeqTreeNodeList.stream().map(jobSeqTreeNode -> Long.parseLong(jobSeqTreeNode.getId())).collect(Collectors.toList());
            } else {
                for (TreeNode jobSeqTreeNode2 : jobSeqTreeNodeList) {
                    List jobFamilyTreeNodeList = jobSeqTreeNode2.getChildren();
                    logger.info("TscJobScmRepository.queryJobInfoByScmNumber jobFamilyTreeNodeList : {} ", (Object)jobFamilyTreeNodeList);
                    for (TreeNode jobFamilyTreeNode : jobFamilyTreeNodeList) {
                        if ("hbjm_jobfamilyscm".equals(entityId)) {
                            logger.info("TscJobScmRepository.queryJobInfoByScmNumber id : {} ", (Object)jobFamilyTreeNode.getId());
                            resultList.add(Long.parseLong(jobFamilyTreeNode.getId()));
                            continue;
                        }
                        List jobClassTreeNodeList = jobFamilyTreeNode.getChildren();
                        logger.info("TscJobScmRepository.queryJobInfoByScmNumber jobClassTreeNodeList : {} ", (Object)jobClassTreeNodeList);
                        if (jobClassTreeNodeList == null || jobClassTreeNodeList.isEmpty()) continue;
                        List collect = jobClassTreeNodeList.stream().map(joClassTreeNode -> Long.parseLong(joClassTreeNode.getId())).collect(Collectors.toList());
                        resultList.addAll(collect);
                    }
                }
            }
        }
        logger.info("TscJobScmRepository.queryJobInfoByScmNumber resultList : {} ", resultList);
        return resultList;
    }

    private static class JobLevelScmInstance {
        private static TscJobScmRepository INSTANCE = new TscJobScmRepository();

        private JobLevelScmInstance() {
        }
    }
}

