/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class FieldPoolHelper {
    private static final HRBaseServiceHelper MSG_FIELD_HELPER = new HRBaseServiceHelper("tsrbd_offerfield");
    private static final HRBaseServiceHelper MSG_FIELDBLOCK_HELPER = new HRBaseServiceHelper("tsrbd_fieldblock");
    private static final String LIKE_PREFIX = "%,";
    private static final String LIKE_SUFFIX = ",%";

    public static DynamicObject[] getFieldPoolByFieldKey(Set<String> fieldKeys) {
        HRBaseServiceHelper poolHelper = new HRBaseServiceHelper("tsrbd_fieldpool");
        QFilter filter = new QFilter("fieldkey", "in", fieldKeys);
        return poolHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static void getFieldKeyMappingName(Map<String, String> poolMap, String bizRange) {
        DynamicObject[] dys;
        for (DynamicObject dy : dys = FieldPoolHelper.getTotalMsgFields(bizRange)) {
            String bizField = dy.getString("bizfield");
            if (HRStringUtils.isEmpty((String)bizField)) {
                DynamicObject fieldPool = dy.getDynamicObject("fieldpool");
                bizField = fieldPool.getString("fieldkey");
            }
            poolMap.put(bizField, dy.getString("name"));
        }
    }

    public static Map<String, String> getOfferFieldMappingMap(String bizRange) {
        DynamicObject[] dys = FieldPoolHelper.getTotalMsgFields(bizRange);
        HashMap mappingMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : dys) {
            String bizField = dy.getString("bizfield");
            if (!HRStringUtils.isNotEmpty((String)bizField)) continue;
            DynamicObject fieldPool = dy.getDynamicObject("fieldpool");
            String fieldKey = fieldPool.getString("fieldkey");
            mappingMap.put(bizField, fieldKey);
        }
        return mappingMap;
    }

    public static DynamicObject[] getTotalMsgFields(String bizRange) {
        String likeCondition = LIKE_PREFIX + bizRange + LIKE_SUFFIX;
        QFilter filter = new QFilter("bizrange", "like", (Object)likeCondition);
        return MSG_FIELD_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static Map<String, List<String>> getEntryField(String bizRange) {
        DynamicObject[] bizDys = FieldPoolHelper.getTotalMsgFields(bizRange);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject bizDy : bizDys) {
            String bizField;
            DynamicObject fieldBlock = bizDy.getDynamicObject("group");
            if (null == fieldBlock) continue;
            String entryNumber = fieldBlock.getString("simplename");
            List list = (List)resultMap.get(entryNumber);
            if (null == list) {
                list = Lists.newArrayListWithCapacity((int)16);
            }
            if (HRStringUtils.isEmpty((String)(bizField = bizDy.getString("bizfield")))) {
                DynamicObject fieldpool = bizDy.getDynamicObject("fieldpool");
                bizField = fieldpool.getString("fieldkey");
            }
            list.add(bizField);
            resultMap.put(entryNumber, list);
        }
        return resultMap;
    }

    public static Map<String, Long> isExistFieldBlock(List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        DynamicObject[] dys = MSG_FIELDBLOCK_HELPER.queryOriginalArray("number,id", new QFilter[]{numberFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)numberList.size());
        numberList.forEach(number -> result.put(number, 0L));
        for (DynamicObject dy : dys) {
            String number2 = dy.getString("number");
            result.put(number2, dy.getLong("id"));
        }
        return result;
    }

    private FieldPoolHelper() {
    }

    public static void updateEnableStatus(DynamicObject[] fieldPoolsByGroupList, List<String> payNumberList) {
        if (fieldPoolsByGroupList.length == 0) {
            return;
        }
        Map<String, String> payNumberMap = payNumberList.stream().collect(Collectors.toMap(num -> num, num -> num));
        for (DynamicObject fieldPool : fieldPoolsByGroupList) {
            if (payNumberMap.isEmpty()) break;
            if (payNumberMap.containsKey(fieldPool.getString("number"))) {
                fieldPool.set("enable", (Object)"1");
                continue;
            }
            fieldPool.set("enable", (Object)"0");
        }
        MSG_FIELD_HELPER.save(fieldPoolsByGroupList);
    }
}

