/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.helper;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsrbd.business.domain.offer.repository.TscJobScmRepository;

public class JobFamilyScmHelper {
    private static final Log logger = LogFactory.getLog(JobFamilyScmHelper.class);

    public static QFilter getJobScmFilter(DynamicObject dy) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        if (null != dy) {
            filter.and(new QFilter("id", "!=", (Object)dy.getLong("id")));
        }
        logger.info("JobFamilyScmHelper.getJobScmFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getJobSeqFilter(DynamicObject jobScm, DynamicObject jobSeqDy) {
        logger.info("JobFamilyScmHelper.getJobSeqFilter jobScm.number : {} orgId : {}", (Object)jobScm.getString("number"), (Object)RequestContext.get().getOrgId());
        List<Long> jobSeqIdList = TscJobScmRepository.getInstance().queryJobInfoByScmNumber(jobScm.getString("number"), "hbjm_jobseqscm");
        if (null != jobSeqDy && jobSeqIdList.size() > 0) {
            jobSeqIdList.remove(jobSeqDy.getLong("id"));
        }
        QFilter resFilter = new QFilter("id", "in", jobSeqIdList);
        logger.info("JobFamilyScmHelper.getJobSeqFilter.filter:[{}]", (Object)resFilter);
        return resFilter;
    }

    public static QFilter getJobFamilyFilter(DynamicObject jobScm, List<DynamicObject> jobFamily) {
        List<Long> familyIds = TscJobScmRepository.getInstance().queryJobInfoByScmNumber(jobScm.getString("number"), "hbjm_jobfamilyscm");
        QFilter filter = new QFilter("id", "in", (Object)familyIds.add(1528361377603784704L));
        if (!jobFamily.isEmpty()) {
            List familyIdList = jobFamily.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            familyIds.removeAll(familyIdList);
        }
        logger.info("JobFamilyScmHelper.getJobFamilyFilter.familyFilter:[{}]", (Object)filter);
        return new QFilter("id", "in", familyIds);
    }

    public static QFilter getJobClassFilter(DynamicObject jobScm, DynamicObject jobClass) {
        List<Long> jobClassIds = TscJobScmRepository.getInstance().queryJobInfoByScmNumber(jobScm.getString("number"), "hbjm_jobclassscm");
        if (null != jobClass && !jobClassIds.isEmpty()) {
            jobClassIds.remove(jobClass.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", jobClassIds);
        logger.info("JobFamilyScmHelper.getJobClassFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getJobClassFilter(DynamicObject jobScm, List<DynamicObject> jobFamily, List<DynamicObject> jobClass) {
        long jobScmId = jobScm.getLong("id");
        List<Long> familyList = jobFamily.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] classScmDys = TscJobScmRepository.getInstance().queryJobClassScm(jobScmId, familyList, Boolean.FALSE);
        List jobClassIds = Arrays.stream(classScmDys).map(dy -> dy.getLong("jobclass")).collect(Collectors.toList());
        if (Objects.nonNull(jobClass) && !jobClass.isEmpty()) {
            List jobClassIdList = jobClass.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            jobClassIds.removeAll(jobClassIdList);
        }
        QFilter filter = new QFilter("id", "in", jobClassIds);
        logger.info("JobFamilyScmHelper.getJobClassFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getLowJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject highJobLevel) {
        QFilter filter = JobFamilyScmHelper.buildJobLevelFilter(jobScm, jobFamily, jobClass);
        if (null != highJobLevel) {
            int jobLevelSeq = highJobLevel.getInt("joblevelseq");
            if (filter == null) {
                filter = new QFilter("joblevelseq", "<=", (Object)jobLevelSeq);
            } else {
                filter.and(new QFilter("joblevelseq", "<=", (Object)jobLevelSeq));
            }
        }
        logger.info("JobFamilyScmHelper.getLowJobLevelFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getHighJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject lowJobLevel) {
        QFilter filter = JobFamilyScmHelper.buildJobLevelFilter(jobScm, jobFamily, jobClass);
        if (null != lowJobLevel) {
            int jobLevelSeq = lowJobLevel.getInt("joblevelseq");
            if (filter == null) {
                filter = new QFilter("joblevelseq", ">=", (Object)jobLevelSeq);
            } else {
                filter.and(new QFilter("joblevelseq", ">=", (Object)jobLevelSeq));
            }
        }
        logger.info("JobFamilyScmHelper.getHighJobLevelFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getLowJobGradeFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject highGradeLevel) {
        QFilter filter = JobFamilyScmHelper.buildJobGradeFilter(jobScm, jobFamily, jobClass);
        if (null != highGradeLevel) {
            int jobLevelSeq = highGradeLevel.getInt("jobgradeseq");
            if (filter == null) {
                filter = new QFilter("jobgradeseq", "<=", (Object)jobLevelSeq);
            } else {
                filter.and("jobgradeseq", "<=", (Object)jobLevelSeq);
            }
        }
        logger.info("JobFamilyScmHelper.getLowJobGradeFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter getHighJobGradeFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass, DynamicObject lowJowGrade) {
        QFilter filter = JobFamilyScmHelper.buildJobGradeFilter(jobScm, jobFamily, jobClass);
        if (null != lowJowGrade) {
            int jobLevelSeq = lowJowGrade.getInt("jobgradeseq");
            if (filter == null) {
                filter = new QFilter("jobgradeseq", ">=", (Object)jobLevelSeq);
            } else {
                filter.and("jobgradeseq", ">=", (Object)jobLevelSeq);
            }
        }
        logger.info("JobFamilyScmHelper.getHighJobGradeFilter.filter:[{}]", (Object)filter);
        return filter;
    }

    public static QFilter buildJobLevelFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass) {
        long jobLevelScmId;
        Long jobScmId = jobScm.getLong("id");
        DynamicObject[] familyDys = TscJobScmRepository.getInstance().queryJobFamilyScmByScmId(jobScmId);
        Optional<DynamicObject> optional = Arrays.stream(familyDys).filter(dy -> dy.getLong("jobfamily.id") == jobFamily.getLong("id")).findFirst();
        if (optional.isPresent()) {
            jobLevelScmId = optional.get().getLong("joblevelscm.id");
        } else {
            DynamicObject jobScmDy = TscJobScmRepository.getInstance().queryBaseInfoById(jobScmId);
            jobLevelScmId = jobScmDy.getLong("joblevelscm.id");
        }
        QFilter filter = null;
        if (jobLevelScmId != 0L) {
            filter = TscJobScmRepository.getInstance().getJobLevelFilter(jobLevelScmId);
        }
        if (Objects.nonNull(jobClass)) {
            DynamicObject[] jobClassScmDys = TscJobScmRepository.getInstance().queryJobClassScm(jobScmId, (List<Long>)ImmutableList.of((Object)jobClass.getLong("id")));
            String common = ".joblevelseq";
            int lowJobLevel = jobClassScmDys[0].getInt("lowjoblevel" + common);
            int highJobLevel = jobClassScmDys[0].getInt("highjoblevel" + common);
            if (filter == null) {
                filter = new QFilter("joblevelseq", ">=", (Object)lowJobLevel);
            } else {
                filter.and("joblevelseq", ">=", (Object)lowJobLevel);
            }
            filter.and("joblevelseq", "<=", (Object)highJobLevel);
        }
        return filter;
    }

    public static QFilter buildJobGradeFilter(DynamicObject jobScm, DynamicObject jobFamily, DynamicObject jobClass) {
        long jobGradeScm;
        Long jobScmId = jobScm.getLong("id");
        DynamicObject[] familyDys = TscJobScmRepository.getInstance().queryJobFamilyScmByScmId(jobScmId);
        Optional<DynamicObject> optional = Arrays.stream(familyDys).filter(dy -> dy.getLong("jobfamily.id") == jobFamily.getLong("id")).findFirst();
        if (optional.isPresent()) {
            jobGradeScm = optional.get().getLong("jobgradescm.id");
        } else {
            DynamicObject jobScmDy = TscJobScmRepository.getInstance().queryBaseInfoById(jobScmId);
            jobGradeScm = jobScmDy.getLong("jobgradescm.id");
        }
        QFilter filter = null;
        if (jobGradeScm != 0L) {
            filter = TscJobScmRepository.getInstance().getJobGradeFilter(jobGradeScm);
        }
        if (Objects.nonNull(jobClass)) {
            DynamicObject[] jobClassScmDys = TscJobScmRepository.getInstance().queryJobClassScm(jobScmId, (List<Long>)ImmutableList.of((Object)jobClass.getLong("id")));
            String common = ".jobgradeseq";
            int lowJobLevel = jobClassScmDys[0].getInt("lowjobgrade" + common);
            int highJobLevel = jobClassScmDys[0].getInt("highjobgrade" + common);
            if (filter == null) {
                filter = new QFilter("jobgradeseq", ">=", (Object)lowJobLevel);
            } else {
                filter.and("jobgradeseq", ">=", (Object)lowJobLevel);
            }
            filter.and("jobgradeseq", "<=", (Object)highJobLevel);
        }
        return filter;
    }
}

