/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.helper;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.hr.metadata.prop.MulQueryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;
import kd.tsc.tsrbd.common.enums.PostAssignModeEnum;

public class OfferFieldsHelper {
    private static Log logger = LogFactory.getLog(OfferFieldsHelper.class);
    private static final String LEFT_SPAN = "<span>";
    private static final String RIGHT_SPAN = "</span>";
    private static final char CHAR_LEFT_BRACKETS = '{';
    private static final char CHAR_RIGHT_BRACKETS = '}';

    public static String getTemplatePreviewContent(String template, Map<String, String> param) {
        List<String> paramList = OfferFieldsHelper.getTemplateFields(template);
        StringBuilder buffer = new StringBuilder();
        Collection<String> values = param.values();
        for (String field : paramList) {
            if (values.contains(field)) {
                buffer.append(LEFT_SPAN).append('{').append(field).append('}').append(RIGHT_SPAN);
                continue;
            }
            buffer.append(field);
        }
        return buffer.toString();
    }

    public static Map<String, String> getOfferTemplateMap(List<DynamicObject> offerEntry) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : offerEntry) {
            DataEntityPropertyCollection properties = dy.getDynamicObjectType().getProperties();
            block1: for (IDataEntityProperty property : properties) {
                String name = property.getName();
                Object prop = dy.get(name);
                if (Objects.isNull(prop)) continue;
                if (property instanceof ComboProp) {
                    List comboItems = ((ComboProp)property).getComboItems();
                    if (Objects.isNull(comboItems)) continue;
                    for (ValueMapItem comboItem : comboItems) {
                        if (!HRStringUtils.equals((String)prop.toString(), (String)comboItem.getValue())) continue;
                        String value = comboItem.getName().getLocaleValue();
                        resultMap.put(name, value);
                        continue block1;
                    }
                    continue;
                }
                if (property instanceof MulQueryProp) {
                    MulBasedataDynamicObjectCollection mulBaseData = (MulBasedataDynamicObjectCollection)dy.get(name);
                    String mulBaseNames = mulBaseData.stream().map(dynamicObject -> dynamicObject.getString("fbasedataid.name")).collect(Collectors.joining(", "));
                    resultMap.put(name, mulBaseNames);
                    continue;
                }
                if (prop instanceof OrmLocaleValue) {
                    OrmLocaleValue localeValue = (OrmLocaleValue)prop;
                    String value = localeValue.getLocaleValue();
                    resultMap.putIfAbsent(name, value);
                    continue;
                }
                if (prop instanceof Number) {
                    Number num = (Number)prop;
                    NumberFormat numFormat = NumberFormat.getNumberInstance();
                    numFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
                    resultMap.putIfAbsent(name, numFormat.format(num));
                    continue;
                }
                if (prop instanceof DynamicObject) {
                    DynamicObject temDy = (DynamicObject)prop;
                    String fields = HRDynamicObjectUtils.getQueryFields((DynamicObject)temDy);
                    fields = "," + fields + ",";
                    if (!fields.contains(",name,")) continue;
                    resultMap.put(name, temDy.getString("name"));
                    continue;
                }
                if (prop instanceof Date) {
                    Date temDate = (Date)prop;
                    if ("lastreplytime".equals(name)) {
                        resultMap.put(name, HRInteDateTimeUtil.formatDate((String)"tso_offerletter", (String)name, (Date)temDate));
                        continue;
                    }
                    if (dy.getDataEntityType() instanceof BillEntityType) {
                        resultMap.put(name, HRInteDateTimeUtil.formatDate((String)dy.getDataEntityType().getName(), (String)name, (Date)temDate));
                        continue;
                    }
                    resultMap.put(name, HRDateTimeUtils.format((Date)temDate, (String)"yyyy-MM-dd"));
                    continue;
                }
                resultMap.put(name, prop.toString());
            }
        }
        return resultMap;
    }

    public static String getTemplateContent(String template, Map<String, String> param) {
        List<String> paramList = OfferFieldsHelper.getTemplateFields(template);
        HashMap poolMap = Maps.newHashMapWithExpectedSize((int)16);
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "0");
        StringBuilder buffer = new StringBuilder();
        for (String tmpField : paramList) {
            String bizValue;
            String defaultValue = poolMap.getOrDefault(tmpField, null);
            if (HRStringUtils.isEmpty((String)defaultValue)) {
                buffer.append(tmpField);
                continue;
            }
            if ("peposition".equals(tmpField)) {
                tmpField = PostAssignModeEnum.getPostFieldForId((String)param.get("postassignmode"));
            }
            if (!HRStringUtils.isNotEmpty((String)(bizValue = param.get(tmpField)))) continue;
            buffer.append(OfferFieldsHelper.addSpanForValue(bizValue));
        }
        return buffer.toString();
    }

    public static String getTemplateContent(String template, Map<String, String> param, Boolean isShowEmptyFields) {
        List<String> paramList = OfferFieldsHelper.getTemplateFields(template);
        HashMap poolMap = Maps.newHashMapWithExpectedSize((int)16);
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "0");
        StringBuilder buffer = new StringBuilder();
        for (String tmpField : paramList) {
            String bizValue;
            String defaultValue = poolMap.getOrDefault(tmpField, null);
            if (HRStringUtils.isEmpty((String)defaultValue)) {
                buffer.append(tmpField);
                continue;
            }
            if ("peposition".equals(tmpField)) {
                tmpField = PostAssignModeEnum.getPostFieldForId((String)param.get("postassignmode"));
            }
            if (HRStringUtils.isNotEmpty((String)(bizValue = param.get(tmpField)))) {
                buffer.append(OfferFieldsHelper.addSpanForValue(bizValue));
                continue;
            }
            if (!isShowEmptyFields.booleanValue() || param.containsKey(tmpField)) continue;
            buffer.append(OfferFieldsHelper.addCharForValue(tmpField));
        }
        return buffer.toString();
    }

    public static DynamicObject[] getFieldPoolByMsgFieldNumber(List<String> numbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_offerfield");
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{OfferFieldsHelper.getNumberFilter(numbers)});
        List<String> poolNumbers = Arrays.stream(dys).map(dy -> dy.getDynamicObject("fieldpool").getString("number")).collect(Collectors.toList());
        return OfferFieldsHelper.getFieldPoolByNumberList(poolNumbers);
    }

    public static DynamicObject[] getFieldPoolByNumberList(List<String> numbers) {
        HRBaseServiceHelper poolHelper = new HRBaseServiceHelper("tsrbd_fieldpool");
        return poolHelper.loadDynamicObjectArray(new QFilter[]{OfferFieldsHelper.getNumberFilter(numbers)});
    }

    public static String zhSwitchEn(String content) {
        HashMap poolMap = Maps.newHashMapWithExpectedSize((int)16);
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "0");
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "1");
        for (Map.Entry entry : poolMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            content = content.replace(OfferFieldsHelper.addCharForValue(value), OfferFieldsHelper.addCharForValue(key));
        }
        return content;
    }

    public static String zhSwitchEn(Map<String, String> poolMap, String content) {
        for (Map.Entry<String, String> entry : poolMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            content = content.replace(OfferFieldsHelper.addCharForValue(value), OfferFieldsHelper.addCharForValue(key));
        }
        return content;
    }

    public static String enSwitchZh(String content) {
        TreeMap<String, String> poolMap = new TreeMap<String, String>(Comparator.reverseOrder());
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "0");
        for (Map.Entry entry : poolMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            content = content.replace(key, value);
        }
        return content;
    }

    private static QFilter getNumberFilter(List<String> numbers) {
        return new QFilter("number", "in", numbers);
    }

    public static List<String> getTemplateFields(String template) {
        Iterable split = Splitter.on((char)'{').split((CharSequence)template);
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
        for (String str : split) {
            Iterable split1 = Splitter.on((char)'}').split((CharSequence)str);
            for (String field : split1) {
                paramList.add(field);
            }
        }
        return paramList;
    }

    private static String addCharForValue(String bizValue) {
        return '{' + bizValue + '}';
    }

    private static String addSpanForValue(String bizValue) {
        return LEFT_SPAN + bizValue + RIGHT_SPAN;
    }

    public static DynamicObject[] getFieldpoolsByGroup(Long groupId) {
        HRBaseServiceHelper msgFieldHelper = new HRBaseServiceHelper("tsrbd_offerfield");
        return msgFieldHelper.query("enable", new QFilter("group", "=", (Object)groupId).toArray());
    }
}

