/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;

public class OfferTemplateBizHelper {
    private static final String PAGE_OFFER_TEM_PREVIEW = "tsrbd_offertempreview";
    private static final OfferTemplateHelper OFFER_TEMPLATE_HELPER = new OfferTemplateHelper();

    public FormShowParameter getPreviewOfferTemplateForm(String content) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(PAGE_OFFER_TEM_PREVIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("680");
        inlineStyleCss.setWidth("800");
        parameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        parameter.setCustomParam("content_tag", (Object)content);
        return parameter;
    }

    public static List<FieldTip> judgeRequire(DynamicObject dataEntity, List<String> fields) {
        ArrayList fieldTipList = Lists.newArrayListWithExpectedSize((int)fields.size());
        String message = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"OfferMsgInfoPlugin_0", (String)"tsc-tso-business", (Object[])new Object[0]);
        for (String field : fields) {
            Object fvalue = dataEntity.get(field);
            if (null != fvalue && !HRStringUtils.isEmpty((String)fvalue.toString())) continue;
            FieldTip fieldTip = OfferTemplateBizHelper.createFieldTip(message, field);
            fieldTipList.add(fieldTip);
        }
        return fieldTipList;
    }

    public static String judgeRequireMessage(DynamicObject dataEntity, List<String> fields) {
        Map<String, String> mapping = OfferTemplateBizHelper.getFieldNameMappingLocalValue(dataEntity, fields);
        StringBuilder message = new StringBuilder();
        for (String field : fields) {
            Object fvalue = dataEntity.get(field);
            if (null != fvalue && !HRStringUtils.isEmpty((String)fvalue.toString())) continue;
            message.append(mapping.get(field)).append(',');
        }
        if (message.toString().isEmpty()) {
            return null;
        }
        return message.substring(0, message.lastIndexOf(","));
    }

    public static List<String> getJudgeRequire() {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)16);
        fieldList.add("name");
        fieldList.add("createorg");
        fieldList.add("number");
        fieldList.add("recrutyp");
        fieldList.add("ctrlstrategy");
        return fieldList;
    }

    public static FieldTip createFieldTip(String tips, String fieldKey) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, fieldKey, tips);
        fieldTip.setDeleteRule(OfferTemplateBizHelper.createDeleteRule(fieldKey));
        return fieldTip;
    }

    public static DeleteRule createDeleteRule(String ... fieldKey) {
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList(fieldKey));
        return deleteRule;
    }

    public static Map<String, String> getFieldNameMappingLocalValue(DynamicObject dataEntity, List<String> fields) {
        HashMap mapping = Maps.newHashMapWithExpectedSize((int)fields.size());
        DataEntityPropertyCollection collection = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : collection) {
            String name = iDataEntityProperty.getName();
            for (String field : fields) {
                if (!name.equals(field)) continue;
                LocaleString displayName = iDataEntityProperty.getDisplayName();
                String localValue = displayName.getLocaleValue();
                mapping.put(field, localValue);
            }
        }
        return mapping;
    }

    public void savePageCache(IPageCache pageCache, Map<String, String> map, Container container) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        StringBuilder cacheLabelKey = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            cacheLabelKey.append(key).append(',');
            String value = entry.getValue();
            LabelAp labelAp = this.dynamicBuildLabel(key, value);
            Map control = labelAp.createControl();
            items.add(control);
        }
        container.addControls((List)items);
        pageCache.put("TSRBD_OFFER_CACHE_CHOICE_FIELD_KEY", cacheLabelKey.toString());
    }

    public void dynamicInsertText(IFormView view, String text) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod("richtexteditorap", "insertText", new Object[]{text});
    }

    public void deletePageCache(Container container, IPageCache pageCache) {
        String cacheKey = pageCache.get("TSRBD_OFFER_CACHE_CHOICE_FIELD_KEY");
        if (HRStringUtils.isNotEmpty((String)cacheKey)) {
            String[] split;
            for (String str : split = cacheKey.split(",")) {
                container.deleteControls(new String[]{str});
            }
        }
        pageCache.remove("TSRBD_OFFER_CACHE_CHOICE_FIELD_KEY");
    }

    public void countrySelect(AfterF7SelectEvent event, IDataModel model) {
        ListSelectedRowCollection collection = event.getListSelectedRowCollection();
        if (collection.isEmpty()) {
            model.setValue("admindivision", null);
        } else {
            DynamicObject dataEntity = model.getDataEntity();
            DynamicObject adminDivision = dataEntity.getDynamicObject("admindivision");
            if (null == adminDivision) {
                return;
            }
            Object primaryKeyValue = collection.get(0).getPrimaryKeyValue();
            if (!OFFER_TEMPLATE_HELPER.judgeAdminBelongCountry(primaryKeyValue, adminDivision)) {
                model.setValue("admindivision", null);
            }
        }
    }

    public void adminDivisionSelect(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject country = dataEntity.getDynamicObject("country");
        if (null == country) {
            DynamicObject adminDivision = dataEntity.getDynamicObject("admindivision");
            DynamicObject newCountry = Optional.ofNullable(adminDivision).map(dy -> OFFER_TEMPLATE_HELPER.getCountryByAdminDivision(adminDivision)).orElse(null);
            model.setValue("country", (Object)newCountry);
        }
    }

    public void batchSetElementNull(IDataModel model, String ... fieldKeys) {
        for (String fieldKey : fieldKeys) {
            model.setValue(fieldKey, null);
        }
    }

    private LabelAp dynamicBuildLabel(String key, String value) {
        LabelAp labelAp = new LabelAp();
        labelAp.setId(key);
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(value));
        labelAp.setParentId("commonfield");
        labelAp.setClickable(true);
        labelAp.setFontSize(14);
        labelAp.setForeColor("#0E5FD8");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("10px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        return labelAp;
    }
}

