/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.helper;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;

public class OfferTemplateHelper {
    private static final Log logger = LogFactory.getLog(OfferTemplateHelper.class);
    private static final String PAGE_BD_ADMINDIVISION = "bd_admindivision";
    public static final String PAGE_BD_COUNTRY = "bd_country";
    private static final String PAGE_BD_ADMINDIVISIONLEVEL = "bd_admindivisionlevel";
    private static final String PAGE_BOS_WATERMARK = "bos_watermark";
    private static final String PAGE_TSRBD_OFFERTEMPLATE = "tsrbd_offertemplate";
    private static final String ROOT_NODE = "rootNode";
    private static final HRBaseServiceHelper OFFER_TMP_HELPER = new HRBaseServiceHelper("tsrbd_offertemplate");
    private static final HRBaseServiceHelper ADMIN_DIVISION_HELPER = new HRBaseServiceHelper("bd_admindivision");
    private static final HRBaseServiceHelper LEVEL_HELPER = new HRBaseServiceHelper("bd_admindivisionlevel");
    private static final HRBaseServiceHelper COUNTRY_HELPER = new HRBaseServiceHelper("bd_country");

    public DynamicObject getOfferTemplate(Object pkId) {
        if (OFFER_TMP_HELPER.isExists(pkId)) {
            return OFFER_TMP_HELPER.loadSingle(pkId);
        }
        return null;
    }

    public boolean judgeSysWatermark(String entryNumber) {
        DynamicObject cloud = this.getBizCloudByNumber();
        String cloudId = cloud.getString("id");
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"tsrbd");
        ImmutableList param = ImmutableList.of((Object)cloudId, (Object)appId, (Object)entryNumber, (Object)ROOT_NODE);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_BOS_WATERMARK);
        QFilter filter = new QFilter("objectid", "in", (Object)param);
        logger.info("OfferTemplateHelper.judgeSysWatermark.filter:[{}]", (Object)filter);
        DynamicObject[] waters = serviceHelper.query("type", new QFilter[]{filter});
        logger.info("OfferTemplateHelper.judgeSysWatermark.waters:[{}]", (Object)SerializationUtils.toJsonString((Object)waters));
        return waters.length == 0;
    }

    public QFilter getLeaveFilter(DynamicObject dynamicObject) {
        DynamicObjectType objectType = dynamicObject.getDynamicObjectType();
        DynamicObjectCollection collection = new DynamicObjectCollection(objectType, null);
        collection.add((Object)dynamicObject);
        List<String> adminDivisionNumberList = this.getAdminDivisionNumberList(collection);
        return new QFilter("basedatafield.number", "in", adminDivisionNumberList);
    }

    public DynamicObject getCountryByAdminDivision(DynamicObject dy) {
        QFilter countryFilter = this.getCountryFilter(dy);
        return COUNTRY_HELPER.loadDynamicObject(countryFilter);
    }

    public QFilter getMoreFilter(Set<String> setKey) {
        DynamicObject[] pool = FieldPoolHelper.getFieldPoolByFieldKey(setKey);
        List list = Arrays.stream(pool).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("fieldpool", "not in", list);
        filter.and(new QFilter("bizfield", "not in", setKey));
        return filter;
    }

    public boolean judgeAdminBelongCountry(Object primaryKeyValue, DynamicObject adminDivision) {
        DynamicObject adCountry = this.getCountryByAdminDivision(adminDivision);
        return primaryKeyValue.equals(adCountry.getLong("id"));
    }

    public boolean isWatermark(Long templateId) {
        DynamicObject offerTemplate = this.getOfferTemplate(templateId);
        if (null == offerTemplate) {
            return false;
        }
        return offerTemplate.getBoolean("iswatermark");
    }

    public WaterMark getWaterMark(String entryNumber) {
        String param;
        DynamicObject cloud = this.getBizCloudByNumber();
        String cloudId = cloud.getString("id");
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"tsrbd");
        ImmutableList querySeq = ImmutableList.of((Object)entryNumber, (Object)appId, (Object)cloudId, (Object)ROOT_NODE);
        DynamicObject sysWaterMark = null;
        Iterator iterator = querySeq.iterator();
        while (iterator.hasNext() && null == (sysWaterMark = this.getSysWaterMark(param = (String)iterator.next()))) {
        }
        return this.getBizWaterMark(sysWaterMark);
    }

    public DynamicObject querySelectPropertiesByFilter(String selectProperties, QFilter[] qFilters) {
        return OFFER_TMP_HELPER.queryOne(selectProperties, qFilters);
    }

    public boolean judgeRecTypWithScene(Long typeId, Long sceneId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recruscene");
        DynamicObject scene = serviceHelper.loadSingle((Object)sceneId);
        DynamicObjectCollection collection = scene.getDynamicObjectCollection("recruitmentcategory");
        Optional<DynamicObject> optional = collection.stream().filter(dy -> dy.getLong("fbasedataid.id") == typeId.longValue()).findFirst();
        return optional.isPresent();
    }

    private WaterMark getBizWaterMark(DynamicObject sysWaterMark) {
        WaterMark waterMark = null;
        if (null != sysWaterMark) {
            waterMark = new WaterMark();
            waterMark.setType(sysWaterMark.getString("type"));
            waterMark.setObjectId(sysWaterMark.getString("objectid"));
            waterMark.setFontSize(sysWaterMark.getString("fontsize"));
            waterMark.setText(sysWaterMark.getString("text"));
            waterMark.setLevel(sysWaterMark.getString("level"));
            waterMark.setColor(sysWaterMark.getString("color"));
            waterMark.setGlobalAlpha(sysWaterMark.getInt("globalalpha"));
            waterMark.setPicture(sysWaterMark.getString("picture"));
        }
        return waterMark;
    }

    private DynamicObject getSysWaterMark(String param) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_BOS_WATERMARK);
        QFilter appFilter = new QFilter("objectid", "=", (Object)param);
        return serviceHelper.loadDynamicObject(appFilter);
    }

    private List<String> getAdminDivisionNumberList(DynamicObjectCollection collection) {
        List<String> countryNumberList = collection.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        DynamicObject[] leaveByCountry = this.getLeaveByCountry(countryNumberList);
        return Arrays.stream(leaveByCountry).map(dy -> dy.getString("number")).collect(Collectors.toList());
    }

    private DynamicObject[] getLeaveByCountry(List<String> numbers) {
        QFilter filter = new QFilter("country.number", "in", numbers);
        return LEVEL_HELPER.query(new QFilter[]{filter});
    }

    private DynamicObject getBizCloudByNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizcloud");
        QFilter filter = new QFilter("number", "=", (Object)"TSC");
        return serviceHelper.loadDynamicObject(filter);
    }

    private QFilter getCountryFilter(DynamicObject dy) {
        DynamicObject adminDivision = ADMIN_DIVISION_HELPER.loadSingle((Object)dy.getLong("id"));
        DynamicObject leaveDy = adminDivision.getDynamicObject("basedatafield");
        DynamicObject dynamicObject = LEVEL_HELPER.loadSingle((Object)leaveDy.getLong("id"));
        return new QFilter("id", "=", (Object)dynamicObject.getDynamicObject("country").getLong("id"));
    }
}

