/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.offer.service.modal.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.CustomMessageParamBo;
import kd.tsc.tsrbd.business.domain.message.MessageCustomCommonService;
import kd.tsc.tsrbd.business.domain.offer.service.helper.FieldPoolHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferFieldsHelper;
import kd.tsc.tsrbd.business.domain.offer.service.helper.OfferTemplateHelper;
import kd.tsc.tsrbd.business.domain.offer.service.modal.AbstractOfferLetterTemplateBizService;
import kd.tsc.tsrbd.business.domain.offer.service.modal.OfferLetterTemplateService;

public class IOfferLetterTemplateService
implements OfferLetterTemplateService {
    private AbstractOfferLetterTemplateBizService bizService;

    public IOfferLetterTemplateService(AbstractOfferLetterTemplateBizService bizService) {
        this.bizService = bizService;
    }

    @Override
    public String previewOfferLetterTemplate(String content, DynamicObject ... dys) {
        Map<String, String> offerTemplateMap = OfferFieldsHelper.getOfferTemplateMap(Arrays.asList(dys));
        if (null != this.bizService) {
            this.bizService.getOfferLetterTemplateParams(offerTemplateMap, dys);
        }
        return OfferFieldsHelper.getTemplateContent(content, offerTemplateMap);
    }

    @Override
    public String previewOfferLetterTemplate(String content, Boolean isShowEmptyFields, DynamicObject ... dys) {
        boolean isHavePeriodTerm;
        Map<String, String> offerTemplateMap = OfferFieldsHelper.getOfferTemplateMap(Arrays.asList(dys));
        this.setExtParam(offerTemplateMap);
        if (null != this.bizService) {
            this.bizService.getOfferLetterTemplateParams(offerTemplateMap, dys);
        }
        if (!(isHavePeriodTerm = Arrays.stream(dys).anyMatch(dy -> null != dy.getDataEntityType().getProperties().get((Object)"ishaveperiodterm") && "1".equals(dy.getString("ishaveperiodterm"))))) {
            offerTemplateMap.put("pperiodterm", "");
            offerTemplateMap.put("pperiodtermunit", "");
            offerTemplateMap.put("prpemonthly", "");
        }
        ArrayList<String> keys = new ArrayList<String>(offerTemplateMap.size());
        for (Map.Entry<String, String> entry : offerTemplateMap.entrySet()) {
            if (!"[]".equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            offerTemplateMap.put(key, "");
        }
        return OfferFieldsHelper.getTemplateContent(content, offerTemplateMap, isShowEmptyFields);
    }

    @Override
    public String previewOfferLetterTemplate(String content, Map<String, String> valueMap, DynamicObject ... dys) {
        Map<String, String> offerTemplateMap = OfferFieldsHelper.getOfferTemplateMap(Arrays.asList(dys));
        this.setExtParam(offerTemplateMap);
        offerTemplateMap.putAll(valueMap);
        if (null != this.bizService) {
            this.bizService.getOfferLetterTemplateParams(offerTemplateMap, dys);
        }
        return OfferFieldsHelper.getTemplateContent(content, offerTemplateMap);
    }

    private void setExtParam(Map<String, String> offerTemplateMap) {
        Map<String, String> tempMap;
        Map<String, String> destMap = tempMap = offerTemplateMap;
        CustomMessageParamBo param = new CustomMessageParamBo(null, (List)Lists.newArrayList((Object[])new Map[]{destMap}), "5");
        MessageCustomCommonService.extMessageCustomParamOnPreview(param);
    }

    @Override
    public String previewOfferLetterTemplate(Object templateId, DynamicObject ... dys) {
        OfferTemplateHelper helper = new OfferTemplateHelper();
        DynamicObject template = helper.getOfferTemplate(templateId);
        if (Objects.isNull(template)) {
            return "";
        }
        String content = template.getString("content_tag");
        if (HRStringUtils.isEmpty((String)content)) {
            return "";
        }
        return this.previewOfferLetterTemplate(content, dys);
    }

    @Override
    public Map<String, String> getOfferLetterTemplateVariables(Object obj) {
        HashMap poolMap = Maps.newHashMapWithExpectedSize((int)16);
        FieldPoolHelper.getFieldKeyMappingName(poolMap, "0");
        if (null != this.bizService) {
            this.bizService.getOtherFieldVariables(poolMap, obj);
        }
        return poolMap;
    }
}

