/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.perm;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.common.constants.perm.PermItemOpRegister;
import kd.tsc.tsrbd.common.entity.perm.OpPermItemEntity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PermItemCommonService {
    private static final Log logger = LogFactory.getLog(PermItemCommonService.class);
    private static PermItemCommonService permItemCommonService = new PermItemCommonService();

    public static PermItemCommonService getInstance() {
        return permItemCommonService;
    }

    public boolean checkPermItemOp(String key, String opKey, IFormView formView) {
        boolean hasOpPerm = true;
        OpPermItemEntity opPermItemEntity = this.getOpPermItem(key, formView);
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return true;
        }
        if (parentView instanceof BaseView) {
            parentView = parentView.getParentView();
        }
        String tip = ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermItemCommonService_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
        String entityId = null;
        Object pkId = null;
        String permission = null;
        String opName = null;
        if (opPermItemEntity != null) {
            Tuple<String, Object> tuple = this.getPermItemEntityId(opPermItemEntity, formView);
            if (tuple == null) {
                return true;
            }
            entityId = (String)tuple.item1;
            pkId = tuple.item2;
            permission = opPermItemEntity.getPermissionId();
            opName = this.getPermName(permission);
            if (StringUtils.isEmpty((CharSequence)opName)) {
                Map opInfo = EntityMetadataCache.getDataEntityOperate((String)((String)this.getEntityId((IFormView)formView).item1), (String)opKey);
                opName = LocaleString.fromMap((Map)((Map)opInfo.get("name"))).getLocaleValue();
            }
        } else {
            Tuple<String, Object> tuple = this.getEntityId(formView);
            entityId = (String)tuple.item1;
            pkId = tuple.item2;
            Map opInfo = EntityMetadataCache.getDataEntityOperate((String)entityId, (String)opKey);
            if (opInfo != null && !opInfo.isEmpty()) {
                permission = (String)opInfo.get("permission");
                opName = LocaleString.fromMap((Map)((Map)opInfo.get("name"))).getLocaleValue();
            }
        }
        if (HRStringUtils.isNotEmpty((String)entityId) && HRStringUtils.isNotEmpty((String)permission) && !(hasOpPerm = PermissionHelper.hasOpPerm(entityId, permission, pkId))) {
            formView.showErrorNotification(String.format(Locale.ROOT, tip, parentView.getFormShowParameter().getCaption(), opName));
        }
        return hasOpPerm;
    }

    public boolean checkPermItemOp(OpPermItemEntity opPermItemEntity, LocaleString name, IFormView formView) {
        boolean hasOpPerm = true;
        if (opPermItemEntity != null) {
            Tuple<String, Object> tuple = this.getPermItemEntityId(opPermItemEntity, formView);
            if (tuple == null) {
                return true;
            }
            hasOpPerm = PermissionHelper.hasOpPerm((String)tuple.item1, opPermItemEntity.getPermissionId(), tuple.item2);
            if (!hasOpPerm) {
                String tip = ResManager.loadKDString((String)"\u60a8\u6682\u65e0%s\u6743\u9650", (String)"PermItemCommonService_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
                formView.showErrorNotification(String.format(Locale.ROOT, tip, name.getLocaleValue()));
            }
        }
        return hasOpPerm;
    }

    public void loadDataHandleViewPerm(IFormView formView) {
        Set<OpPermItemEntity> opPermItemEntities = this.getPermItemOpList(formView);
        if (opPermItemEntities != null && !opPermItemEntities.isEmpty()) {
            HashSet<String> hideKey = new HashSet<String>(opPermItemEntities.size());
            HashMap<String, Boolean> checkedPermMap = new HashMap<String, Boolean>(opPermItemEntities.size());
            for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
                Boolean hasPerm = (Boolean)checkedPermMap.get(opPermItemEntity.getPermissionId());
                if (hasPerm == null) {
                    Tuple<String, Object> tuple = this.getPermItemEntityId(opPermItemEntity, formView);
                    if (tuple == null) {
                        checkedPermMap.put(opPermItemEntity.getPermissionId(), Boolean.TRUE);
                        continue;
                    }
                    hasPerm = PermissionHelper.hasOpPerm((String)tuple.item1, opPermItemEntity.getPermissionId(), tuple.item2);
                    checkedPermMap.put(opPermItemEntity.getPermissionId(), hasPerm);
                }
                if (hasPerm.booleanValue()) continue;
                hideKey.add(opPermItemEntity.getKey());
            }
            if (hideKey.size() == opPermItemEntities.size()) {
                formView.getFormShowParameter().setStatus(OperationStatus.VIEW);
                formView.getFormShowParameter().setCustomParam("perm_check_custom_param", (Object)OperationStatus.VIEW.getValue());
            } else {
                formView.getFormShowParameter().setCustomParam("perm_check_custom_param", (Object)-1);
            }
            formView.getPageCache().put("perm_checked_map", JSON.toJSONString(checkedPermMap));
        }
    }

    public void afterBindDataHandleViewPerm(IFormView formView) {
        String permCheckedStr = formView.getPageCache().get("perm_checked_map");
        if (HRStringUtils.isEmpty((String)permCheckedStr)) {
            return;
        }
        Map checkedPermMap = (Map)JSON.parseObject((String)permCheckedStr, Map.class);
        Set<OpPermItemEntity> opPermItemEntities = this.getPermItemOpList(formView);
        if (opPermItemEntities != null && !opPermItemEntities.isEmpty()) {
            HashSet<String> hideKey = new HashSet<String>(opPermItemEntities.size());
            for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
                Boolean hasPerm = (Boolean)checkedPermMap.get(opPermItemEntity.getPermissionId());
                if (hasPerm.booleanValue()) continue;
                if (HRStringUtils.isNotEmpty((String)opPermItemEntity.getParentKey())) {
                    this.hideEntryEntityControl(opPermItemEntity, formView);
                    continue;
                }
                hideKey.add(opPermItemEntity.getKey());
            }
            if (hideKey.size() > 0) {
                formView.setVisible(Boolean.FALSE, hideKey.toArray(new String[hideKey.size()]));
            }
        }
        if ("tssrm_assessment".equals(formView.getEntityId())) {
            this.handleComboEdit(formView, checkedPermMap);
        }
        formView.getPageCache().remove("perm_checked_map");
    }

    private void handleComboEdit(IFormView formView, Map<String, Boolean> checkedPermMap) {
        Set<OpPermItemEntity> opPermItemEntities = PermItemCommonService.getInstance().getPermItemPropChangeOpList(formView);
        if (opPermItemEntities != null && !opPermItemEntities.isEmpty()) {
            ArrayList comboItems = Lists.newArrayList();
            ComboEdit comboEdit = (ComboEdit)formView.getControl("combofield");
            ComboProp comboProp = (ComboProp)comboEdit.getProperty();
            List valueMapItems = comboProp.getComboItems();
            block0: for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
                Boolean hasOpPerm = checkedPermMap.get(opPermItemEntity.getPermissionId());
                if (hasOpPerm == null) {
                    Tuple<String, Object> tuple = this.getPermItemEntityId(opPermItemEntity, formView);
                    if (tuple == null) continue;
                    hasOpPerm = PermissionHelper.hasOpPerm((String)tuple.item1, opPermItemEntity.getPermissionId(), tuple.item2);
                    checkedPermMap.put(opPermItemEntity.getPermissionId(), hasOpPerm);
                }
                if (!hasOpPerm.booleanValue()) continue;
                for (ValueMapItem valueMapItem : valueMapItems) {
                    if (!valueMapItem.getValue().equals(opPermItemEntity.getKey())) continue;
                    comboItems.add(new ComboItem(valueMapItem.getName(), valueMapItem.getValue()));
                    continue block0;
                }
            }
            if (comboItems.isEmpty()) {
                DynamicObject[] dynamicObjects;
                CardEntry cardEntry = (CardEntry)formView.getControl(comboEdit.getEntryControlKey());
                if (cardEntry != null && (dynamicObjects = cardEntry.getEntryData().getDataEntitys()).length > 0) {
                    for (int len = 0; len < dynamicObjects.length; ++len) {
                        cardEntry.setChildVisible(false, len, new String[]{"combofield"});
                    }
                }
            } else {
                comboEdit.setComboItems((List)comboItems);
            }
        }
    }

    private String getCustomeStyle(String key) {
        String customerStyle = String.format(Locale.ROOT, "{\"type\":0,\"content\":\"$ [id='%s']{\\n\\t display:none;\\n}\"}", key);
        return new String(Base64.getEncoder().encode(customerStyle.getBytes()));
    }

    private void hideEntryEntityControl(OpPermItemEntity opPermItemEntity, IFormView formView) {
        if (formView instanceof IListView) {
            String customerStyle = this.getCustomeStyle(opPermItemEntity.getKey());
            formView.updateControlMetadata(opPermItemEntity.getParentKey(), (Map)ImmutableMap.of((Object)"cstyles", (Object)customerStyle));
        } else {
            CardEntry cardEntry = (CardEntry)formView.getControl(opPermItemEntity.getParentKey());
            if (cardEntry != null) {
                DynamicObject[] dynamicObjects = cardEntry.getEntryData().getDataEntitys();
                for (int index = 0; index < dynamicObjects.length; ++index) {
                    cardEntry.setChildVisible(false, index, new String[]{opPermItemEntity.getKey()});
                }
            }
        }
    }

    public OpPermItemEntity getOpPermItem(String key, IFormView formView) {
        OpPermItemEntity selectedOpPermItemEntity = null;
        Set<OpPermItemEntity> opPermItemEntities = this.getPermItemOpList(formView);
        if (opPermItemEntities != null && !opPermItemEntities.isEmpty()) {
            for (OpPermItemEntity opPermItemEntity : opPermItemEntities) {
                if (!HRStringUtils.equals((String)opPermItemEntity.getKey(), (String)key)) continue;
                selectedOpPermItemEntity = opPermItemEntity;
                break;
            }
        }
        return selectedOpPermItemEntity;
    }

    public Set<OpPermItemEntity> getPermItemOpList(IFormView formView) {
        String key = this.getRegisterKey(formView);
        Set opPermItemEntities = PermItemOpRegister.getPermItemOp((String)key);
        return opPermItemEntities == null ? new HashSet(0) : opPermItemEntities;
    }

    public Set<OpPermItemEntity> getPermItemPropChangeOpList(IFormView formView) {
        String key = this.getRegisterKey(formView);
        Set opPermItemEntities = PermItemOpRegister.getPermItemPropChangeOpList((String)key);
        return opPermItemEntities == null ? new HashSet(0) : opPermItemEntities;
    }

    public Set<String> getPermItemOpToolBarSet(IFormView formView) {
        String key = this.getRegisterKey(formView);
        Set opToolBarSet = PermItemOpRegister.getPermItemOpToolBar((String)key);
        return opToolBarSet == null ? new HashSet(0) : opToolBarSet;
    }

    public Tuple<String, Object> getPermItemEntityId(OpPermItemEntity opPermItemEntity, IFormView formView) {
        try {
            Tuple<String, Object> tuple;
            Set permEntityId = opPermItemEntity.getPermEntityId();
            IFormView fv = formView;
            for (int level = 0; level < 5; ++level) {
                tuple = this.getEntityId(fv);
                if (permEntityId.contains(tuple.item1)) break;
                fv = fv.getParentView();
            }
            tuple = this.getEntityId(fv);
            if (!permEntityId.contains(tuple.item1)) {
                return null;
            }
            return tuple;
        }
        catch (Exception ex) {
            logger.error("getPermItemEntityId:get perm entityid error:{0}", (Throwable)ex);
            return null;
        }
    }

    private Tuple<String, Object> getEntityId(IFormView formView) {
        String entityId;
        Object pkId = null;
        if (formView instanceof IListView) {
            entityId = ((IListView)formView).getBillFormId();
        } else {
            entityId = formView.getEntityId();
            pkId = this.getMainFormPkId(formView);
        }
        return new Tuple((Object)entityId, pkId);
    }

    private Object getMainFormPkId(IFormView formView) {
        Object pkId = null;
        try {
            if (formView.getFormShowParameter() instanceof BillShowParameter && formView.getModel().isDataLoaded()) {
                pkId = formView.getModel().getDataEntity().getPkValue();
            }
        }
        catch (Exception ex) {
            logger.error("getMainFormPkId:get perm getMainFormPkId error:{0}", (Throwable)ex);
        }
        return pkId;
    }

    private String getRegisterKey(IFormView formView) {
        String key;
        if (formView instanceof IListView) {
            key = ((IListView)formView).getBillFormId();
            key = key + "_list";
        } else {
            key = formView.getEntityId();
        }
        return key;
    }

    private String getPermName(String fPermId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("perm_permitem");
        DynamicObject perm = hrBaseServiceHelper.loadSingle((Object)fPermId);
        return ObjectUtils.isEmpty((Object)perm) ? "" : perm.getString("name");
    }
}

