/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.perm;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class PermissionHelper {
    public static boolean checkPermission(Long userId, String appId, String entityNum, String permItemId) {
        return PermissionHelper.checkPermission(userId, appId, entityNum, permItemId, "createorg");
    }

    public static boolean checkPermission(Long userId, String appId, String entityNum, String permItemId, String orgFieldKey) {
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (isSuperUser) {
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionHelper.getAllPermOrgResult(userId, appId, entityNum, permItemId, orgFieldKey);
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return true;
        }
        return !hasPermOrgResult.getHasPermOrgs().isEmpty();
    }

    public static List<Long> getCurrentAllPermOrgList(String appId, String entityNum) {
        return PermissionHelper.getAllPermOrgList(TSCRequestContext.getUserId(), appId, entityNum, "47150e89000000ac", "createorg");
    }

    public static HasPermOrgResult getCurrentAllPermOrgResult(String appId, String entityNum) {
        return PermissionHelper.getAllPermOrgResult(TSCRequestContext.getUserId(), appId, entityNum, "47150e89000000ac", "createorg");
    }

    public static List<Long> getAllPermOrgList(Long userId, String appId, String entityNum) {
        return PermissionHelper.getAllPermOrgList(userId, appId, entityNum, "47150e89000000ac", "createorg");
    }

    public static HasPermOrgResult getAllPermOrgResult(Long userId, String appId, String entityNum) {
        return PermissionHelper.getAllPermOrgResult(userId, appId, entityNum, "47150e89000000ac", "createorg");
    }

    public static List<Long> getAllPermOrgList(Long userId, String appId, String entityNum, String permItemId) {
        return PermissionHelper.getAllPermOrgList(userId, appId, entityNum, permItemId, "createorg");
    }

    public static HasPermOrgResult getAllPermOrgResult(Long userId, String appId, String entityNum, String permItemId) {
        return PermissionHelper.getAllPermOrgResult(userId, appId, entityNum, permItemId, "createorg");
    }

    public static List<Long> getAllPermOrgList(Long userId, String appId, String entityNum, String permItemId, String orgFieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)orgFieldKey);
        HasPermOrgResult allPermOrgs = PermissionHelper.getAllPermOrgs(userId, orgViewType, appId, entityNum, permItemId, orgFieldKey);
        return allPermOrgs.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)orgViewType) : allPermOrgs.getHasPermOrgs();
    }

    public static HasPermOrgResult getAllPermOrgResult(Long userId, String appId, String entityNum, String permItemId, String orgFieldKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)dataEntityType, (String)orgFieldKey);
        return PermissionHelper.getAllPermOrgs(userId, orgViewType, appId, entityNum, permItemId, orgFieldKey);
    }

    public static HasPermOrgResult getAllPermOrgs(Long userId, String orgViewType, String appId, String entityNum, String permItemId, String orgFieldKey) {
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static boolean hasOpPerm(String formId, String permItemId, Object pkId) {
        long userId = RequestContext.get().getCurrUserId();
        String bizAppNumber = FormMetadataCache.getFormConfig((String)formId).getAppId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (String)bizAppNumber, (String)formId, (String)permItemId);
        if (hasPerm && pkId != null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
            hasPerm = PermissionServiceHelper.matchDataRule((long)userId, (String)bizAppNumber, (String)formId, (String)permItemId, (QFilter[])qfilters);
        }
        return hasPerm;
    }

    public static boolean hasFunctionPerm(String formId, String permItemId) {
        long userId = RequestContext.get().getCurrUserId();
        String bizAppNumber = FormMetadataCache.getFormConfig((String)formId).getAppId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)bizAppNumber, (String)formId, (String)permItemId);
    }
}

