/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.helper;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigModalHelper;

public class ProcessConfigBizHelper {
    public static Map<Long, List<DynamicObject>> getRecTypeOperateConfig(List<Long> stgTypIds, Object recrutypid) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] config = ProcessConfigModalHelper.getRecTypeOperateConfig(stgTypIds);
        if (config.length == 0) {
            return resultMap;
        }
        if (null != recrutypid) {
            if (recrutypid instanceof Integer) {
                recrutypid = ((Integer)recrutypid).longValue();
            }
            ArrayList newList = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject dyn : config) {
                long id = dyn.getDynamicObject("operate").getLong("recrutyp.id");
                if (!recrutypid.equals(id)) continue;
                newList.add(dyn);
            }
            for (DynamicObject dy : newList) {
                long stageTypeId = dy.getLong("recrustgtyp");
                List list = resultMap.getOrDefault(stageTypeId, Lists.newArrayListWithCapacity((int)newList.size()));
                list.add(dy);
                resultMap.put(stageTypeId, list);
            }
        } else {
            for (DynamicObject dy : config) {
                long stageTypeId = dy.getLong("recrustgtyp");
                List list = resultMap.getOrDefault(stageTypeId, Lists.newArrayListWithCapacity((int)config.length));
                list.add(dy);
                resultMap.put(stageTypeId, list);
            }
        }
        return resultMap;
    }

    public static Map<Long, List<DynamicObject>> getRecTypeFieldConfig(List<Long> stgTypIds, Object recrutypid) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] config = ProcessConfigModalHelper.getRecTypeFieldConfig(stgTypIds);
        if (config.length == 0) {
            return resultMap;
        }
        if (null != recrutypid) {
            if (recrutypid instanceof Integer) {
                recrutypid = ((Integer)recrutypid).longValue();
            }
            ArrayList newList = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject dyn : config) {
                Long id;
                DynamicObject recrutyp;
                DynamicObject field;
                if (null == dyn || null == (field = dyn.getDynamicObject("field")) || null == (recrutyp = field.getDynamicObject("recrutyp")) || !recrutypid.equals(id = Long.valueOf(recrutyp.getLong("id")))) continue;
                newList.add(dyn);
            }
            for (DynamicObject dy : newList) {
                long stageTypeId = dy.getLong("recrustgtyp");
                List list = resultMap.getOrDefault(stageTypeId, Lists.newArrayListWithCapacity((int)newList.size()));
                list.add(dy);
                resultMap.put(stageTypeId, list);
            }
        } else {
            for (DynamicObject dy : config) {
                long stageTypeId = dy.getLong("recrustgtyp");
                List list = resultMap.getOrDefault(stageTypeId, Lists.newArrayListWithCapacity((int)config.length));
                list.add(dy);
                resultMap.put(stageTypeId, list);
            }
        }
        return resultMap;
    }

    public static List<Long> getRqmtstgByProcId(Long id) {
        DynamicObject process = ProcessConfigBizHelper.getProcInfoById(id, "entryentity, entryentity.rqmtstg");
        DynamicObjectCollection entryentity = process.getDynamicObjectCollection("entryentity");
        return entryentity.stream().map(dy -> dy.getLong("rqmtstg.id")).collect(Collectors.toList());
    }

    public static DynamicObject getProcInfoById(Long id, String properties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        return serviceHelper.queryOne(properties, new QFilter("id", "=", (Object)id));
    }

    public static Map<Long, List<DynamicObject>> getStageOperateConfig(Long processId, List<Long> stageIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] config = ProcessConfigModalHelper.getStageOperateConfig(processId, stageIds);
        if (config.length == 0) {
            return resultMap;
        }
        for (DynamicObject dy : config) {
            long stageId = dy.getLong("recrustg");
            List list = resultMap.getOrDefault(stageId, new ArrayList(16));
            list.add(dy);
            resultMap.put(stageId, list);
        }
        return resultMap;
    }

    public static Map<Long, List<DynamicObject>> getStageFieldConfig(Long processId, List<Long> stageIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        List<DynamicObject> config = ProcessConfigModalHelper.getStageFieldConfig(processId, stageIds);
        if (config.size() == 0) {
            return resultMap;
        }
        for (DynamicObject dy : config) {
            long stageId = dy.getLong("recrustg");
            List list = resultMap.getOrDefault(stageId, new ArrayList(16));
            list.add(dy);
            resultMap.put(stageId, list);
        }
        return resultMap;
    }

    public static boolean viewDoClose(IFormView view, ConfirmCallBackListener listener) {
        boolean ifNoChanged;
        OperationStatus status = view.getFormShowParameter().getStatus();
        String processPageId = view.getPageCache().get("cache_process_page_id");
        IFormView processFormView = SessionManager.getCurrent().getView(processPageId);
        JSONArray array = JSONArray.parseArray((String)view.getPageCache().get("PAGE_OP_CHANGE_DATA_KEY"));
        boolean bl = ifNoChanged = !(array != null && !array.isEmpty() || processFormView != null && processFormView.getModel().getDataChanged());
        if (ifNoChanged || status.name().equals(OperationStatus.VIEW.name())) {
            view.close();
        } else {
            String message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
            view.showConfirm(message, MessageBoxOptions.OKCancel, listener);
        }
        return !ifNoChanged;
    }

    private ProcessConfigBizHelper() {
    }
}

