/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;

public class ProcessConfigModalHelper {
    public static void saveOperateConfig(List<Map<String, Object>> result, Long processId) {
        QFilter qFilter = new QFilter("rqmtproc", "=", (Object)processId);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        helper.deleteByFilter(new QFilter[]{qFilter});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tsrbd_opercfgresult");
        ArrayList saveList = Lists.newArrayListWithExpectedSize((int)result.size());
        Set<String> ignoreKeys = ProcessServiceHelper.getIgnoreKeys();
        for (Map<String, Object> map : result) {
            DynamicObject operateConfigDy = new DynamicObject((DynamicObjectType)entityType);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (ignoreKeys.contains(key)) continue;
                operateConfigDy.set(key, value);
            }
            operateConfigDy.set("rqmtproc", (Object)processId);
            saveList.add(operateConfigDy);
        }
        helper.save(saveList.toArray(new DynamicObject[0]));
    }

    public static void saveFieldConfig(List<Map<String, Object>> result, Long processId) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        QFilter qFilter = new QFilter("rqmtproc", "=", (Object)processId);
        helper.deleteByFilter(new QFilter[]{qFilter});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tsrbd_fieldcfgresult");
        ArrayList saveList = Lists.newArrayListWithExpectedSize((int)result.size());
        Set<String> ignoreKeys = ProcessServiceHelper.getIgnoreKeys();
        for (Map<String, Object> map : result) {
            DynamicObject operateConfigDy = new DynamicObject((DynamicObjectType)entityType);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (ignoreKeys.contains(key)) continue;
                operateConfigDy.set(key, value);
            }
            operateConfigDy.set("rqmtproc", (Object)processId);
            saveList.add(operateConfigDy);
        }
        helper.save(saveList.toArray(new DynamicObject[0]));
    }

    public static DynamicObject[] getRecTypeOperateConfig(List<Long> stgTypIds) {
        QFilter filter = new QFilter("configentry", "=", (Object)"tsrbd_recrustgtyp");
        Optional.ofNullable(stgTypIds).ifPresent(idList -> filter.and(new QFilter("recrustgtyp", "in", idList)));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        return helper.query("configentry, operate, recrustgtyp, rqmtproc, recrustg, islistdisplay", new QFilter[]{filter}, "operate");
    }

    public static DynamicObject[] getRecTypeFieldConfig(List<Long> stgTypIds) {
        QFilter filter = new QFilter("rqmtproc", "=", (Object)0L);
        Optional.ofNullable(stgTypIds).ifPresent(idList -> filter.and(new QFilter("recrustgtyp", "in", idList)));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        return helper.query("configentry, field, recrustgtyp, rqmtproc, recrustg, isdisplay", new QFilter[]{filter}, "field");
    }

    public static DynamicObject[] getStageOperateConfig(Long processId, List<Long> stageIds) {
        QFilter filter = new QFilter("rqmtproc", "=", (Object)processId);
        Optional.ofNullable(stageIds).ifPresent(idList -> filter.and(new QFilter("recrustg", "in", idList)));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static List<DynamicObject> getStageFieldConfig(Long processId, List<Long> stageIds) {
        QFilter filter = new QFilter("rqmtproc", "=", (Object)processId);
        Optional.ofNullable(stageIds).ifPresent(idList -> filter.and(new QFilter("recrustg", "in", idList)));
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        DynamicObject[] objects = helper.loadDynamicObjectArray(new QFilter[]{filter});
        return Arrays.stream(objects).sorted(Comparator.comparing(dy -> dy.getLong("id"))).collect(Collectors.toList());
    }

    public static void deleteProcessConfig(Long processId) {
        QFilter filter = new QFilter("rqmtproc", "=", (Object)processId);
        HRBaseServiceHelper opHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        opHelper.deleteByFilter(new QFilter[]{filter});
        HRBaseServiceHelper fieldHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        fieldHelper.deleteByFilter(new QFilter[]{filter});
    }

    public static DynamicObject[] getOperateConfig(Long processId, Long stageId, Long recruId) {
        QFilter filter;
        if (stageId == 0L) {
            filter = new QFilter("rqmtproc", "=", (Object)0L);
            filter.and("recrustgtyp", "=", (Object)0L);
            if (recruId == 1030L) {
                filter.and("operate", ">", (Object)20000L);
            } else {
                filter.and("operate", "<", (Object)20000L);
            }
        } else {
            filter = new QFilter("rqmtproc", "=", (Object)processId);
            filter.and(new QFilter("recrustg", "=", (Object)stageId));
        }
        String selectProperties = "operate.ctrlkey,recrustgtyp,rqmtproc,recrustg,islistdisplay";
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        return helper.queryOriginalArray(selectProperties, new QFilter[]{filter});
    }

    public static DynamicObject[] getFieldConfig(Long processId, Long stageId, Long recruId) {
        QFilter filter;
        if (stageId == 0L) {
            filter = new QFilter("rqmtproc", "=", (Object)0L);
            filter.and("recrustgtyp", "=", (Object)0L);
            if (recruId == 1030L) {
                filter.and("field", ">", (Object)20000L);
            } else {
                filter.and("field", "<", (Object)20000L);
            }
        } else {
            filter = new QFilter("configentry", "=", (Object)"tsrbd_recrustgnew");
            filter.and("rqmtproc", "=", (Object)processId);
            filter.and("recrustg", "=", (Object)stageId);
        }
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        String selectProperties = "recrustgtyp,rqmtproc,recrustg,field.ctrlkey,isdisplay";
        return helper.queryOriginalArray(selectProperties, new QFilter[]{filter});
    }
}

