/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.id.ID;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class ProcessServiceHelper {
    private static final String TSRBD_RQMTPROCSUBENT = "T_TSRBD_RQMTPROCSUBENT";
    private static final String TSRBD_RQMTPROCENTITY = "T_TSRBD_RQMTPROCENTITY";

    private ProcessServiceHelper() {
    }

    public static DynamicObject getProcessById(Object processId) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_rqmtproc");
        return serviceHelper.loadSingle(processId);
    }

    public static DynamicObject getProcessById(String selectProperties, Object processId) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_rqmtproc");
        return serviceHelper.queryOne(selectProperties, processId);
    }

    public static void saveProcess(DynamicObject process) {
        process.set("issyspreset", (Object)"0");
        Long typeId = process.getDynamicObject("group").getLong("id");
        DynamicObject oldDefaultProcess = ProcessServiceHelper.getOldDefaultProcess(process.getLong("id"), typeId);
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_rqmtproc");
        if (null == oldDefaultProcess) {
            process.set("isdefault", (Object)Boolean.TRUE);
        } else if (process.getBoolean("isdefault")) {
            oldDefaultProcess.set("isdefault", (Object)Boolean.FALSE);
        }
        Optional.ofNullable(oldDefaultProcess).ifPresent(oldProcess -> serviceHelper.updateOne(oldDefaultProcess));
    }

    private static DynamicObject getOldDefaultProcess(Long processId, Long typeId) {
        QFilter difFilter = new QFilter("isdefault", "=", (Object)"1");
        QFilter typeFilter = new QFilter("group", "=", (Object)typeId);
        QFilter filter = new QFilter("id", "!=", (Object)processId);
        QFilter[] filters = new QFilter[]{difFilter, typeFilter, filter};
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_rqmtproc");
        return serviceHelper.loadDynamicObject(filters);
    }

    public static String judgeProcessIsDefault(DynamicObject dy) {
        String name = dy.getString("name");
        String number = dy.getString("number");
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_rqmtproc");
        long processId = dy.getLong("id");
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        numFilter.and("id", "!=", (Object)processId);
        if (serviceHelper.isExists(numFilter)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (String)"ProcessServiceHelper_2", (String)"tsc-tsrbd-bussiness", (Object[])new Object[0]);
        }
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        nameFilter.and("id", "!=", (Object)processId);
        if (serviceHelper.isExists(nameFilter)) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", (String)"ProcessServiceHelper_3", (String)"tsc-tsrbd-bussiness", (Object[])new Object[0]);
        }
        boolean isDefault = dy.getBoolean("isdefault");
        String message = "";
        if (isDefault) {
            DynamicObject type = dy.getDynamicObject("group");
            long typeId = type.getLong("id");
            if (1020L == typeId) {
                message = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9ed8\u8ba4\u6d41\u7a0b", (String)"ProcessSaveOp_01", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]);
            }
            if (1030L == typeId) {
                message = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9ed8\u8ba4\u6d41\u7a0b", (String)"ProcessSaveOp_01", (String)"tsc-tsrbd-opplugin", (Object[])new Object[0]);
            }
        }
        return message;
    }

    public static void setStateReason(List<Long> states) {
        String updateSql = "UPDATE T_TSRBD_RQMTPROCSUBENT SET FISREASON = 0 WHERE FJOBSTATUS = ?";
        ArrayList list = Lists.newArrayListWithCapacity((int)states.size());
        for (Long state : states) {
            Object[] param = new Object[]{state};
            list.add(param);
        }
        DBRoute dbRoute = new DBRoute("tsc");
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)"UPDATE T_TSRBD_RQMTPROCSUBENT SET FISREASON = 0 WHERE FJOBSTATUS = ?", (List)list);
    }

    public static void updateProcessStageStatus(Long stageId, List<Long> statusIds) {
        Optional.ofNullable(statusIds).ifPresent(status -> {
            DBRoute dbRoute = new DBRoute("tsc");
            List query = (List)HRDBUtil.query((DBRoute)dbRoute, (String)ProcessServiceHelper.getSelectStatesSql(), (Object[])new Object[]{stageId}, ProcessServiceHelper::putValueToListMap);
            if (!query.isEmpty()) {
                List<Object[]> objectParams = ProcessServiceHelper.getObjectParams(query, statusIds);
                ProcessServiceHelper.insertSubEntity(objectParams);
            }
        });
    }

    public static DynamicObjectCollection getStageStatus(DynamicObject stageDy) {
        String number = stageDy.getString("number");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_recrustgnew");
        DynamicObject recruit = serviceHelper.loadDynamicObject(numberFilter);
        return recruit.getDynamicObjectCollection("statselnewentry");
    }

    public static Set<String> getRefStageMessage(DynamicObject[] hadRefStages) {
        String commonMsg = ResManager.loadKDString((String)"\u8be5\u73af\u8282\u5df2\u88ab\u4f7f\u7528\u6216\u6b63\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u79fb\u9664\u3002", (String)"ProcessServiceHelper_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
        HashMap stageMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : hadRefStages) {
            stageMap.putIfAbsent(dy.getLong("recrustg.id"), dy.getString("recrustg.name"));
        }
        return stageMap.entrySet().stream().map(entryt -> (String)entryt.getValue() + commonMsg).collect(Collectors.toSet());
    }

    public static String getOfferMessage() {
        return ResManager.loadKDString((String)"offer\u4e3a\u9ed8\u8ba4\u73af\u8282,\u4e0d\u80fd\u79fb\u9664", (String)"ProcessServiceHelper_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
    }

    public static Set<String> getIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("id");
        ignoreKeys.add("number");
        ignoreKeys.add("name");
        ignoreKeys.add("createtime");
        ignoreKeys.add("modifytime");
        ignoreKeys.add("createorg");
        ignoreKeys.add("description");
        ignoreKeys.add("isdefault");
        return ignoreKeys;
    }

    public static void buildSelectedSubEntity(IDataModel entryOperate) {
        DynamicObjectCollection dys = entryOperate.getEntryEntity("entryentity");
        for (int i = 0; i < dys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dys.get(i);
            if (dynamicObject == null) continue;
            DynamicObject stage = dynamicObject.getDynamicObject("rqmtstg");
            int finalI = i;
            Optional.ofNullable(stage).ifPresent(stageDy -> {
                DynamicObjectCollection stageStatus = ProcessServiceHelper.getStageStatus(stage);
                if (!CollectionUtils.isEmpty((Collection)stageStatus)) {
                    entryOperate.setEntryCurrentRowIndex("entryentity", finalI);
                    entryOperate.deleteEntryData("subentryentity");
                    ProcessServiceHelper.addStageStatus(stageStatus, entryOperate);
                }
            });
        }
    }

    private static void addStageStatus(DynamicObjectCollection stageStatus, IDataModel entryOperate) {
        entryOperate.deleteEntryData("subentryentity");
        entryOperate.batchCreateNewEntryRow("subentryentity", stageStatus.size());
        for (int i = 0; i < stageStatus.size(); ++i) {
            DynamicObject dy = (DynamicObject)stageStatus.get(i);
            DynamicObject status = (DynamicObject)dy.get("stat");
            entryOperate.setValue("jobstatus", (Object)status, i);
            ProcessServiceHelper.setOverAndReason(entryOperate, i);
        }
    }

    private static void setOverAndReason(IDataModel entryOperate, int value) {
        entryOperate.setValue("isover", (Object)"false", value);
        entryOperate.setValue("isreason", (Object)"false", value);
    }

    public static void editSubnetLabel(Label label, String stageName, String stageNumber, int rowIndex) {
        String textFormat = ResManager.loadKDString((String)"\u73af\u8282%1$s\uff1a%2$s %3$s\u5305\u542b\u7684\u62db\u8058\u72b6\u6001", (String)"ProcessServiceHelper_4", (String)"tsc-tsrbd-bussiness", (Object[])new Object[0]);
        String labelName = rowIndex < 0 ? "" : String.format(textFormat, rowIndex + 1, stageName, stageNumber);
        label.setText(labelName);
    }

    public static void addFilter(ListShowParameter stageParameter, List<String> list, CloseCallBack closeCallBack, long filterId) {
        ListFilterParameter parameter = stageParameter.getListFilterParameter();
        if (!CollectionUtils.isEmpty(list)) {
            QFilter numFilter = new QFilter("number", "not in", list);
            parameter.setFilter(numFilter);
        }
        QFilter disFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recrustgtyp");
        DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(new QFilter[0]);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject object : objects) {
            DynamicObjectCollection recrutyp = object.getDynamicObjectCollection("recrutyp");
            for (DynamicObject dynamicObject : recrutyp) {
                if (dynamicObject.getDynamicObject("fbasedataid").getLong("id") != filterId) continue;
                ids.add(object.getLong("id"));
            }
        }
        disFilter.and(new QFilter("group.id", "in", ids));
        Map baseDataStatus = HRBaseDataConfigUtil.getStatus((String)"tsrbd_recrustgnew");
        boolean isOpenAuditcheck = Boolean.parseBoolean(baseDataStatus.get("auditcheck").toString());
        if (isOpenAuditcheck) {
            disFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        parameter.setFilter(disFilter);
        stageParameter.setCloseCallBack(closeCallBack);
    }

    public static QFilter getSceneFilter(long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_recruscene");
        DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(new QFilter[0]);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject object : objects) {
            DynamicObjectCollection recrutyp = object.getDynamicObjectCollection("recruitmentcategory");
            for (DynamicObject dynamicObject : recrutyp) {
                if (dynamicObject.getDynamicObject("fbasedataid").getLong("id") != id) continue;
                ids.add(object.getLong("id"));
            }
        }
        return new QFilter("id", "in", ids);
    }

    public static void setSelectTable(EntryGrid entryGrid, int size) {
        entryGrid.selectRows(size);
    }

    private static List<Object[]> getObjectParams(List<Map<String, Object>> paramMap, List<Long> statusIds) {
        int subIdsLength = paramMap.size() * statusIds.size();
        ArrayList statusList = Lists.newArrayListWithCapacity((int)subIdsLength);
        for (Map<String, Object> state : paramMap) {
            List<Object[]> list = ProcessServiceHelper.getSubEntityParams(statusIds, state);
            statusList.addAll(list);
        }
        return statusList;
    }

    private static List<Object[]> getSubEntityParams(List<Long> statusIds, Map<String, Object> stage) {
        ArrayList statusList = Lists.newArrayListWithCapacity((int)statusIds.size());
        long[] ids = ID.genLongIds((int)statusIds.size());
        int seq = (Integer)stage.get("seq");
        int index = 0;
        for (Long statusId : statusIds) {
            Object[] stageStatus = new Object[]{stage.get("entry"), ids[index], ++seq, Boolean.FALSE, Boolean.FALSE, statusId};
            statusList.add(stageStatus);
            ++index;
        }
        return statusList;
    }

    private static String getSelectStatesSql() {
        return "SELECT SUBENTITY.FENTRYID AS \"ENTRY\" , MAX(SUBENTITY.FSEQ) AS \"SEQ\" FROM T_TSRBD_RQMTPROCENTITY ENTITY INNER JOIN T_TSRBD_RQMTPROCSUBENT SUBENTITY ON ENTITY.FENTRYID = SUBENTITY.FENTRYID WHERE ENTITY.FRQMTSTGID = ? GROUP BY SUBENTITY.FENTRYID ";
    }

    private static void insertSubEntity(List<Object[]> list) {
        String sql = "INSERT INTO T_TSRBD_RQMTPROCSUBENT (FENTRYID,FDETAILID,FSEQ,FISOVER,FISREASON,FJOBSTATUS) VALUES (?,?,?,?,?,?)";
        DBRoute dbRoute = new DBRoute("tsc");
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)sql, list);
    }

    private static List<Map<String, Object>> putValueToListMap(ResultSet rs) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        while (rs.next()) {
            HashMap one = Maps.newHashMapWithExpectedSize((int)2);
            one.put("entry", rs.getLong("entry"));
            one.put("seq", rs.getInt("seq"));
            result.add(one);
        }
        return result;
    }

    public static List<DynamicObject> getFilterRecrustgtyp(long id) {
        DynamicObject[] dys;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_recrustgtyp");
        for (DynamicObject dy : dys = serviceHelper.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection recrutyp = dy.getDynamicObjectCollection("recrutyp");
            for (DynamicObject dyn : recrutyp) {
                if (dyn.getDynamicObject("fbasedataid").getLong("id") != id) continue;
                list.add(dy);
            }
        }
        return list;
    }

    public static boolean judgeRecrutyp(IFormView view) {
        Object customParam = view.getModel().getValue("group");
        return null == customParam || ((DynamicObject)customParam).getString("id").equals("1030");
    }

    public static Long getAppIdByProcId(Long procId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject process = helper.loadDynamicObject(new QFilter("id", "=", (Object)procId));
        return process.getDynamicObject("applicableapp").getLong("id");
    }

    public static DynamicObject[] getProcessByStageId(Long stageId) {
        QFilter qFilter = new QFilter("entryentity.rqmtstg.id", "=", (Object)stageId);
        HRBaseServiceHelper stageHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject[] query = stageHelper.queryOriginalArray("entryentity.id", qFilter.toArray());
        List collect = Arrays.stream(query).map(stage -> stage.getLong("entryentity.id")).collect(Collectors.toList());
        QFilter qFilter2 = new QFilter("stage", "in", collect);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_rqmtprocsubent");
        return helper.query("id,stage,stat", qFilter2.toArray());
    }

    public static void delStat(List<Long> needRemoveStatList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_rqmtprocsubent");
        helper.delete(needRemoveStatList.toArray());
    }

    public static boolean hasModifyPermission() {
        if (PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return true;
        }
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"tsrbd", (String)"tsrbd_protempconfig", (String)"4715a0df000000ac");
    }
}

