/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.service.cfg;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;

public abstract class AbstractProcessConfigService
implements ProcessConfigService {
    protected ProcessConfigTypeService configTypeService;

    @Override
    public void setProcessConfigTypeService(ProcessConfigTypeService configTypeService) {
        this.configTypeService = configTypeService;
    }

    @Override
    public void listBoxClick(IFormView view) {
        this.configTypeService.initData(view);
    }

    @Override
    public boolean saveProcessConfigResult(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection collection = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        List<Long> idList = collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        try (TXHandle tx = TX.required();){
            this.saveOperateResult(idList, view);
            this.saveFieldConfigResult(idList, view);
            boolean bl = true;
            return bl;
        }
    }

    protected void cacheConfigResult(IFormView view, List<Long> stgTypIds) {
        IPageCache pageCache = view.getPageCache();
        Object bo = view.getFormShowParameter().getCustomParam("id");
        Object recrutypid = view.getFormShowParameter().getCustomParam("recrutyp");
        Object groupid = view.getFormShowParameter().getCustomParam("groupid");
        this.cacheOperateConfigResult(pageCache, stgTypIds, bo, recrutypid, groupid);
        this.cacheFieldConfigResult(pageCache, stgTypIds, bo, recrutypid, groupid);
    }

    private void cacheOperateConfigResult(IPageCache pageCache, List<Long> stgTypIds, Object bo, Object recrutypid, Object groupid) {
        Map<Long, List<DynamicObject>> configResult = this.getOperateConfigResult(stgTypIds, bo, recrutypid, groupid);
        for (Map.Entry<Long, List<DynamicObject>> entry : configResult.entrySet()) {
            pageCache.put("operate" + entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
    }

    private void cacheFieldConfigResult(IPageCache pageCache, List<Long> stgTypIds, Object bo, Object recrutypid, Object groupid) {
        Map<Long, List<DynamicObject>> configResult = this.getFieldConfigResult(stgTypIds, bo, recrutypid, groupid);
        for (Map.Entry<Long, List<DynamicObject>> entry : configResult.entrySet()) {
            pageCache.put("field" + entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
    }

    protected abstract List<DynamicObject> saveOperateResult(List<Long> var1, IFormView var2);

    protected abstract List<DynamicObject> saveFieldConfigResult(List<Long> var1, IFormView var2);

    protected abstract Map<Long, List<DynamicObject>> getOperateConfigResult(List<Long> var1, Object var2, Object var3, Object var4);

    protected abstract Map<Long, List<DynamicObject>> getFieldConfigResult(List<Long> var1, Object var2, Object var3, Object var4);
}

