/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.service.cfg.factory;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.impl.BasicProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.impl.TemplateConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.type.FieldConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.type.OperateConfigService;

public class ProcessConfigFactory {
    private static final Map<String, ProcessConfigTypeService> TYPE_SERVICE_MAP = Maps.newHashMapWithExpectedSize((int)2);
    private static final Map<String, ProcessConfigService> CONFIG_SERVICE_MAP = Maps.newHashMapWithExpectedSize((int)2);

    public static ProcessConfigService getConfigService(String configType) {
        return CONFIG_SERVICE_MAP.get(configType);
    }

    public static ProcessConfigTypeService getTypeService(String type) {
        return TYPE_SERVICE_MAP.get(type);
    }

    private ProcessConfigFactory() {
    }

    static {
        CONFIG_SERVICE_MAP.put("tsrbd_processconfig", new BasicProcessConfigService());
        CONFIG_SERVICE_MAP.put("tsrbd_protempconfig", new TemplateConfigService());
        TYPE_SERVICE_MAP.put("operate", new OperateConfigService());
        TYPE_SERVICE_MAP.put("field", new FieldConfigService());
    }
}

