/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.service.cfg.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.operate.MutexHelper;
import kd.bos.mvc.SessionManager;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.RecruitmentStageBusiness;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigBizHelper;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessServiceHelper;
import kd.tsc.tsrbd.business.domain.process.service.cfg.AbstractProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.factory.ProcessConfigFactory;
import kd.tsc.tsrbd.common.utils.PageUtils;

public class BasicProcessConfigService
extends AbstractProcessConfigService {
    @Override
    public void initData(IFormView view) {
        DynamicObjectCollection collection = view.getModel().getEntryEntity("entryentity");
        if (collection.size() == 0) {
            return;
        }
        IFormView parentView = view.getParentView();
        parentView.getFormShowParameter().setCustomParam("groupid", view.getFormShowParameter().getCustomParam("groupid"));
        LinkedHashMap<Long, String> entryMap = new LinkedHashMap<Long, String>(collection.size());
        String fieldKey = "rqmtstg.id";
        String fieldValue = "rqmtstg.name";
        for (DynamicObject dy : collection) {
            entryMap.put(dy.getLong(fieldKey), dy.getString(fieldValue));
        }
        ProcessConfigTypeService typeService = ProcessConfigFactory.getTypeService("operate");
        List<Long> stgTypIds = typeService.initLeftTreeData(entryMap, parentView);
        this.cacheConfigResult(parentView, stgTypIds);
        typeService.initData(parentView);
        view.sendFormAction(parentView);
    }

    @Override
    public boolean saveProcessConfigResult(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String processPageId = pageCache.get("cache_process_page_id");
        IFormView processFormView = SessionManager.getCurrent().getView(processPageId);
        IDataModel model = view.getModel();
        DynamicObjectCollection collection = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        List<Long> idList = collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> operateConfigResult = this.saveOperateResult(idList, view);
        List<DynamicObject> fieldConfigResult = this.saveFieldConfigResult(idList, view);
        OperateOption option = OperateOption.create();
        option.setVariableValue("result_process_operate", SerializationUtils.toJsonString(operateConfigResult));
        option.setVariableValue("result_process_field", SerializationUtils.toJsonString(fieldConfigResult));
        processFormView.getModel().setValue("createOrg", (Object)Long.parseLong(pageCache.get("org")));
        OperationResult operationResult = processFormView.invokeOperation("save", option);
        if (null != operationResult && !operationResult.isSuccess()) {
            if (null == operationResult.getMessage()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"BasicProcessConfigService_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
            } else {
                view.showOperationResult(operationResult);
            }
            return operationResult.isSuccess();
        }
        IFormView mainView = view.getMainView();
        if (mainView != null) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId());
            Tab tab = (Tab)appView.getControl("_submaintab_");
            String prefix = ResManager.loadKDString((String)"\u62db\u8058\u6d41\u7a0b", (String)"BasicProcessConfigService_1", (String)"tsc-tsrbd-business", (Object[])new Object[0]);
            tab.updateTabName(view.getPageId(), prefix + "-" + processFormView.getModel().getDataEntity().getString("name"));
            view.sendFormAction(appView);
        }
        IFormView parentView = PageUtils.getParentView((IFormView)view);
        String successMessage = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"KDEPlugin_5", (String)"bos-devportal-plugin", (Object[])new Object[0]);
        view.showSuccessNotification(successMessage);
        parentView.invokeOperation("refresh");
        view.sendFormAction(parentView);
        processFormView.getModel().setDataChanged(false);
        processFormView.getModel().updateCache();
        view.getPageCache().put("PAGE_OP_CHANGE_DATA_KEY", "");
        return false;
    }

    public void showProcessInfoPage(IFormView formView, Long processId, boolean isLookUp, String userOrgId, CloseCallBack closeCallBack) {
        DynamicObject process = ProcessServiceHelper.getProcessById(processId);
        FormShowParameter showParameter = new FormShowParameter();
        OperationStatus operationStatus = OperationStatus.EDIT;
        boolean modifyPerm = AppUtils.checkPagePermission((String)"tsrbd_rqmtproc", (String)"4715a0df000000ac");
        Map baseDataStatus = HRBaseDataConfigUtil.getStatus((String)"tsrbd_rqmtproc");
        boolean isOpenAuditcheck = Boolean.parseBoolean(baseDataStatus.get("auditcheck").toString());
        if (!modifyPerm) {
            operationStatus = OperationStatus.VIEW;
        } else if (process.getBoolean("issyspreset")) {
            operationStatus = OperationStatus.VIEW;
        } else if (!"A".equals(process.getString("status")) && isOpenAuditcheck) {
            operationStatus = OperationStatus.VIEW;
        } else if (isLookUp) {
            operationStatus = OperationStatus.VIEW;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            boolean require = MutexHelper.require((String)"tsrbd_rqmtproc", (Object)processId, (String)"edit", (StringBuilder)stringBuilder);
            if (!require) {
                operationStatus = OperationStatus.VIEW;
                showParameter.setCustomParam("message", (Object)stringBuilder.toString());
            }
        }
        String pageId = PageUtils.getPageId((String)processId.toString(), (String)"tsrbd", (String)"tsrbd_processconfig", (String)formView.getFormShowParameter().getRootPageId());
        showParameter.setFormId("tsrbd_processconfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getCustomParams().put("id", processId);
        showParameter.getCustomParams().put("issyspreset", process.getBoolean("issyspreset"));
        showParameter.setCustomParam("useorgId", (Object)userOrgId);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        showParameter.setStatus(operationStatus);
        showParameter.setPageId(pageId);
        formView.showForm(showParameter);
    }

    @Override
    protected List<DynamicObject> saveOperateResult(List<Long> idList, IFormView view) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"tsrbd_opercfgresult");
        ArrayList saveOperateConfigResult = Lists.newArrayListWithExpectedSize((int)16);
        for (Long bo : idList) {
            String cacheListString = view.getPageCache().get("operate" + bo);
            if (!HRStringUtils.isNotEmpty((String)cacheListString)) continue;
            List list = (List)JSONObject.parseObject((String)cacheListString, List.class);
            list.forEach(jsonObject -> {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                dynamicObject.set("configentry", (Object)"tsrbd_recrustgnew");
                dynamicObject.set("islistdisplay", jsonObject.get((Object)"islistdisplay"));
                dynamicObject.set("recrustg", (Object)bo);
                dynamicObject.set("operate", jsonObject.getJSONObject("operate").get((Object)"id"));
                saveOperateConfigResult.add(dynamicObject);
            });
        }
        return saveOperateConfigResult;
    }

    @Override
    protected List<DynamicObject> saveFieldConfigResult(List<Long> idList, IFormView view) {
        ArrayList saveFieldConfigResult = Lists.newArrayListWithExpectedSize((int)16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"tsrbd_fieldcfgresult");
        for (Long bo : idList) {
            String cacheListString = view.getPageCache().get("field" + bo);
            if (!HRStringUtils.isNotEmpty((String)cacheListString)) continue;
            List list = (List)JSONObject.parseObject((String)cacheListString, List.class);
            list.forEach(json -> {
                DynamicObject fieldConfigDy = new DynamicObject((DynamicObjectType)type);
                fieldConfigDy.set("configentry", (Object)"tsrbd_recrustgnew");
                fieldConfigDy.set("recrustg", (Object)bo);
                fieldConfigDy.set("field", json.getJSONObject("field").get((Object)"id"));
                fieldConfigDy.set("isdisplay", json.get((Object)"isdisplay"));
                saveFieldConfigResult.add(fieldConfigDy);
            });
        }
        return saveFieldConfigResult;
    }

    @Override
    protected Map<Long, List<DynamicObject>> getOperateConfigResult(List<Long> stageIdList, Object bo, Object recrutypid, Object groupid) {
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null == bo) {
            this.handleOperateResults(resultMap, stageIdList, recrutypid, groupid);
        } else {
            long pkValue = Long.parseLong(bo.toString());
            List<Long> rqmtstgIds = ProcessConfigBizHelper.getRqmtstgByProcId(pkValue);
            resultMap = ProcessConfigBizHelper.getStageOperateConfig(pkValue, stageIdList);
            List<Long> result = stageIdList.stream().filter(dy -> !rqmtstgIds.contains(dy)).collect(Collectors.toList());
            this.handleOperateResults(resultMap, result, recrutypid, groupid);
        }
        return resultMap;
    }

    private void handleOperateResults(Map<Long, List<DynamicObject>> resultMap, List<Long> stageIdList, Object recrutypid, Object groupid) {
        DynamicObject[] stageList = RecruitmentStageBusiness.getStageByPks(stageIdList.toArray());
        String group = "group.id";
        Map<Long, Long> staTypeMap = Arrays.stream(stageList).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong(group)));
        List<Long> stageTypeList = Arrays.stream(stageList).map(dy -> dy.getLong(group)).collect(Collectors.toList());
        if (null != groupid) {
            recrutypid = groupid;
        }
        Map<Long, List<DynamicObject>> recTypeOperateConfig = ProcessConfigBizHelper.getRecTypeOperateConfig(stageTypeList, recrutypid);
        for (Map.Entry<Long, Long> entry : staTypeMap.entrySet()) {
            Long stageId = entry.getKey();
            Long stageTypeId = entry.getValue();
            List<DynamicObject> list = recTypeOperateConfig.get(stageTypeId);
            if (null == list) continue;
            resultMap.put(stageId, list);
        }
    }

    @Override
    protected Map<Long, List<DynamicObject>> getFieldConfigResult(List<Long> stageIdList, Object bo, Object recrutypid, Object groupid) {
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null == bo) {
            this.handleFieldResults(resultMap, stageIdList, recrutypid, groupid);
        } else {
            long pkValue = Long.parseLong(bo.toString());
            List<Long> rqmtstgIds = ProcessConfigBizHelper.getRqmtstgByProcId(pkValue);
            resultMap = ProcessConfigBizHelper.getStageFieldConfig(pkValue, stageIdList);
            List<Long> result = stageIdList.stream().filter(dy -> !rqmtstgIds.contains(dy)).collect(Collectors.toList());
            this.handleFieldResults(resultMap, result, recrutypid, groupid);
        }
        return resultMap;
    }

    private void handleFieldResults(Map<Long, List<DynamicObject>> resultMap, List<Long> stageIdList, Object recrutypid, Object groupid) {
        DynamicObject[] stageList = RecruitmentStageBusiness.getStageByPks(stageIdList.toArray());
        String group = "group.id";
        Map<Long, Long> staTypeMap = Arrays.stream(stageList).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong(group)));
        List<Long> stageTypeList = Arrays.stream(stageList).map(dy -> dy.getLong(group)).collect(Collectors.toList());
        if (null != groupid) {
            recrutypid = groupid;
        }
        Map<Long, List<DynamicObject>> recTypeOperateConfig = ProcessConfigBizHelper.getRecTypeFieldConfig(stageTypeList, recrutypid);
        for (Map.Entry<Long, Long> entry : staTypeMap.entrySet()) {
            Long stageId = entry.getKey();
            Long stageTypeId = entry.getValue();
            List<DynamicObject> list = recTypeOperateConfig.get(stageTypeId);
            if (null == list) continue;
            resultMap.put(stageId, list);
        }
    }
}

