/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.process.service.cfg.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.process.helper.ProcessConfigBizHelper;
import kd.tsc.tsrbd.business.domain.process.service.cfg.AbstractProcessConfigService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.ProcessConfigTypeService;
import kd.tsc.tsrbd.business.domain.process.service.cfg.factory.ProcessConfigFactory;

public class TemplateConfigService
extends AbstractProcessConfigService {
    @Override
    public void initData(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        List stageTypeList = (List)parameter.getCustomParam("recrustgtyp");
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_recrustgtyp");
        DynamicObject[] treeData = serviceHelper.loadDynamicObjectArray(stageTypeList.toArray());
        LinkedHashMap treeDataMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        treeDataMap.put(0L, ResManager.loadKDString((String)"\u901a\u7528", (String)"ProcessConfig_0", (String)"tsc-tsrbd-business", (Object[])new Object[0]));
        Arrays.stream(treeData).forEach(dy -> treeDataMap.put(dy.getLong("id"), dy.getString("name")));
        List<Long> stgTypIds = this.configTypeService.initLeftTreeData(treeDataMap, view);
        this.cacheConfigResult(view, stgTypIds);
        ProcessConfigTypeService typeService = ProcessConfigFactory.getTypeService("operate");
        typeService.initData(view);
        view.getPageCache().put("listBoxClickItemId", "operate");
    }

    @Override
    protected List<DynamicObject> saveOperateResult(List<Long> idList, IFormView view) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_opercfgresult");
        QFilter filter = new QFilter("configentry", "=", (Object)"tsrbd_recrustgtyp");
        filter.and("rqmtproc", "=", (Object)0L);
        DynamicObject[] operateConfigResultDys = helper.loadDynamicObjectArray(new QFilter[]{filter});
        for (Long bo : idList) {
            String cacheListString = view.getPageCache().get("operate" + bo);
            if (!HRStringUtils.isNotEmpty((String)cacheListString)) continue;
            List list = (List)JSONObject.parseObject((String)cacheListString, List.class);
            for (JSONObject jsonObject : list) {
                long operate = jsonObject.getJSONObject("operate").getLong("id");
                Arrays.stream(operateConfigResultDys).filter(dy -> this.operateEq(operate, bo, (DynamicObject)dy)).findFirst().ifPresent(dy -> dy.set("islistdisplay", jsonObject.get((Object)"islistdisplay")));
            }
        }
        helper.update(operateConfigResultDys);
        return null;
    }

    @Override
    protected List<DynamicObject> saveFieldConfigResult(List<Long> idList, IFormView view) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_fieldcfgresult");
        QFilter filter = new QFilter("configentry", "=", (Object)"tsrbd_recrustgtyp");
        filter.and("rqmtproc", "=", (Object)0L);
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{filter});
        for (Long bo : idList) {
            String cacheListString = view.getPageCache().get("field" + bo);
            if (!HRStringUtils.isNotEmpty((String)cacheListString)) continue;
            List list = (List)JSONObject.parseObject((String)cacheListString, List.class);
            for (JSONObject json : list) {
                long field = json.getJSONObject("field").getLong("id");
                Arrays.stream(dys).filter(dy -> this.fieldEq(field, bo, (DynamicObject)dy)).findFirst().ifPresent(dy -> dy.set("isdisplay", json.get((Object)"isdisplay")));
            }
        }
        helper.update(dys);
        return null;
    }

    @Override
    protected Map<Long, List<DynamicObject>> getOperateConfigResult(List<Long> stgTypIds, Object obj, Object recrutypid, Object groupid) {
        return ProcessConfigBizHelper.getRecTypeOperateConfig(stgTypIds, recrutypid);
    }

    @Override
    protected Map<Long, List<DynamicObject>> getFieldConfigResult(List<Long> stgTypIds, Object obj, Object recrutypid, Object groupid) {
        return ProcessConfigBizHelper.getRecTypeFieldConfig(stgTypIds, recrutypid);
    }

    private boolean fieldEq(long field, Long parentBo, DynamicObject fieldDy) {
        Object type = fieldDy.get("recrustgtyp");
        String keyWord = "field.id";
        return type.equals(parentBo) && fieldDy.getLong(keyWord) == field;
    }

    private boolean operateEq(long operate, Long parentBo, DynamicObject operateConfigResultDy) {
        Object type = operateConfigResultDy.get("recrustgtyp");
        String keyWord = "operate.id";
        return type.equals(parentBo) && operateConfigResultDy.getLong(keyWord) == operate;
    }
}

