/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rewardrule;

import java.util.Collection;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.rewardrule.RewardRuleQFilterHelper;

public class RewardRuleDataHelper
extends HRBaseServiceHelper {
    private static final Integer NO_DATA = -1;

    private RewardRuleDataHelper() {
        super("tsrbd_rewardrule");
    }

    public static RewardRuleDataHelper getInstance() {
        return RewardRuleDataHelperHolder.REWARD_RULE_DATA_HELPER;
    }

    public DynamicObject[] queryRewardRuleByIds(Collection<Long> ids) {
        return this.loadDynamicObjectArray(RewardRuleQFilterHelper.queryByIds(ids).toArray());
    }

    public DynamicObject queryJobFamilyScm(long jobScm, long jobFamily) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobfamilyscm");
        return serviceHelper.queryOne("id,name,number,jobseq,jobfamily,createorg,jobgradescm,joblevelscm", RewardRuleQFilterHelper.queryJobFamilyScmQFilter(jobScm, jobFamily));
    }

    public boolean jobLeveAndGradeWithin(DynamicObject onBoard, Long offerLevelId, Long offerGradeId, ThreeTuple<DynamicObject[], DynamicObject[], DynamicObject[]> jobLevelAndGrade) {
        DynamicObject[] jobScmhrs = (DynamicObject[])jobLevelAndGrade.item1;
        DynamicObject[] levels = (DynamicObject[])jobLevelAndGrade.item2;
        DynamicObject[] grades = (DynamicObject[])jobLevelAndGrade.item3;
        DynamicObject targetLevel = this.filterJobData(offerLevelId, levels);
        DynamicObject targetGrade = this.filterJobData(offerGradeId, grades);
        if (null == targetLevel || targetGrade == null) {
            return false;
        }
        if (this.isMatchScmHr(jobScmhrs, targetLevel, targetGrade)) {
            return this.jobLeveAndGradeWithin(targetLevel, targetGrade, onBoard);
        }
        return false;
    }

    private boolean isMatchScmHr(DynamicObject[] jobScmhrs, DynamicObject targetLevel, DynamicObject targetGrade) {
        long levelId = targetLevel.getLong("joblevelscm.id");
        long gradeId = targetGrade.getLong("jobgradescm.id");
        for (DynamicObject jobScmhr : jobScmhrs) {
            long scmLevelId = jobScmhr.getLong("joblevelscm.id");
            long scmGradeId = jobScmhr.getLong("jobgradescm.id");
            if (levelId != scmLevelId || scmGradeId != gradeId) continue;
            return true;
        }
        return false;
    }

    public boolean jobLeveAndGradeWithin(DynamicObject targetLevel, DynamicObject targetGrade, DynamicObject onBoard) {
        int lowLevelNum = NO_DATA;
        int highLevelNum = NO_DATA;
        int lowGradeNum = NO_DATA;
        int higGradeNum = NO_DATA;
        DynamicObject lowJobGrade = onBoard.getDynamicObject("lowjobgrade1");
        DynamicObject highJobGrade = onBoard.getDynamicObject("highjobgrade1");
        DynamicObject lowJobLevel = onBoard.getDynamicObject("classlevellow1");
        DynamicObject highJobLevel = onBoard.getDynamicObject("classlevelhigh1");
        if (!HRObjectUtils.isEmpty((Object)lowJobGrade)) {
            lowGradeNum = lowJobGrade.getInt("jobgradeseq");
        }
        if (!HRObjectUtils.isEmpty((Object)highJobGrade)) {
            higGradeNum = highJobGrade.getInt("jobgradeseq");
        }
        if (!HRObjectUtils.isEmpty((Object)lowJobLevel)) {
            lowLevelNum = lowJobLevel.getInt("joblevelseq");
        }
        if (!HRObjectUtils.isEmpty((Object)highJobLevel)) {
            highLevelNum = highJobLevel.getInt("joblevelseq");
        }
        int targetLevelNum = NO_DATA;
        int targetGradeNum = NO_DATA;
        if (!HRObjectUtils.isEmpty((Object)targetLevel)) {
            targetLevelNum = targetLevel.getInt("joblevelseq");
        }
        if (!HRObjectUtils.isEmpty((Object)targetGrade)) {
            targetGradeNum = targetGrade.getInt("jobgradeseq");
        }
        boolean inLevel = this.isWithin(targetLevelNum, lowLevelNum, highLevelNum);
        boolean inGrade = this.isWithin(targetGradeNum, lowGradeNum, higGradeNum);
        return inLevel && inGrade;
    }

    private boolean isWithin(int target, int lowNum, int highNum) {
        if (target == NO_DATA) {
            return false;
        }
        return lowNum != NO_DATA && highNum == NO_DATA ? target >= lowNum : (highNum != NO_DATA && lowNum == NO_DATA ? target <= highNum : highNum > NO_DATA && lowNum > NO_DATA && target >= lowNum && target <= highNum);
    }

    private DynamicObject filterJobData(long targetId, DynamicObject[] jobLevelAndGrades) {
        for (DynamicObject dynamicObject : jobLevelAndGrades) {
            long jobLevelId = dynamicObject.getLong("id");
            if (jobLevelId != targetId) continue;
            return dynamicObject;
        }
        return null;
    }

    public DynamicObjectCollection queryRecrustgByRqmtproc(long rqmtproc) {
        HRBaseServiceHelper dbServiceRqmtproc = new HRBaseServiceHelper("tsrbd_rqmtproc");
        DynamicObject dynamicObject = dbServiceRqmtproc.queryOne((Object)rqmtproc);
        return dynamicObject.getDynamicObjectCollection("entryentity");
    }

    public DynamicObject getResultByPosManage(DynamicObject manageInfo) {
        DynamicObject rewardRule = manageInfo.getDynamicObject("rewardrule");
        DynamicObject recProc = manageInfo.getDynamicObject("recruproc");
        if (HRObjectUtils.isEmpty((Object)recProc)) {
            return null;
        }
        if (HRObjectUtils.isEmpty((Object)rewardRule)) {
            return null;
        }
        long posManageRecProcId = recProc.getLong("id");
        rewardRule = this.loadSingle(rewardRule.getLong("id"));
        DynamicObjectCollection results = rewardRule.getDynamicObjectCollection("entryentity2");
        for (DynamicObject result : results) {
            long rqmtProcId = result.getLong("rqmtproc.id");
            if (posManageRecProcId != rqmtProcId) continue;
            return result;
        }
        return null;
    }

    public DynamicObject[] queryJobGrade(long jobGrade) {
        HRBaseServiceHelper jobGradeHelper = new HRBaseServiceHelper("hbjm_jobgradehr");
        QFilter qFilter = RewardRuleQFilterHelper.queryJobGradeByJobGradeScmQFilter(jobGrade);
        return jobGradeHelper.query("jobgradeseq", qFilter.toArray(), "jobgradeseq");
    }

    public DynamicObject[] queryJobLevel(long jobLevel) {
        HRBaseServiceHelper jobGradeHelper = new HRBaseServiceHelper("hbjm_joblevelhr");
        QFilter qFilter = RewardRuleQFilterHelper.queryJobLevelByJobLevelScmQFilter(jobLevel);
        return jobGradeHelper.query("joblevelseq", qFilter.toArray(), "joblevelseq");
    }

    public boolean checkIsCreateOrgForCtrl(IFormView view) {
        String createOrgId;
        String useOrgID = (String)view.getFormShowParameter().getCustomParam("useorgId");
        DynamicObject createOrg = (DynamicObject)view.getModel().getValue("createorg");
        if (null == useOrgID && null != view.getModel().getValue("useOrg")) {
            useOrgID = ((DynamicObject)view.getModel().getValue("useOrg")).getPkValue().toString();
        }
        return null == createOrg || !StringUtils.isNotEmpty((CharSequence)useOrgID) || (createOrgId = String.valueOf(createOrg.getPkValue())).equals(useOrgID);
    }

    private static class RewardRuleDataHelperHolder {
        private static final RewardRuleDataHelper REWARD_RULE_DATA_HELPER = new RewardRuleDataHelper();

        private RewardRuleDataHelperHolder() {
        }
    }
}

