/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.rule.RuleContext;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleBizHelper;

public abstract class AbstractRuleContext
implements RuleContext {
    protected final Log logger = LogFactory.getLog(AbstractRuleContext.class);
    private String bizApp;
    private String sceneNumber;
    private String buNumber;
    private List<Long> executePolicyIds = Lists.newArrayListWithExpectedSize((int)16);

    @Override
    public Map<String, Object> getBaseMap() {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)this.bizApp)) {
            return new HashMap<String, Object>();
        }
        requestMap.put("bizApp", this.bizApp);
        if (HRStringUtils.isEmpty((String)this.sceneNumber)) {
            return new HashMap<String, Object>();
        }
        requestMap.put("sceneNumber", this.sceneNumber);
        if (HRStringUtils.isEmpty((String)this.buNumber)) {
            return new HashMap<String, Object>();
        }
        requestMap.put("buNumber", this.buNumber);
        requestMap.put("executePolicyIds", this.executePolicyIds);
        return requestMap;
    }

    @Override
    public void setAutoRulesConfig(DynamicObject config) {
        this.sceneNumber = config.getString("group.number");
        this.logger.info("AbstractRuleContext.setAutoRulesConfig.scene:[{}]", (Object)this.sceneNumber);
        DynamicObject sceneDy = RuleBizHelper.getSceneByNumber(this.sceneNumber);
        this.bizApp = sceneDy.getString("bizappid.number");
        this.logger.info("AbstractRuleContext.setAutoRulesConfig.bizApp:[{}]", (Object)this.bizApp);
        if (Objects.isNull(this.buNumber)) {
            long orgId = RequestContext.get().getOrgId();
            HRBaseServiceHelper orgHelper = ServiceHelperCache.getHrBaseServiceHelper("bos_org");
            DynamicObject orgDy = orgHelper.loadSingle((Object)orgId);
            this.buNumber = orgDy.getString("number");
        }
        this.logger.info("AbstractRuleContext.setAutoRulesConfig.buNumber:[{}]", (Object)this.buNumber);
        long policyId = config.getLong("policy.id");
        this.executePolicyIds.add(policyId);
        this.logger.info("AbstractRuleContext.setAutoRulesConfig.executePolicyIds:[{}]", this.executePolicyIds);
    }

    protected List<RuleResult> getRuleResult(List<PolicyResult> policyResultList) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (PolicyResult policyResult : policyResultList) {
            List ruleResults = policyResult.getRuleResults();
            list.addAll(ruleResults);
        }
        return list;
    }

    protected List<Map<String, Object>> getBatchRuleList(List<PolicyResult> policyResultList) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (PolicyResult policyResult : policyResultList) {
            Map defaultResults = policyResult.getDefaultResults();
            list.add(defaultResults);
        }
        return list;
    }

    protected List<Map<String, Object>> getMatchResults(List<RuleResult> ruleResultList) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (RuleResult ruleResult : ruleResultList) {
            Map matchResults = ruleResult.getMatchResults();
            list.add(matchResults);
        }
        return list;
    }

    protected <T> T analysisMatchResults(List<Map<String, Object>> matchResults, String ruleResultFlag) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)matchResults.size());
        for (Map<String, Object> matchResult : matchResults) {
            Object obj = matchResult.get(ruleResultFlag);
            result.add(obj);
        }
        return (T)result;
    }

    public void setBuNumber(String buNumber) {
        this.logger.info("AbstractRuleContext.setBuNumber:[{}]", (Object)buNumber);
        this.buNumber = buNumber;
    }

    public void setBizApp(String bizApp) {
        this.bizApp = bizApp;
    }

    public void setSceneNumber(String sceneNumber) {
        this.sceneNumber = sceneNumber;
    }

    public void setExecutePolicyIds(List<Long> executePolicyIds) {
        this.logger.info("AbstractRuleContext.setExecutePolicyIds:[{}]", executePolicyIds);
        this.executePolicyIds.addAll(executePolicyIds);
    }

    protected abstract void afterExecute();
}

