/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.OrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class RuleBizHelper {
    private static final Log logger = LogFactory.getLog(RuleBizHelper.class);

    public static Map<String, Object> addRulePolicy(DynamicObject ruleConfig, String defaultResult, List<Map<String, Object>> ruleList, List<Map<String, Object>> buList) {
        HashMap policyMap = Maps.newHashMapWithExpectedSize((int)16);
        policyMap.put("name", ruleConfig.getString("number") + "_" + ruleConfig.getString("policytext"));
        policyMap.put("number", ruleConfig.getString("number"));
        policyMap.put("createbu", ruleConfig.getLong("createbu.id"));
        DynamicObject scene = ruleConfig.getDynamicObject("group");
        DynamicObject sceneDy = RuleBizHelper.getSceneByNumber(scene.getString("number"));
        policyMap.put("enable", ruleConfig.get("enable"));
        policyMap.put("description", ruleConfig.getString("desc"));
        policyMap.put("bizappid", sceneDy.getString("bizappid.id"));
        policyMap.put("scene", scene.getLong("id"));
        policyMap.put("results", defaultResult);
        policyMap.put("entryrulelist", ruleList);
        policyMap.put("entrybulist", buList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"addPolicy", (Object[])new Object[]{policyMap});
        logger.info(JSON.toJSONString((Object)result));
        return result;
    }

    public static Map<String, Object> modifyPolicy(DynamicObject ruleConfig, String defaultResult, List<Map<String, Object>> ruleList, List<Map<String, Object>> buList) {
        HashMap policyMap = Maps.newHashMapWithExpectedSize((int)16);
        policyMap.put("id", ruleConfig.getLong("policy.id"));
        policyMap.put("name", ruleConfig.getString("number") + "_" + ruleConfig.getString("policytext"));
        policyMap.put("number", ruleConfig.getString("policy.number"));
        policyMap.put("enable", ruleConfig.get("enable"));
        policyMap.put("createbu", ruleConfig.getLong("createbu.id"));
        DynamicObject scene = ruleConfig.getDynamicObject("group");
        DynamicObject sceneDy = RuleBizHelper.getSceneByNumber(scene.getString("number"));
        policyMap.put("bizappid", sceneDy.getString("bizappid.id"));
        policyMap.put("description", ruleConfig.getString("desc"));
        policyMap.put("scene", scene.getLong("id"));
        policyMap.put("results", defaultResult);
        policyMap.put("entryrulelist", ruleList);
        policyMap.put("entrybulist", buList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"modifyPolicy", (Object[])new Object[]{policyMap});
        logger.info(JSON.toJSONString((Object)result));
        return result;
    }

    public static DynamicObject queryRulePolicyNumber(String number) {
        HRBaseServiceHelper policyHelper = ServiceHelperCache.getHrBaseServiceHelper("brm_policy_edit");
        QFilter filter = new QFilter("number", "=", (Object)number);
        return policyHelper.loadDynamicObject(new QFilter[]{filter});
    }

    public static DynamicObject[] queryRulePolicyListBySceneNumber(String sceneNumber) {
        HRBaseServiceHelper policyHelper = ServiceHelperCache.getHrBaseServiceHelper("brm_policy_edit");
        QFilter filter = new QFilter("scene.number", "=", (Object)sceneNumber);
        return policyHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static List<DynamicObject> getPolicyEntityBu(DynamicObject policy) {
        String policyNumber = policy.getString("policy.number");
        DynamicObject policyDy = RuleBizHelper.queryRulePolicyNumber(policyNumber);
        DynamicObjectCollection collection = policyDy.getDynamicObjectCollection("entrybulist");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dy : collection) {
            DynamicObject entryBu = dy.getDynamicObject("entitybu");
            result.add(entryBu);
            boolean containsSub = dy.getBoolean("containssub");
            if (!containsSub) continue;
            List<DynamicObject> childDy = RuleBizHelper.getChildDy(dy);
            result.addAll(childDy);
        }
        return result;
    }

    public static List<DynamicObject> getChildDy(DynamicObject dy) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"brm_policy_edit");
        String orgViewType = PermCommonUtil.getPermOrgViewSchemeByOrgField((MainEntityType)entityType, (String)"createbu");
        OrgService orgService = new OrgService();
        long currUserId = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        return orgService.getChildrenData(orgViewType, Long.valueOf(currUserId), Long.valueOf(orgId), null, Long.valueOf(dy.getLong("id")));
    }

    public static DynamicObject getSceneByNumber(String number) {
        HRBaseServiceHelper sceneHelper = ServiceHelperCache.getHrBaseServiceHelper("brm_scene");
        QFilter filter = new QFilter("number", "=", (Object)number);
        return sceneHelper.loadDynamicObject(filter);
    }

    public static DynamicObject getPolicyById(Long policyId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("brm_policy_edit");
        return helper.loadSingle((Object)policyId);
    }

    public static DynamicObject[] getAutomaticRules(QFilter qFilter) {
        HRBaseServiceHelper policyHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_autorules");
        return policyHelper.query(qFilter.toArray());
    }

    public static DynamicObject getAutomaticRulesById(Long id) {
        HRBaseServiceHelper policyHelper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_autorules");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return policyHelper.loadDynamicObject(qFilter);
    }

    public static List<Map<String, Object>> getOldOrgById(Long id) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject automaticRules = RuleBizHelper.getPolicyById(id);
        DynamicObjectCollection collection = automaticRules.getDynamicObjectCollection("entrybulist");
        for (DynamicObject dynamicObject : collection) {
            HashMap<String, Object> buMap = new HashMap<String, Object>(16);
            buMap.put("id", dynamicObject.getLong("id"));
            buMap.put("modifystatus", "delete");
            buMap.put("entitybu", dynamicObject.get("entitybu"));
            buMap.put("containssub", dynamicObject.get("containssub"));
            list.add(buMap);
        }
        return list;
    }

    public static List<Map<String, Object>> getOldRulesById(Long id) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject automaticRules = RuleBizHelper.getPolicyById(id);
        DynamicObjectCollection collection = automaticRules.getDynamicObjectCollection("entryrulelist");
        for (DynamicObject dynamicObject : collection) {
            HashMap<String, Object> ruleMap = new HashMap<String, Object>(16);
            ruleMap.put("modifystatus", "delete");
            ruleMap.put("rulename", dynamicObject.get("rulename"));
            ruleMap.put("rulenumber", dynamicObject.get("rulenumber"));
            ruleMap.put("ruleorder", dynamicObject.get("ruleorder"));
            ruleMap.put("filtercondition", dynamicObject.get("filtercondition"));
            ruleMap.put("filterresult", dynamicObject.get("filterresult"));
            ruleMap.put("ruleenable", dynamicObject.get("ruleenable"));
            ruleMap.put("id", dynamicObject.getLong("id"));
            list.add(ruleMap);
        }
        return list;
    }

    public static List<Long> getOrgByUserId() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)true);
        return userHasPermOrgs.getHasPermOrgs();
    }
}

