/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class RuleConfigHelper {
    private static final Log logger = LogFactory.getLog(RuleConfigHelper.class);

    public static DynamicObject getRuleConfigByNumber(String number) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_autorules");
        QFilter filter = new QFilter("number", "=", (Object)number);
        return helper.loadDynamicObject(new QFilter[]{filter});
    }

    public static DynamicObject[] getRuleConfig(String operate) {
        DynamicObject ruleConfigOperate = RuleConfigHelper.getRuleConfigOperate(operate);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_autorules");
        QFilter filter = new QFilter("entryoperate.operate.id", "=", ruleConfigOperate.get("id"));
        filter.and("enable", "=", (Object)"1");
        logger.info("RuleConfigHelper.getRuleConfigOperate.filter:[{}]", (Object)filter);
        return helper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static List<String> getTscBizappId() {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("hbp_devportal_bizapp");
        QFilter filter = new QFilter("bizcloud.id", "=", (Object)"15DWQTD1X7EK");
        filter.and("deploystatus", "=", (Object)"2");
        DynamicObject[] result = helper.query("id", filter.toArray());
        return Arrays.stream(result).map(dy -> dy.getString("id")).collect(Collectors.toList());
    }

    public static DynamicObject getRuleConfigOperate(String operate) {
        logger.info("RuleConfigHelper.getRuleConfigOperate.operate:[{}]", (Object)operate);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_operatmanage");
        QFilter filter = new QFilter("number", "=", (Object)operate);
        return helper.loadDynamicObject(filter);
    }

    public static Boolean checkTextFormat(String text) {
        String regex = "^[\\u4E00-\\u9FA5A-Za-z0-9_]+$";
        return text.matches(regex);
    }

    public static DynamicObject[] getAutoRulesByScene(String number) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_autorules");
        QFilter filter = new QFilter("group.number", "=", (Object)number);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] autoRules = helper.loadDynamicObjectArray(filter.toArray());
        return autoRules;
    }

    public static DynamicObject[] getAutoOperateByScene(String sceneNumber) {
        logger.info("RuleConfigHelper.getAutoOperateByScene.scene:[{}]", (Object)sceneNumber);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_ruleopmanage");
        QFilter filter = new QFilter("group.number", "=", (Object)sceneNumber);
        return helper.loadDynamicObjectArray(filter.toArray());
    }

    public static DynamicObject getRuleOpByNumber(String number) {
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper("tsrbd_ruleopmanage");
        QFilter filter = new QFilter("number", "=", (Object)number);
        return helper.loadDynamicObject(filter);
    }

    public static String getNumberConfig() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_ruleconfig");
        DynamicObject billDyn = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.getNumber((String)"tsrbd_ruleconfig", (DynamicObject)billDyn, null);
    }
}

