/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class CommonRuleService {
    private static Log logger = LogFactory.getLog(CommonRuleService.class);
    private static CommonRuleService instance;

    public static CommonRuleService getInstance() {
        if (instance == null) {
            instance = new CommonRuleService();
        }
        return instance;
    }

    public Map<String, Object> invokeRuleEngine(Map<String, Object> requestMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
    }

    public List<Map<String, Object>> getMatchOrDefValue(Map<String, Object> requestMap) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        Map<String, Object> map = this.invokeRuleEngine(requestMap);
        if (map.get("responseCode") == null || !map.get("responseCode").equals("200")) {
            return values;
        }
        List policyResults = (List)map.get("policyResults");
        if (policyResults == null || policyResults.size() == 0) {
            return values;
        }
        policyResults.forEach(policyResult -> {
            String policyNumber = policyResult.get("policyNumber").toString();
            List ruleResults = (List)policyResult.get("ruleResults");
            Map defResults = (Map)policyResult.get("defaultResults");
            if (ruleResults != null && ruleResults.size() > 0) {
                ruleResults.forEach(ruleResult -> values.add((Map)ruleResult.get("matchResults")));
            }
            if (defResults != null) {
                values.add(defResults);
            }
        });
        return values;
    }

    public List<Map<String, Object>> onlyGetMatchOrDefValue(Map<String, Object> sceneResults) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        if (sceneResults.get("responseCode") == null || !sceneResults.get("responseCode").equals("200")) {
            return values;
        }
        List policyResults = (List)sceneResults.get("policyResults");
        if (policyResults == null || policyResults.size() == 0) {
            return values;
        }
        policyResults.forEach(policyResult -> {
            String policyNumber = policyResult.get("policyNumber").toString();
            List ruleResults = (List)policyResult.get("ruleResults");
            Map defResults = (Map)policyResult.get("defaultResults");
            if (ruleResults != null && ruleResults.size() > 0) {
                ruleResults.forEach(ruleResult -> values.add((Map)ruleResult.get("matchResults")));
            }
            if (defResults != null) {
                values.add(defResults);
            }
        });
        return values;
    }

    public List<Object> getReturnValue(Map<String, Object> requestMap, String param) {
        ArrayList<Object> values = new ArrayList<Object>(4);
        List<Map<String, Object>> matchValues = this.getMatchOrDefValue(requestMap);
        matchValues.forEach(matchValue -> {
            Object value = matchValue.get(param);
            if (value != null) {
                values.add(value);
            }
        });
        return values;
    }

    public List<Object> onlyGetReturnValue(List<Map<String, Object>> matchValues, String param) {
        ArrayList<Object> values = new ArrayList<Object>(4);
        matchValues.forEach(matchValue -> {
            Object value = matchValue.get(param);
            if (value != null) {
                values.add(value);
            }
        });
        return values;
    }
}

