/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleConfigHelper;
import kd.tsc.tsrbd.business.domain.rule.service.IAutoRuleService;
import kd.tsc.tsrbd.business.domain.rule.service.impl.HRMServiceHelperImpl;
import kd.tsc.tsrbd.business.domain.rule.service.matchrule.MatchRule;
import org.apache.commons.collections.MapUtils;

public class AutoRuleServiceImpl
implements IAutoRuleService {
    private static final Log logger = LogFactory.getLog(AutoRuleServiceImpl.class);
    private static final String OP_OPERATION = "op";
    private static final String RPC_OPERATION = "rpc";

    @Override
    public boolean execute(String appNumber, String sceneNumber, String buNumber, Map<String, Object> sceneInputParam) {
        if (HRStringUtils.isEmpty((String)appNumber)) {
            logger.info("appNumber is null");
            return false;
        }
        if (HRStringUtils.isEmpty((String)sceneNumber)) {
            logger.info("sceneNumber is null");
            return false;
        }
        if (HRStringUtils.isEmpty((String)buNumber)) {
            logger.info("buNumber is null");
            return false;
        }
        if (MapUtils.isEmpty(sceneInputParam)) {
            logger.info("sceneInputParam is empty");
            return false;
        }
        DynamicObject[] autoRules = RuleConfigHelper.getAutoRulesByScene(sceneNumber);
        if (autoRules == null || autoRules.length == 0) {
            logger.info("\u3010AutoRuleServiceImpl\u3011\"execute\" not match autoRule");
            return false;
        }
        List<Long> policyIds = Arrays.stream(autoRules).map(autoRule -> autoRule.getDynamicObject("policy").getLong("id")).collect(Collectors.toList());
        Map<String, Object> ruleEngineResultMap = this.invokeRuleEngine(appNumber, sceneNumber, buNumber, sceneInputParam, policyIds);
        if (!"200".equals(ruleEngineResultMap.get("responseCode"))) {
            logger.info("\u3010AutoRuleServiceImpl\u3011 matchRuleResults fail responseCode : {} ", ruleEngineResultMap.get("responseCode"));
            return false;
        }
        SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(ruleEngineResultMap);
        List<Map<String, Object>> matchResults = this.getMatchRuleList(sceneResult);
        logger.info("\u3010AutoRuleServiceImpl\u3011 matchRuleResults : {}", matchResults);
        Map<Long, DynamicObject> opConfigMap = this.getOpConfigByScene(sceneNumber);
        ArrayList opOperationList = Lists.newArrayListWithCapacity((int)16);
        ArrayList rpcOperationList = Lists.newArrayListWithCapacity((int)16);
        this.setOperations(autoRules, opConfigMap, opOperationList, rpcOperationList);
        logger.info("\u3010AutoRuleServiceImpl\u3011 match operation size ({},{})", (Object)opOperationList.size(), (Object)rpcOperationList.size());
        if (opOperationList.isEmpty() && rpcOperationList.isEmpty()) {
            logger.info("\u3010AutoRuleServiceImpl\u3011 not match operation");
            return false;
        }
        try {
            for (Map<String, Object> matchResult : matchResults) {
                this.autoInvokeOp(matchResult, opOperationList);
                this.autoInvokeRpc(matchResult, rpcOperationList, sceneInputParam);
            }
        }
        catch (Exception e) {
            logger.error("\u3010AutoRuleServiceImpl\u3011callback business service fail , the message {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean executeBatch(Map<String, Object> baseRequestMap, List<Map<String, Object>> inputParamsMapLis) {
        if (baseRequestMap == null) {
            logger.info("baseRequestMap is empty");
            return false;
        }
        if (inputParamsMapLis == null) {
            logger.info("inputParamsMapLis is empty");
            return false;
        }
        if (baseRequestMap.get("bizApp") == null) {
            logger.info("{} is empty", (Object)"bizApp");
            return false;
        }
        if (baseRequestMap.get("sceneNumber") == null) {
            logger.info("{} is empty", (Object)"sceneNumber");
            return false;
        }
        if (baseRequestMap.get("buNumber") == null) {
            logger.info("{} is empty", (Object)"buNumber");
            return false;
        }
        DynamicObject[] autoRules = RuleConfigHelper.getAutoRulesByScene(baseRequestMap.get("sceneNumber").toString());
        if (autoRules == null || autoRules.length == 0) {
            logger.info("\u3010AutoRuleServiceImpl\u3011\"executeBatch\" not match autoRule");
            return false;
        }
        List<Map<String, Object>> ruleEngineResultDtos = HRMServiceHelperImpl.Singleton.INSTANCE.getInstance().batchCallRuleEngine(baseRequestMap, inputParamsMapLis);
        if (ruleEngineResultDtos == null || ruleEngineResultDtos.isEmpty()) {
            return false;
        }
        return this.callBackBusinesService(baseRequestMap, autoRules, ruleEngineResultDtos, inputParamsMapLis);
    }

    private boolean callBackBusinesService(Map<String, Object> baseRequestMap, DynamicObject[] autoRules, List<Map<String, Object>> ruleEngineResultDtos, List<Map<String, Object>> inputParamsMapLis) {
        Map<Long, DynamicObject> opConfigMap = this.getOpConfigByScene(baseRequestMap.get("sceneNumber").toString());
        ArrayList opOperationList = Lists.newArrayListWithCapacity((int)16);
        ArrayList rpcOperationList = Lists.newArrayListWithCapacity((int)16);
        this.setOperations(autoRules, opConfigMap, opOperationList, rpcOperationList);
        logger.info("\u3010AutoRuleServiceImpl\u3011\"executeBatch\" match operation size ({},{})", (Object)opOperationList.size(), (Object)rpcOperationList.size());
        if (opOperationList.isEmpty() && rpcOperationList.isEmpty()) {
            logger.info("\u3010AutoRuleServiceImpl\u3011\"executeBatch\" not match operation");
            return false;
        }
        boolean isHandleSucess = false;
        for (Map<String, Object> ruleEngineResultMap : ruleEngineResultDtos) {
            if (!"200".equals(ruleEngineResultMap.get("responseCode"))) {
                logger.info("\u3010AutoRuleServiceImpl\u3011 \"executeBatch\" matchRuleResults fail responseCode : ({},{}) ", ruleEngineResultMap.get("responseCode"), ruleEngineResultMap.get("responseDesc"));
                continue;
            }
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(ruleEngineResultMap);
            List<Map<String, Object>> matchResults = this.getMatchRuleList(sceneResult);
            logger.info("\u3010AutoRuleServiceImpl\u3011callBackBusinesService matchRuleResults : {}", matchResults);
            try {
                for (Map<String, Object> matchResult : matchResults) {
                    this.autoInvokeOp(matchResult, opOperationList);
                    inputParamsMapLis.forEach(inputParam -> this.autoInvokeRpc(matchResult, rpcOperationList, (Map<String, Object>)inputParam));
                }
                if (isHandleSucess || matchResults.isEmpty()) continue;
                isHandleSucess = true;
            }
            catch (Exception e) {
                logger.error("\u3010AutoRuleServiceImpl\u3011\"executeBatch\" callback business service fail , the message {}", (Object)e.getMessage());
                return false;
            }
        }
        return isHandleSucess;
    }

    private void setOperations(DynamicObject[] autoRules, Map<Long, DynamicObject> opConfigMap, List<DynamicObject> opOperationList, List<DynamicObject> rpcOperationList) {
        for (DynamicObject autoRule : autoRules) {
            DynamicObjectCollection operations = autoRule.getDynamicObjectCollection("entryoperate");
            operations.stream().peek(this.printOperationLog()).filter(operation -> opConfigMap.containsKey(operation.getDynamicObject("operate").getLong("id"))).forEach(this.addOperaion(opConfigMap, opOperationList, rpcOperationList));
        }
    }

    private Consumer<DynamicObject> addOperaion(Map<Long, DynamicObject> opConfigMap, List<DynamicObject> opOperationList, List<DynamicObject> rpcOperationList) {
        return operation -> {
            DynamicObject opConfigObj = (DynamicObject)opConfigMap.get(operation.getDynamicObject("operate").getLong("id"));
            if (OP_OPERATION.equals(opConfigObj.getString("plugintype"))) {
                logger.info("\u3010AutoRuleServiceImpl\u3011add op operation : {}", (Object)operation.getLong("id"));
                opOperationList.add(opConfigObj);
            } else if (RPC_OPERATION.equals(opConfigObj.getString("plugintype"))) {
                logger.info("\u3010AutoRuleServiceImpl\u3011add rpc operation : {}", (Object)operation.getLong("id"));
                rpcOperationList.add(opConfigObj);
            }
        };
    }

    private Consumer<DynamicObject> printOperationLog() {
        return operation -> logger.info("\u3010AutoRuleServiceImpl\u3011operation : {}", (Object)operation.getLong("id"));
    }

    private Map<Long, DynamicObject> getOpConfigByScene(String sceneNumber) {
        DynamicObject[] audoOperateObjs = RuleConfigHelper.getAutoOperateByScene(sceneNumber);
        HashMap audoOperateObjMap = Maps.newHashMapWithExpectedSize((int)audoOperateObjs.length);
        for (DynamicObject audoOperateObj : audoOperateObjs) {
            audoOperateObjMap.put(audoOperateObj.getLong("id"), audoOperateObj);
        }
        return audoOperateObjMap;
    }

    private List<Map<String, Object>> getMatchRuleList(SceneResult sceneResult) {
        List policyResults = sceneResult.getPolicyResults();
        ArrayList matchRuleList = Lists.newArrayListWithCapacity((int)16);
        policyResults.forEach(policyResult -> this.getMatchRule(matchRuleList, (PolicyResult)policyResult));
        return matchRuleList;
    }

    private void getMatchRule(List<Map<String, Object>> matchRuleList, PolicyResult policyResult) {
        HashMap allRuleInfoMap = Maps.newHashMapWithExpectedSize((int)8);
        allRuleInfoMap.put(MatchRule.LIST_MATCH.ordinal(), this.toCollections(policyResult.getRosterResults()));
        if (policyResult.getRuleResults() != null) {
            allRuleInfoMap.put(MatchRule.RULE_MATCH.ordinal(), policyResult.getRuleResults().stream().map(RuleResult::getMatchResults).collect(Collectors.toList()));
        }
        allRuleInfoMap.put(MatchRule.LIST_MATCH.ordinal(), this.toCollections(policyResult.getDefaultResults()));
        for (MatchRule matchRule : MatchRule.values()) {
            List matchReuslts = (List)allRuleInfoMap.get(matchRule.ordinal());
            if (matchReuslts == null) continue;
            matchRuleList.addAll(matchReuslts);
            break;
        }
    }

    private List<Map<String, Object>> toCollections(Map<String, Object> matchRuleMap) {
        return matchRuleMap != null && matchRuleMap.size() > 0 ? Collections.singletonList(matchRuleMap) : null;
    }

    private Map<String, Object> invokeRuleEngine(String appNumber, String sceneNumber, String buNumber, Map<String, Object> sceneInputParam, List<Long> policyIds) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)8);
        requestMap.put("bizApp", appNumber);
        requestMap.put("sceneNumber", sceneNumber);
        requestMap.put("buNumber", buNumber);
        requestMap.put("executePolicyIds", policyIds);
        requestMap.put("inputParams", sceneInputParam);
        Map<String, Object> invokeResult = HRMServiceHelperImpl.Singleton.INSTANCE.getInstance().callRuleEngine(requestMap);
        return invokeResult;
    }

    private void autoInvokeOp(Map<String, Object> matchResult, List<DynamicObject> opOperationList) {
        if (opOperationList.isEmpty()) {
            return;
        }
        logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp ruleInfoMap {}", matchResult);
        for (DynamicObject opConfigObj : opOperationList) {
            this.invokeOperate(matchResult, opConfigObj);
        }
    }

    private void invokeOperate(Map<String, Object> ruleInfoMap, DynamicObject opConfigObj) {
        String opKey = opConfigObj.getString("opname");
        String bizobj = opConfigObj.getString("bizobj");
        DynamicObjectCollection paramEntitys = opConfigObj.getDynamicObjectCollection("parentryentity");
        if (paramEntitys.isEmpty()) {
            logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp paramEntitys empty");
            return;
        }
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        OperateOption option = OperateOption.create();
        paramEntitys.forEach(paramObj -> {
            String fieldKey = paramObj.getString("paramnumber");
            Object value = ruleInfoMap.get(fieldKey);
            if (value == null) {
                logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp param not match ({},{})", (Object)fieldKey, (Object)bizobj);
            } else {
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getLong("id");
                } else if (value instanceof DynamicObjectCollection) {
                    value = ((DynamicObjectCollection)value).stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                }
                option.setVariableValue(fieldKey, value.toString());
            }
        });
        logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp opKey , bizobj , ids ({},{},{})", new Object[]{opKey, bizobj, JSON.toJSON((Object)ids)});
        logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp params match ({},{})", (Object)option.getVariables(), (Object)bizobj);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)bizobj, (Object[])ids.toArray(), (OperateOption)option);
        logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeOp result: {}", (Object)JSON.toJSONString((Object)operationResult));
    }

    private void autoInvokeRpc(Map<String, Object> matchResultMap, List<DynamicObject> rpcOperationList, Map<String, Object> sceneInputParam) {
        if (rpcOperationList.isEmpty()) {
            return;
        }
        matchResultMap.putAll(sceneInputParam);
        for (DynamicObject opConfigObj : rpcOperationList) {
            String cloud = opConfigObj.getString("cloud");
            String app = opConfigObj.getString("app");
            String service = opConfigObj.getString("servicename");
            String method = opConfigObj.getString("methodname");
            DynamicObjectCollection paramEntitys = opConfigObj.getDynamicObjectCollection("parentryentity");
            paramEntitys.sort(Comparator.comparing(dynamicObject -> dynamicObject.getInt("paramindex")));
            ArrayList rpcParams = Lists.newArrayListWithCapacity((int)paramEntitys.size());
            paramEntitys.forEach(paramObj -> {
                String fieldKey = paramObj.getString("paramnumber");
                Object value = matchResultMap.get(fieldKey);
                if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getLong("id");
                } else if (value instanceof DynamicObjectCollection) {
                    value = ((DynamicObjectCollection)value).stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                }
                rpcParams.add(value);
            });
            logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeRpc params match {} ({},{})", new Object[]{rpcParams, service, method});
            this.autoInvokeRpc(cloud, app, service, method, rpcParams);
        }
    }

    private void autoInvokeRpc(String cloud, String app, String service, String method, List<Object> rpcParams) {
        Object invokeBizResult = DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])rpcParams.toArray());
        logger.info("\u3010AutoRuleServiceImpl\u3011autoInvokeRpc result: {}", invokeBizResult);
    }

    public static enum Singleton {
        INSTANCE;

        private final AutoRuleServiceImpl instance = new AutoRuleServiceImpl();

        public AutoRuleServiceImpl getInstance() {
            return this.instance;
        }
    }
}

