/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.rule.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.lang.Lang;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.enums.RuleEngineEnum;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class RuleTextParUtil {
    static Set<String> replaceOptList = Sets.newHashSetWithExpectedSize((int)10);

    public static String getConditionPreviewStr(String conditions) {
        conditions = RuleUtil.getNewestConditionValue((String)conditions);
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        StringBuilder previewSb = new StringBuilder();
        Map<String, ConditionInfo> conditionInfoMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, condition -> condition));
        conditionExpressList.forEach(conditionExpressInfo -> {
            String logical;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                previewSb.append(leftBracket).append(' ');
            }
            ConditionInfo info = (ConditionInfo)conditionInfoMap.get(conditionExpressInfo.getName());
            previewSb.append(info.getDisplayParam()).append(' ');
            if (RuleTextParUtil.isReplaceOpt(info.getOperators())) {
                String content = RuleEngineEnum.getEnum((String)info.getOperators()).getName().replace("/", ResManager.loadKDString((String)"\u6216\u8005\u662f", (String)"RuleTextParUtil_3", (String)"tsc-tsrbd-common", (Object[])new Object[0])).replace("...", info.getDisplayValue());
                previewSb.append(content).append(' ');
            } else {
                previewSb.append(RuleEngineEnum.getEnum((String)info.getOperators()).getName()).append(' ');
                String value = info.getDisplayValue();
                if (HRStringUtils.isNotEmpty((String)value)) {
                    previewSb.append(value).append(' ');
                }
            }
            String rightBracket = conditionExpressInfo.getRightBracket();
            if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                previewSb.append(rightBracket).append(' ');
            }
            if (HRStringUtils.isNotEmpty((String)(logical = conditionExpressInfo.getLogical()))) {
                previewSb.append(RuleTextParUtil.getLogicLocaleStr(logical)).append(' ');
            }
        });
        return previewSb.toString();
    }

    private static boolean isReplaceOpt(String opt) {
        return (Lang.zh_CN.equals((Object)Lang.get()) || Lang.zh_TW.equals((Object)Lang.get())) && replaceOptList.contains(opt);
    }

    public static String getResultPreviewStr(String results) {
        results = RuleUtil.getNewestResultValue((String)results);
        RuleResultInfo resultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)results, RuleResultInfo.class);
        List resultInfoList = resultInfo.getResultList();
        StringBuilder previewSb = new StringBuilder();
        resultInfoList.forEach(info -> {
            previewSb.append(info.getDisplayParam()).append(' ');
            previewSb.append(RuleEngineEnum.getEnum((String)info.getOperators()).getName()).append(' ');
            previewSb.append(info.getDisplayValue()).append(' ');
            previewSb.append(';').append(' ');
        });
        return previewSb.toString();
    }

    private static String getLogicLocaleStr(String logic) {
        return HRStringUtils.equals((String)logic.trim(), (String)"and") ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"RuleTextParUtil_1", (String)"tsc-tsrbd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"RuleTextParUtil_2", (String)"tsc-tsrbd-common", (Object[])new Object[0]);
    }

    static {
        replaceOptList.add(RuleEngineEnum.IN.getValue());
        replaceOptList.add(RuleEngineEnum.NOT_IN.getValue());
        replaceOptList.add(RuleEngineEnum.IS_OR_IS_SUB.getValue());
        replaceOptList.add(RuleEngineEnum.STARTS_WITH.getValue());
        replaceOptList.add(RuleEngineEnum.ENDS_WITH.getValue());
    }
}

