/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.seclevel.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SecConfHelper {
    private static final Log logger = LogFactory.getLog(SecConfHelper.class);

    public static boolean querySecurityConf(Long pkId) {
        boolean flag = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securityfunconf");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("id", "=", (Object)pkId));
        DynamicObject[] dynObjTalent = serviceHelper.query("", qFilter.toArray());
        if (dynObjTalent.length > 0) {
            flag = true;
        }
        return flag;
    }

    public static DynamicObjectCollection listSecurityConf(Long pkId) {
        int index = 0;
        DynamicObjectCollection resDy = new DynamicObjectCollection();
        DynamicObject[] dyn = SecConfHelper.querySecResult(pkId);
        if (dyn.length > 0) {
            DynamicObjectCollection secDynObj = (DynamicObjectCollection)dyn[0].get("secfunconfentity");
            for (DynamicObject sec : secDynObj) {
                if (!HRStringUtils.equals((String)"true", (String)sec.getString("levelswitch"))) continue;
                resDy.add(index, sec.getDynamicObject("code"));
                ++index;
            }
        }
        return resDy;
    }

    private static DynamicObject[] querySecResult(Long pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securityfunconf");
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        CharSequence[] joinTmp = new String[]{"secfunconfentity.code", "secfunconfentity.levelswitch"};
        String selectProperties = String.join((CharSequence)",", joinTmp);
        DynamicObject[] dyn = serviceHelper.query(selectProperties, qFilter.toArray());
        return dyn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMsg(String securityFunConfId, String flag) {
        if (HRStringUtils.isEmpty((String)securityFunConfId) || HRStringUtils.isEmpty((String)flag)) {
            logger.info("SecurityConfHelper.publishMsg.input.securityFunConfId{}", (Object)securityFunConfId);
            logger.info("SecurityConfHelper.publishMsg.input.flag{}", (Object)flag);
            return;
        }
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("tsc", "tsc.tsrbd.securityconf.queue.switch");
            pub.publish(flag);
            logger.info("SecurityConfHelper.publishMsg.success.securityFunConfId:{}", (Object)securityFunConfId);
        }
    }

    public static DynamicObject[] queryEnable(List<Long> list) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_securityfunconf");
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObject[] dyObjs = hrBaseServiceHelper.query("enable", qFilter.toArray());
        return dyObjs;
    }

    public static DynamicObject[] querySecLevel() {
        DynamicObject[] ds = BusinessDataServiceHelper.load((String)"tsrbd_securitylevel", (String)"codelevel", null, (String)"index");
        return ds;
    }

    public static DynamicObject[] querySecSwitch() {
        CharSequence[] joinTmp = new String[]{"secfunconfentity.code", "secfunconfentity.levelswitch"};
        String selectProperties = String.join((CharSequence)",", joinTmp);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_securityfunconf");
        DynamicObject[] ds = hrBaseServiceHelper.query(selectProperties, null);
        return ds;
    }

    public static DynamicObject[] queryNoPriSec() {
        QFilter qFilter = new QFilter("id", "!=", (Object)1010L);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_securitylevel");
        DynamicObject[] col = hrBaseServiceHelper.query("id,number,codelevel", qFilter.toArray(), "id");
        return col;
    }
}

