/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.seclevel.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;
import kd.tsc.tsrbd.common.constants.seclevel.SeclevelConstants;

public class SecuserHelper {
    public static DynamicObject queryUserSecurityLevel(Long userId, Long securityFunConfId) {
        boolean isOpen = SecConfHelper.querySecurityConf(securityFunConfId);
        if (!isOpen) {
            return null;
        }
        QFilter qFilter = new QFilter("userid", "=", (Object)userId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_secuserlevel");
        DynamicObject userLevel = serviceHelper.loadDynamicObject(qFilter);
        DynamicObject openLevel = SecuserHelper.getSecurityLevel(SeclevelConstants.OPEN_LEVEL_ID);
        if (null == userLevel) {
            return openLevel;
        }
        Integer status = SecuserHelper.queryUserStatus(userId);
        if (status != 1) {
            return openLevel;
        }
        DynamicObjectCollection levelEntry = userLevel.getDynamicObjectCollection("tsrbd_levelentry");
        for (DynamicObject object : levelEntry) {
            DynamicObject funDy = object.getDynamicObject("functionlevel");
            if (funDy == null) {
                return openLevel;
            }
            long funNumber = funDy.getLong("id");
            if (funNumber != securityFunConfId) continue;
            DynamicObject level = object.getDynamicObject("userlevel");
            return level == null ? openLevel : level;
        }
        return openLevel;
    }

    public static DynamicObject[] queryOpenFunction() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securityfunconf");
        DynamicObject[] dynamicObjects = serviceHelper.query(qFilter.toArray(), "id asc");
        return dynamicObjects;
    }

    public static DynamicObject[] querySecUserInfoList() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_secuserlevel");
        return serviceHelper.loadDynamicObjectArray(null);
    }

    public static DynamicObject queryOneSecUserInfo(Object pkValue) {
        QFilter qFilter = new QFilter("userid.id", "=", pkValue);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_secuserlevel");
        return serviceHelper.loadDynamicObject(qFilter);
    }

    public static void saveSecUserInfoList(DynamicObject[] array) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_secuserlevel");
        serviceHelper.save(array);
    }

    public static DynamicObject getSecurityLevel(Long securityLevelId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securitylevel");
        QFilter qFilter = new QFilter("id", "=", (Object)securityLevelId);
        return serviceHelper.loadDynamicObject(qFilter);
    }

    public static DynamicObject[] getSecurityLevels() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_securitylevel");
        QFilter qFilter = new QFilter("id", "!=", (Object)1010L);
        qFilter.and(new QFilter("id", "!=", (Object)1070L));
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static Integer queryUserStatus(Long userId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_secuserlevel");
        QFilter qFilter = new QFilter("userid", "=", (Object)userId);
        DynamicObject user = serviceHelper.loadDynamicObject(qFilter);
        if (user != null) {
            return user.getInt("status");
        }
        return 3;
    }
}

