/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.domain.workaddress.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class WorkAddressDataHelper {
    private static final String ADMIN_DIVISION_ENTITY = "bd_admindivision";
    private static final Long EMPTY_BASE_DATA = 0L;

    private WorkAddressDataHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject getCityDymByName(String cityName) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ADMIN_DIVISION_ENTITY);
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)cityName)};
        return hrBaseServiceHelper.queryOriginalOne("id,name,country", filters);
    }

    public static List<Long> getAllCountryId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        String selectProperties = "id,country";
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C")};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        return Stream.of(result).map(object -> object.getLong("country")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllCityId() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        String selectProperties = "id,name,city";
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C")};
        DynamicObject[] result = hrBaseServiceHelper.queryOriginalArray(selectProperties, filters);
        List<DynamicObject> positionList = Arrays.asList(result);
        return positionList.stream().map(object -> object.getLong("city")).filter(object -> !EMPTY_BASE_DATA.equals(object)).distinct().collect(Collectors.toList());
    }

    public static List<Long> getAllWorkAddressPkId(List<Long> cityIdList) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_workaddr");
        QFilter[] filters = new QFilter[]{new QFilter("city", "in", cityIdList)};
        DynamicObject[] result = hrBaseServiceHelper.query(filters);
        return Stream.of(result).map(object -> object.getLong("id")).collect(Collectors.toList());
    }
}

