/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbd.business.utils;

import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizAttachmentUtil {
    private static final Log logger = LogFactory.getLog(BizAttachmentUtil.class);
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private static final TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();

    public static List<Map<String, Object>> copyAttachments(List<Map<String, Object>> sourceAttachments) {
        if (sourceAttachments == null || sourceAttachments.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> newAttachments = new ArrayList<Map<String, Object>>(sourceAttachments.size());
        for (Map<String, Object> map : sourceAttachments) {
            Map<String, Object> newAttachment = BizAttachmentUtil.buildAttachment((String)map.get("entityNum"), (String)map.get("url"), (String)map.get("name"), (Long)map.get("size"), (String)map.get("status"));
            newAttachments.add(newAttachment);
        }
        return newAttachments;
    }

    public static List<Map<String, Object>> copyAndSaveTempAttachments(List<Map<String, Object>> sourceAttachments) {
        List<Map<String, Object>> attachments = BizAttachmentUtil.copyAttachments(sourceAttachments);
        for (Map<String, Object> map : attachments) {
            String url = (String)map.get("url");
            String name = (String)map.get("name");
            String tempUrl = BizAttachmentUtil.saveAsTempFile(url, name);
            map.put("url", tempUrl);
        }
        return attachments;
    }

    public static Map<String, Object> buildAttachment(String formId, String url, String name, Long size, String status) {
        HashMap<String, Object> attachment = new HashMap<String, Object>();
        attachment.put("url", url);
        attachment.put("uid", "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100));
        attachment.put("name", name);
        attachment.put("size", size);
        attachment.put("status", status);
        attachment.put("entityNum", formId);
        attachment.put("billPkId", "0");
        return attachment;
    }

    public static void bindAttachments(AttachmentPanel attachmentpanel, List<Map<String, Object>> sourceAttachments) {
        List<Map<String, Object>> attchments = BizAttachmentUtil.copyAttachments(sourceAttachments);
        attachmentpanel.upload(attchments);
    }

    private static String saveAsTempFile(String url, String name) {
        String path = url.split("download.do\\?path=")[1];
        logger.info("BizAttachmentUtil.saveAsTempFile url={},path={}", (Object)url, (Object)path);
        InputStream inputStream = fileService.getInputStream(path);
        String tempUrl = tempFileCache.saveAsFullUrl(name, inputStream, 7200);
        logger.info("BizAttachmentUtil.saveAsTempFile tempUrl={}", (Object)tempUrl);
        return tempUrl;
    }

    public static void uploadAndSaveAttachments(String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments) {
        if (attachments != null && attachments.size() > 0) {
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
            for (Map<String, Object> attachment : attachments) {
                String result = AttachmentServiceHelper.saveTempToFileService((String)((String)attachment.get("url")), (String)appId, (String)formId, (Object)pkId, (String)((String)attachment.get("name")));
                logger.info("BizAttachmentUtil.uploadAndSaveAttachments url={}", (Object)result);
                attachment.put("url", result);
            }
            AttachmentServiceHelper.upload((String)formId, (Object)pkId, (String)attachKey, attachments);
            logger.info("BizAttachmentUtil.uploadAndSaveAttachments upload");
        }
    }

    public static void uploadAttachments(String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments) {
        if (attachments != null && attachments.size() > 0) {
            AttachmentServiceHelper.upload((String)formId, (Object)pkId, (String)attachKey, attachments);
            logger.info("BizAttachmentUtil.uploadAndSaveAttachments upload");
        }
    }
}

