/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.mservice.consumer;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.tsc.tsrbs.business.ServiceFactory;
import kd.tsc.tsrbs.business.application.CoordinationApplicationService;
import kd.tsc.tsrbs.business.domain.util.MsgCenterUtils;
import kd.tsc.tsrbs.mservice.api.consumer.ITSCBizMsgConsumerService;

public class TSCBizMsgConsumerService
implements ITSCBizMsgConsumerService {
    private static final Log LOG = LogFactory.getLog(TSCBizMsgConsumerService.class);
    private final CoordinationApplicationService coordinationApplicationService = (CoordinationApplicationService)ServiceFactory.getService(CoordinationApplicationService.class);

    public HRMServiceResult consumerSaveMsg(DynamicObject coordinationLog) {
        DynamicObject coordinationMsg;
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)coordinationLog.getString("msgcontent"));
        LOG.info(MessageFormat.format("TCSBizMsgConsumerService.consumerSaveMsg(): msgContent is {0}", msgContent));
        Long msgCenterBoId = coordinationLog.getLong("msgcenterbo");
        DLock lock = DLock.create((String)String.valueOf(msgCenterBoId));
        HRMServiceResult result = HRMServiceResult.success();
        if (!lock.tryLock()) {
            LOG.error("TCSBizMsgConsumerService.consumerSaveMsg(): try lock time out");
            throw new RuntimeException("consumer save msg fail");
        }
        try {
            boolean isExistsMsg = this.coordinationApplicationService.isCoordinationMsgExists(msgCenterBoId);
            if (isExistsMsg) {
                HRMServiceResult hRMServiceResult = result;
                return hRMServiceResult;
            }
            coordinationMsg = this.coordinationApplicationService.saveHRBizCoordinationMsg(coordinationLog);
            MsgCenterUtils.successConsumeMsg((DynamicObject)coordinationLog);
        }
        catch (Exception exp) {
            LOG.error("TCSBizMsgConsumerService.consumerSaveMsg(): consumer save msg error,", (Throwable)exp);
            throw exp;
        }
        finally {
            lock.unlock();
        }
        this.coordinationApplicationService.createCoordinationTasks(coordinationMsg);
        return result;
    }
}

