/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.opplugin.validator.coordination;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsrbs.business.ServiceFactory;
import kd.tsc.tsrbs.business.domain.service.CoordinationTaskDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordinationValidatorDomainService;
import kd.tsc.tsrbs.common.constants.coordination.CoordExecuteTypeEnum;

public class CoordinationTaskValidator
extends HRDataBaseValidator {
    private final CoordinationValidatorDomainService coordinationValidatorDomainService = (CoordinationValidatorDomainService)ServiceFactory.getService(CoordinationValidatorDomainService.class);
    private final CoordinationTaskDomainService coordinationTaskDomainService = (CoordinationTaskDomainService)ServiceFactory.getService(CoordinationTaskDomainService.class);

    public void validate() {
        super.validate();
        if (this.dataEntities == null || this.dataEntities.length < 1) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject taskDy = dataEntity.getDataEntity();
            Map validateResult = this.coordinationValidatorDomainService.validate(taskDy, CoordExecuteTypeEnum.MANUAL_EXECUTION.getType());
            if (Boolean.parseBoolean((String)validateResult.get("result"))) continue;
            this.addMessage(dataEntity, (String)validateResult.get("errorMsg"), ErrorLevel.Error);
        }
    }
}

