/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.opplugin.validator.foreignadminorg;

import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignBindExternalOrgHelper;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignSynStatusEnum;

public class ForeignChgTenantOrgCommitValidator
extends HRDataBaseValidator {
    public static final String QUERY_PERM = "47150e89000000ac";
    ForeignBindExternalOrgHelper bindExternalOrgHelper = ForeignBindExternalOrgHelper.Singleton.INSTANCE.getInstance();

    public void validate() {
        super.validate();
        long userId = RequestContext.get().getCurrUserId();
        String bizAppNumber = (String)this.getOption().getVariables().get("appnumber");
        boolean hasFunctionPerm = PermissionServiceHelper.checkPermission((Long)userId, (String)bizAppNumber, (String)this.entityKey, (String)QUERY_PERM);
        if (!hasFunctionPerm) {
            String entityName = MetadataServiceHelper.getDataEntityType((String)this.entityKey).getDisplayName().getLocaleValue();
            String tipMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\"%s\"\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ForeignSelectFunctionValidator_0", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]), entityName);
            this.addMessage(this.getDataEntities()[0], tipMsg, ErrorLevel.FatalError);
        } else {
            String synchstatus;
            DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
            long tenantId = dataEntity.getLong("tenantid");
            DynamicObject bindTenantOb = this.bindExternalOrgHelper.queryByTenantId(tenantId);
            String enable = bindTenantOb.getString("enable");
            if (enable.equals("0")) {
                this.addMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"\u751f\u6001\u4f19\u4f34\u79df\u6237\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SynedAdminOrgViewPlugin_7", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (ForeignSynStatusEnum.SYNCHRONIZING.code.equals(synchstatus = bindTenantOb.getString("synchstatus"))) {
                this.addMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"\u8be5\u79df\u6237\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u884c\u653f\u7ec4\u7ec7\u540c\u6b65\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SynedAdminOrgViewPlugin_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
    }
}

