/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import java.util.Objects;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;

public class CacheUtils {
    private static final int MAX_ITEM_SIZE = 5000;
    private static final int TIMEOUT = 600;
    private static final String CUSTOM_REGION = "customRegion";
    private static final String TSRBS_REGION = "tsrbs_region";
    private static final String TSRBS_TYPE = "basedata";
    private static CacheConfigInfo localConfig;

    public static LocalMemoryCache getLocalMemoryCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(TSRBS_REGION, TSRBS_TYPE, CacheUtils.getCacheConfigInfo());
    }

    public static LocalMemoryCache getLocalMemoryCache(String region, String type) {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, type, CacheUtils.getCacheConfigInfo());
    }

    public static DistributeSessionlessCache getDistributeSessionlessCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CUSTOM_REGION);
    }

    public static CacheConfigInfo getCacheConfigInfo() {
        if (Objects.nonNull(localConfig)) {
            return localConfig;
        }
        localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(600);
        return localConfig;
    }
}

