/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class ClassUtils {
    public static List<Class> getAllClassByInterface(Class clas) throws Exception {
        ArrayList classList = Lists.newArrayList();
        if (!clas.isInterface()) {
            return classList;
        }
        String packName = clas.getPackage().getName();
        List<Class> allClass = ClassUtils.getClass(packName);
        allClass.stream().filter(clas::isAssignableFrom).filter(clazz -> !clas.equals(clazz)).forEach(classList::add);
        return classList;
    }

    private static List<Class> getClass(String packName) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String path = packName.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList fileList = Lists.newArrayList();
        while (resources.hasMoreElements()) {
            fileList.add(new File(resources.nextElement().getFile()));
        }
        ArrayList classes = Lists.newArrayList();
        for (File directory : fileList) {
            classes.addAll(ClassUtils.findClasses(directory, packName));
        }
        return classes;
    }

    private static List<Class> findClasses(File directory, String name) throws Exception {
        LinkedList classes = Lists.newLinkedList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return new ArrayList<Class>();
        }
        for (File file : files) {
            if (file.isDirectory()) {
                if (!file.getName().contains(".")) {
                    return classes;
                }
                classes.addAll(ClassUtils.findClasses(file, name + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(name + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

