/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class DynamicObjectUtils {
    public static String serializeDynamicObjects(DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length > 0) {
            return DynamicObjectSerializeUtil.serialize((Object[])dynamicObjects, (DynamicObjectType)dynamicObjects[0].getDynamicObjectType());
        }
        return "[]";
    }

    public static String serializeDynamicObject(DynamicObject dynamicObject) {
        return DynamicObjectUtils.serializeDynamicObjects(new DynamicObject[]{dynamicObject});
    }

    public static DynamicObject[] deserializeDynamicObjects(String jsonStr, String pageNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pageNumber);
        return DynamicObjectUtils.deserializeDynamicObjects(jsonStr, (DynamicObjectType)dataEntityType);
    }

    public static DynamicObject[] deserializeDynamicObjects(String jsonStr, DynamicObjectType dynamicObjectType) {
        return (DynamicObject[])DynamicObjectSerializeUtil.deserialize((String)jsonStr, (DynamicObjectType)dynamicObjectType);
    }

    public static Map<Object, DynamicObject> dyoArrayToMap(DynamicObject[] dynamicObjects, String key) {
        DynamicProperty property = null;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (property == null) {
                property = dynamicObject.getDynamicObjectType().getProperty(key);
            }
            resultMap.put(property.getValueFast((Object)dynamicObject), dynamicObject);
        }
        return resultMap;
    }

    public static Map<Object, DynamicObject> dyoCollToMap(Collection<DynamicObject> dynamicObjects, String key) {
        DynamicProperty property = null;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (property == null) {
                property = dynamicObject.getDynamicObjectType().getProperty(key);
            }
            resultMap.put(property.getValueFast((Object)dynamicObject), dynamicObject);
        }
        return resultMap;
    }
}

