/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PropertiesUtils {
    private static final Log log = LogFactory.getLog(PropertiesUtils.class);

    private PropertiesUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties read(String filePath) {
        Properties properties = new Properties();
        ClassLoader classLoader = PropertiesUtils.class.getClassLoader();
        if (classLoader == null) {
            return null;
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(filePath);){
            if (inputStream == null) {
                Properties properties2 = null;
                return properties2;
            }
            properties.load(inputStream);
            return properties;
        }
        catch (IOException e) {
            log.error("IOException:", (Throwable)e);
            return null;
        }
    }

    public static String getString(Properties properties, String name) {
        return properties.getProperty(name).trim();
    }

    public static Integer getInt(Properties properties, String name) {
        String str = properties.getProperty(name).trim();
        if (str.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static Long getLong(Properties properties, String name) {
        String str = properties.getProperty(name).trim();
        if (str.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(str);
    }
}

