/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.hr.hbp.common.util.HRStringUtils;

public class TSCBaseUtils {
    public static String getSelectProperties(MainEntityType mainEntityType) {
        List<String> allFields = TSCBaseUtils.getAllFields(mainEntityType);
        return TSCBaseUtils.join(allFields, ",");
    }

    public static String getSelectProperties(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return TSCBaseUtils.getSelectProperties(mainEntityType);
    }

    public static String join(List<String> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String obj : arr) {
            sb.append((Object)obj).append(separator);
        }
        return sb.length() > 0 ? sb.substring(0, sb.lastIndexOf(separator)) : null;
    }

    public static List<String> getAllFields(MainEntityType mainEntityType) {
        ArrayList<String> fields = new ArrayList<String>();
        Map fieldTypeMap = mainEntityType.getAllFields();
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
                continue;
            }
            fields.add(entityProperty.getName());
        }
        return fields;
    }

    public static String getSelectPropertiesString(String ... params) {
        return String.join((CharSequence)",", params);
    }

    public static String getSelPropDot(String ... params) {
        return String.join((CharSequence)".", params);
    }

    public static String getString(String str) {
        return HRStringUtils.isNotEmpty((String)str) ? str : "";
    }

    private TSCBaseUtils() {
    }
}

