/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import org.apache.commons.lang3.ObjectUtils;

public class TscTreeUtils {
    public static TreeNode renderRoot() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TscTreeUtils_0", (String)"tsc-tsrbs-common", (Object[])new Object[0]));
        root.setId("1");
        root.setIsOpened(true);
        root.setParentid("");
        return root;
    }

    public static TreeNode unRenderRoot() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u9690\u85cf\u5168\u90e8", (String)"TscTreeUtils_1", (String)"tsc-tsrbs-common", (Object[])new Object[0]));
        root.setId("0");
        root.setIsOpened(true);
        root.setParentid("");
        return root;
    }

    public static TreeNode attentionRoot() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u6211\u7684\u5173\u6ce8", (String)"TscTreeUtils_2", (String)"tsc-tsrbs-common", (Object[])new Object[0]));
        root.setId("2");
        root.setIsOpened(true);
        root.setParentid("");
        return root;
    }

    public static TreeNode getTreeNode(DynamicObject dyc, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(dyc.getString("id"));
        treeNode.setText(dyc.getString("name"));
        treeNode.setParentid(parentId);
        return treeNode;
    }

    public static TreeNode getCreateTreeNode(DynamicObject dyc, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(dyc.getString("id"));
        treeNode.setText(dyc.getString("name") + "(" + dyc.get("creator.name") + ")");
        treeNode.setParentid(parentId);
        return treeNode;
    }

    public static void searchTalentTree(String searchText, IFormView view, IPageCache viewPageCache, ITreeListView viewTreeListView) {
        List treeNodes;
        TreeView treeListView = (TreeView)view.getControl("treeview");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)viewPageCache.get(treeListView.getKey()), TreeNode.class);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String searchNodesCacheKey = view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (TscTreeUtils.isNotNullText(oldSearchText, searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"TscTreeUtils_3", (String)"tsc-tsrbs-common", (Object[])new Object[0]));
        } else {
            TreeView treeView = null;
            treeView = viewTreeListView == null ? treeListView : viewTreeListView.getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                TscTreeUtils.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                TscTreeUtils.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private static boolean isNotNullText(String oldSearchText, String searchText) {
        return null != oldSearchText && !oldSearchText.equals(searchText);
    }

    private static void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        TscTreeUtils.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private static void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentId = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            TreeNode treeNode = rootNode.getTreeNode(parentId, 20);
            if (treeNode != null) {
                TscTreeUtils.expandParents(treeView, rootNode, treeNode);
                treeView.expand(parentId);
                if (treeNode == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public static TreeNode getTreeNodeInterviewer(DynamicObject dyc, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(parentId + "&" + dyc.getString("id"));
        treeNode.setText(dyc.getString("name"));
        treeNode.setParentid(parentId);
        return treeNode;
    }

    public static TreeNode getTreeNodeIntvInfo(Long objId, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(objId.toString());
        treeNode.setParentid(parentId);
        return treeNode;
    }

    public static TreeNode getTreeNode(DynamicObject dyc, String parentId, int openLevel) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(dyc.getString("id"));
        treeNode.setText(dyc.getString("name"));
        treeNode.setParentid(parentId);
        int level = dyc.getInt("level");
        if (level < openLevel) {
            treeNode.setIsOpened(true);
        } else {
            treeNode.setIsOpened(false);
        }
        return treeNode;
    }

    public static List<TreeNode> getTreeNodeAll(TreeNode currentTreeNode) {
        ArrayList<TreeNode> allTreeNodeList = new ArrayList<TreeNode>(16);
        List childrenList = currentTreeNode.getChildren();
        if (ObjectUtils.isNotEmpty((Object)childrenList)) {
            for (TreeNode children : childrenList) {
                allTreeNodeList.add(children);
                if (!ObjectUtils.isNotEmpty((Object)children.getChildren())) continue;
                List<TreeNode> treeNodeAll = TscTreeUtils.getTreeNodeAll(children);
                allTreeNodeList.addAll(treeNodeAll);
            }
        }
        return allTreeNodeList;
    }
}

