/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils.verifycode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import kd.tsc.tsrbs.common.utils.verifycode.Context;
import kd.tsc.tsrbs.common.utils.verifycode.font.FontColor;

public class ImageManger {
    private final SecureRandom random = new SecureRandom();
    private final Context context;
    private final StringBuilder codeBuilder = new StringBuilder();

    public ImageManger(Context context) {
        this.context = context;
        this.fillBackColor();
    }

    private void randomCode(Graphics2D g2, int index) {
        int randomIndex = this.random.nextInt(this.context.codes.length());
        String code = Character.toString(this.context.codes.charAt(randomIndex));
        int xios = index * this.context.imageWith / this.context.charSize;
        g2.setFont(this.randomFont());
        g2.setColor(FontColor.randomColor(null));
        g2.drawString(code, xios, this.context.imageHight - 5);
        this.codeBuilder.append(code);
    }

    private Font randomFont() {
        int index = this.random.nextInt(this.context.fontNames.length);
        String fontName = this.context.fontNames[index];
        int style = this.random.nextInt(4);
        int size = this.random.nextInt(6) + 15;
        return new Font(fontName, style, size);
    }

    private void fillBackColor() {
        Graphics graphics = this.context.imageBuff.getGraphics();
        graphics.setColor(this.context.backColor);
        graphics.fillRect(0, 0, this.context.imageWith, this.context.imageHight);
    }

    private void drawLine() {
        Graphics2D g2 = (Graphics2D)this.context.imageBuff.getGraphics();
        for (int index = 0; index < this.context.drawLineSize; ++index) {
            g2.setStroke(new BasicStroke(1.5f));
            g2.setColor(Color.BLUE);
            g2.drawLine(this.random.nextInt(), this.random.nextInt(), this.random.nextInt(), this.random.nextInt());
        }
    }

    private void drawImgCode() {
        Graphics2D g2 = (Graphics2D)this.context.imageBuff.getGraphics();
        for (int index = 0; index < this.context.charSize; ++index) {
            this.randomCode(g2, index);
        }
    }

    public ImageManger createImage() {
        this.drawImgCode();
        this.drawLine();
        return this;
    }

    public String getCodeStr() {
        return this.codeBuilder.toString();
    }

    public BufferedImage getImgBuff() {
        return this.context.imageBuff;
    }
}

