/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.common.utils.verifycode.service;

import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.login.CacheLoginData;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.common.utils.verifycode.Context;
import kd.tsc.tsrbs.common.utils.verifycode.ImageManger;
import kd.tsc.tsrbs.common.utils.verifycode.dto.VerifyCodeDto;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public interface IVerifyCode {
    public static final int validTime = 60000;
    public static final String defBusType = "login";
    public static final int cacheTimeout = 60;

    default public VerifyCodeDto getVerifyCode(String busType) throws IOException {
        busType = Optional.ofNullable(busType).orElse(defBusType);
        String authCode = UUID.randomUUID().toString();
        ImageManger imageManager = Context.build().setImageWith(69).setImageHight(28).start();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)imageManager.getImgBuff(), "JPEG", out);
            String content = Base64.encodeBase64String((byte[])out.toByteArray());
            String value = imageManager.getCodeStr();
            CacheLoginData.setAttribute((String)busType, (String)authCode, (String)value, (int)60);
            VerifyCodeDto verifyCodeDto = VerifyCodeDto.build().setAuthCode(authCode).setCodeValidTime(60000).setContent("data:image/jpeg;base64," + content);
            return verifyCodeDto;
        }
    }

    default public boolean checkVerifyCode(String busType, String code, String authCode) {
        busType = Optional.ofNullable(busType).orElse(defBusType);
        if (HRStringUtils.isEmpty((String)code) || HRStringUtils.isEmpty((String)authCode)) {
            return false;
        }
        String attribute = CacheLoginData.getAttribute((String)busType, (String)authCode);
        return !StringUtils.isEmpty((CharSequence)attribute) && attribute.equalsIgnoreCase(code);
    }
}

